/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.mergeengine.orderby.comparable;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.bundle.BosRes;
import kd.bos.xdb.merge.feature.OrderByInfo;
import kd.bos.xdb.mergeengine.orderby.comparable.OrderByComparable;

public class ResultSetComparable
extends OrderByComparable {
    private ResultSet resultSet;

    public ResultSetComparable(ResultSet resultSet, OrderByInfo orderByInfo) {
        this.resultSet = resultSet;
        this.orderByInfo = orderByInfo;
    }

    public boolean next() throws SQLException {
        boolean result = this.resultSet.next();
        this.orderValues = result ? this.getOrderValues() : Collections.emptyList();
        return result;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    private List<Comparable<?>> getOrderValues() throws SQLException {
        if (this.orderByInfo == null) {
            return Collections.emptyList();
        }
        List<OrderByInfo.OrderByItem> items = this.orderByInfo.getOrderByItems();
        ArrayList result = new ArrayList(items.size());
        for (OrderByInfo.OrderByItem item : items) {
            Integer index = item.getIndex();
            if (index == null || index == 0) {
                throw new IllegalArgumentException(BosRes.get((String)"bos-xdb", (String)"OrderByComparator_0", (String)"\u5408\u5e76\u5206\u7247,order by\u7684\u8868\u8fbe\u5f0f\u5fc5\u987b\u51fa\u73b0\u5728select\u4e2d:{0}", (Object[])new Object[]{item.getField()}));
            }
            Object value = this.resultSet.getObject(index);
            result.add((Comparable)value);
        }
        return result;
    }
}

