/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.mergeengine.orderby.comparable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.store.Store;
import kd.bos.bundle.BosRes;
import kd.bos.xdb.merge.feature.OrderByInfo;
import kd.bos.xdb.mergeengine.orderby.comparable.OrderByComparable;

public class StoreComparable
extends OrderByComparable {
    private Store store;
    private Iterator<Row> storeIter;
    private Row curRow;

    public StoreComparable(Store store, OrderByInfo orderByInfo) {
        this.store = store;
        this.storeIter = this.store.getRowIterator();
        this.orderByInfo = orderByInfo;
    }

    public boolean next() {
        boolean hasNest = this.storeIter.hasNext();
        if (hasNest) {
            this.curRow = this.storeIter.next();
        }
        this.orderValues = hasNest ? this.getOrderValues() : Collections.emptyList();
        return hasNest;
    }

    public Row getCurRow() {
        return this.curRow;
    }

    private List<Comparable<?>> getOrderValues() {
        if (this.orderByInfo == null) {
            return Collections.emptyList();
        }
        List<OrderByInfo.OrderByItem> items = this.orderByInfo.getOrderByItems();
        ArrayList result = new ArrayList(items.size());
        for (OrderByInfo.OrderByItem item : items) {
            Integer index = item.getIndex();
            if (index == null || index == 0) {
                throw new IllegalArgumentException(BosRes.get((String)"bos-xdb", (String)"OrderByComparator_0", (String)"\u5408\u5e76\u5206\u7247,order by\u7684\u8868\u8fbe\u5f0f\u5fc5\u987b\u51fa\u73b0\u5728select\u4e2d:{0}", (Object[])new Object[]{item.getField()}));
            }
            Object value = this.curRow.get(index - 1);
            result.add((Comparable)value);
        }
        return result;
    }
}

