/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.mergeengine.orderby.segmerge;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.PriorityQueue;
import java.util.Queue;
import kd.bos.xdb.merge.feature.OrderByInfo;
import kd.bos.xdb.mergeengine.orderby.comparable.ResultSetComparable;
import kd.bos.xdb.mergeengine.orderby.segmerge.SetsOrderBy;

public class ResultSetsOrderBy
implements SetsOrderBy {
    private ResultSet[] resultSets;
    protected ResultSet currentResultSet;
    protected OrderByInfo orderByInfo;
    protected Queue<ResultSetComparable> resultSetQueue;
    protected boolean isFirstNext;
    private int colCount;

    public ResultSetsOrderBy(ResultSet[] resultSets, OrderByInfo orderByInfo) throws SQLException {
        this.resultSets = resultSets;
        this.orderByInfo = orderByInfo;
        this.init();
    }

    private void init() throws SQLException {
        this.resultSetQueue = new PriorityQueue<ResultSetComparable>(this.resultSets.length);
        for (ResultSet resultSet : this.resultSets) {
            ResultSetComparable resultSetComparable = new ResultSetComparable(resultSet, this.orderByInfo);
            if (!resultSetComparable.next()) continue;
            this.resultSetQueue.offer(resultSetComparable);
        }
        this.currentResultSet = this.resultSetQueue.isEmpty() ? this.resultSets[0] : this.resultSetQueue.peek().getResultSet();
        this.colCount = this.currentResultSet.getMetaData().getColumnCount();
        this.isFirstNext = true;
    }

    @Override
    public boolean hasNext() throws SQLException {
        if (this.resultSetQueue.isEmpty()) {
            return false;
        }
        if (this.isFirstNext) {
            this.isFirstNext = false;
            return true;
        }
        ResultSetComparable firstResultSet = this.resultSetQueue.poll();
        if (firstResultSet.next()) {
            this.resultSetQueue.offer(firstResultSet);
        }
        if (this.resultSetQueue.isEmpty()) {
            return false;
        }
        this.currentResultSet = this.resultSetQueue.peek().getResultSet();
        return true;
    }

    @Override
    public Object[] next() throws SQLException {
        Object[] values = new Object[this.colCount];
        for (int i = 0; i < this.colCount; ++i) {
            values[i] = this.currentResultSet.getObject(i + 1);
        }
        return values;
    }

    @Override
    public Object get(int index) throws SQLException {
        return this.currentResultSet.getObject(index + 1);
    }

    @Override
    public void close() throws SQLException {
        for (ResultSet resultSet : this.resultSets) {
            if (resultSet.isClosed()) continue;
            resultSet.close();
        }
    }
}

