/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.mergeengine.resultset;

import java.sql.SQLException;
import java.util.ArrayList;
import kd.bos.xdb.XDBLogable;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.merge.resultset.MergeSet;
import kd.bos.xdb.mergeengine.ExecutionContext;
import kd.bos.xdb.mergeengine.MergeEngineFactory;
import kd.bos.xdb.util.Pair;

public class UnionExecutionLazyResultSet
implements XDBLogable {
    static final int stableUnionParallelSize = 1;
    private ExecutionContext[] executionContexts;
    private int lastContext = 0;
    private MergeSet[] mergeSets;
    private int i;
    private MergeSet mergeSet;
    private boolean hasNextLoad;
    private volatile boolean firstPrepare = false;

    public UnionExecutionLazyResultSet(ExecutionContext[] executionContextArray) {
        this.executionContexts = executionContextArray;
    }

    public void close() throws SQLException {
        if (this.mergeSet != null) {
            this.mergeSet.close();
            this.mergeSet = null;
            for (int j = this.i; j < this.mergeSets.length; ++j) {
                if (this.mergeSets[j] == null) continue;
                this.mergeSets[j].close();
                this.mergeSets[j] = null;
            }
            this.mergeSets = null;
        }
    }

    public MergeSet getMergeSet() throws SQLException {
        this.init();
        return this.mergeSet;
    }

    public MergeSet[] getMergeSetSet() throws SQLException {
        this.init();
        return this.mergeSets;
    }

    private void init() throws SQLException {
        if (!this.firstPrepare) {
            this.loadMergeSet();
        }
    }

    public boolean next() throws SQLException {
        this.init();
        if (this.mergeSet.next()) {
            return true;
        }
        while (this.nextResultSet()) {
            if (!this.mergeSet.next()) continue;
            return true;
        }
        return false;
    }

    private boolean nextResultSet() throws SQLException {
        if (this.i < this.mergeSets.length) {
            this.mergeSet = this.mergeSets[this.i++];
            return true;
        }
        if (this.hasNextLoad) {
            return this.loadMergeSet();
        }
        return false;
    }

    public boolean loadMergeSet() throws SQLException {
        Pair<Boolean, MergeSet[]> pair = this.doLoadMergeSet();
        this.hasNextLoad = pair.getKey();
        this.mergeSets = pair.getValue();
        if (this.mergeSets != null) {
            this.mergeSet = this.mergeSets[0];
            this.i = 1;
            return true;
        }
        return false;
    }

    private Pair<Boolean, MergeSet[]> doLoadMergeSet() throws SQLException {
        int leftover = this.executionContexts.length - this.lastContext;
        if (leftover > 0) {
            int loadRsCnt = Math.min(leftover, 1);
            ArrayList<MergeSet> rsList = new ArrayList<MergeSet>(loadRsCnt);
            try {
                for (int i = 0; i < loadRsCnt; ++i) {
                    ExecutionContext executionContext = this.executionContexts[this.lastContext++];
                    rsList.add(MergeEngineFactory.get(executionContext.getShardingResult()).doMerge(executionContext));
                }
                if (!this.firstPrepare) {
                    this.firstPrepare = true;
                }
                return new Pair<Boolean, MergeSet[]>(leftover > loadRsCnt, rsList.toArray(new MergeSet[rsList.size()]));
            }
            catch (Exception e) {
                for (MergeSet mergeSet : rsList) {
                    mergeSet.close();
                }
                throw ExceptionUtil.as(SQLException.class, e);
            }
        }
        return new Pair<Boolean, Object>(false, null);
    }
}

