/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.mergeengine.resultset;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.mergeengine.resultset.UnionExecutionLazyIterator;
import kd.bos.xdb.mergeengine.resultset.UnionExecutionLazyResultSet;

public class UnionMemoryQueryDataSet {
    private static final String ALIAS_PREFIX = "lazyload_";
    private UnionExecutionLazyResultSet unionExecutionResultSet;
    private DataSet ds;
    private Row curRow;
    private Map<Integer, String> dataSetColAliasMap = new HashMap<Integer, String>(16);

    public UnionMemoryQueryDataSet(UnionExecutionLazyResultSet unionExecutionResultSet) throws SQLException {
        this.unionExecutionResultSet = unionExecutionResultSet;
    }

    public void build() {
        try {
            String algoKey = this.getClass().toString();
            UnionExecutionLazyIterator iterator = new UnionExecutionLazyIterator(this.unionExecutionResultSet);
            RowMeta rowMeta = this.getRowMeta();
            this.ds = Algo.create((String)algoKey).createDataSet((Iterator)iterator, rowMeta);
        }
        catch (SQLException e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.unionExecutionResultSet.getMergeSet().getMetaData();
    }

    private RowMeta getRowMeta() {
        try {
            ResultSetMetaData meta = this.getMetaData();
            Field[] fields = new Field[meta.getColumnCount()];
            for (int i = 0; i < fields.length; ++i) {
                int sqlType = meta.getColumnType(i + 1);
                String alais = ALIAS_PREFIX + i;
                this.dataSetColAliasMap.put(i + 1, ALIAS_PREFIX + i);
                fields[i] = new Field(alais, DataType.fromSqlType((int)sqlType), true);
            }
            return new RowMeta(fields);
        }
        catch (SQLException e) {
            throw new AlgoException((Throwable)e);
        }
    }

    public boolean next() {
        boolean hasNest = this.ds.hasNext();
        if (hasNest) {
            this.curRow = this.ds.next();
        }
        return hasNest;
    }

    public Row getRow() {
        return this.curRow;
    }

    public void close() {
        if (this.ds != null) {
            this.ds.close();
        }
    }

    public void distinct() {
        this.ds = this.ds.distinct();
    }
}

