/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.mergeengine.union;

import java.sql.SQLException;
import java.util.ArrayList;
import kd.bos.xdb.engine.ShardingResult;
import kd.bos.xdb.merge.resultset.MergeSet;
import kd.bos.xdb.mergeengine.AbstractMergeEngine;
import kd.bos.xdb.mergeengine.ExecutionContext;
import kd.bos.xdb.mergeengine.resultset.AbstractMergeSet;
import kd.bos.xdb.mergeengine.resultset.UnionExecutionLazyResultSet;
import kd.bos.xdb.mergeengine.resultset.UnionMemoryQueryDataSet;
import kd.bos.xdb.mergeengine.union.UnionAllMergeSet;
import kd.bos.xdb.mergeengine.union.UnionMergeSet;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;

public class UnionMergeEngineImpl
extends AbstractMergeEngine {
    @Override
    public MergeSet doMerge(ExecutionContext executionContext) throws SQLException {
        ShardingResult rootShardingResult = executionContext.getShardingResult();
        boolean allUnionAll = rootShardingResult.getUnionRootSelectFeature().isAllUnionAll();
        ArrayList<ExecutionContext> unionConextList = new ArrayList<ExecutionContext>(3);
        for (ShardingResult shardingResult = rootShardingResult; shardingResult != null; shardingResult = shardingResult.getUnionShardingResult()) {
            ShardingResult curShardingResult = shardingResult;
            unionConextList.add(this.copyAndRestShardingResultContext(curShardingResult, executionContext));
        }
        UnionExecutionLazyResultSet unionLazyResultSet = new UnionExecutionLazyResultSet(unionConextList.toArray(new ExecutionContext[unionConextList.size()]));
        AbstractMergeSet mergeSet = allUnionAll ? new UnionAllMergeSet(unionLazyResultSet) : new UnionMergeSet(new UnionMemoryQueryDataSet(unionLazyResultSet));
        MetricsCollector.getCurrent().sqlFeature().setSelectFeature(rootShardingResult.getUnionRootSelectFeature());
        return mergeSet;
    }

    private ExecutionContext copyAndRestShardingResultContext(ShardingResult shardingResult, ExecutionContext rootExecutionContext) throws SQLException {
        return new ExecutionContext(ShardingResult.shardingResult(shardingResult.getSQLInfos(), shardingResult.getStatementInfo(), shardingResult.getSelectFeature()), rootExecutionContext.getOriginalSQL(), rootExecutionContext.isForManager(), rootExecutionContext.getForManagerRoute(), rootExecutionContext.isWrittenInTX(), rootExecutionContext.getQueryTimeoutSeconds());
    }
}

