/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.parameter;

import java.sql.PreparedStatement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.parameter.AbstractParameterFiller;
import kd.bos.xdb.parameter.CommonParameterFiller;
import kd.bos.xdb.parameter.OpenGaussParameterFiller;
import kd.bos.xdb.parameter.batch.AbstractBatchFiller;
import kd.bos.xdb.parameter.batch.CommonBatchFiller;
import kd.bos.xdb.parameter.batch.OpenGaussBatchFiller;

public class ParameterFillerFactory {
    private static final Map<DBType, AbstractParameterFiller> cacheMap = new ConcurrentHashMap<DBType, AbstractParameterFiller>();
    private static final AbstractParameterFiller DEFAULT_PARAMETER_SETTER = new CommonParameterFiller();

    public static AbstractParameterFiller get(DBType dbType) {
        AbstractParameterFiller abstractParameterFiller = cacheMap.get((Object)dbType);
        if (null != abstractParameterFiller) {
            return abstractParameterFiller;
        }
        return DEFAULT_PARAMETER_SETTER;
    }

    public static AbstractBatchFiller getBatchSetter(DBType dbType, boolean expand, PreparedStatement ps) {
        switch (dbType) {
            case gaussdb: {
                return new OpenGaussBatchFiller(expand, ps);
            }
        }
        return new CommonBatchFiller(expand, ps);
    }

    static {
        cacheMap.put(DBType.gaussdb, new OpenGaussParameterFiller());
    }
}

