/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.parameter.batch;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import kd.bos.xdb.parameter.CommonParameterFiller;
import kd.bos.xdb.parameter.ParameterFiller;
import kd.bos.xdb.parameter.batch.AbstractBatchFiller;
import kd.bos.xdb.util.Pair;

public class CommonBatchFiller
extends CommonParameterFiller
implements AbstractBatchFiller {
    private final boolean expand;
    private final PreparedStatement ps;
    private ParameterFiller[] setterCache;
    private int N = -1;
    private int row = 0;

    public CommonBatchFiller(boolean expand, PreparedStatement ps) {
        this.expand = expand;
        this.ps = ps;
    }

    @Override
    public void fill(Object[] params) throws SQLException {
        if (this.expand) {
            this.setExpand(params);
        } else {
            this.set(params);
        }
    }

    @Override
    public void fill(List<Object[]> paramsList) throws SQLException {
        if (this.expand) {
            for (Object[] params : paramsList) {
                this.setExpand(params);
            }
        } else {
            for (Object[] params : paramsList) {
                this.set(params);
            }
        }
    }

    private void set(Object[] params) throws SQLException {
        ++this.row;
        if (this.setterCache == null) {
            this.N = params.length;
            this.setterCache = new ParameterFiller[this.N];
        } else if (this.N != params.length) {
            throw new SQLException("Parameter incorrect @row" + this.row + ", expert length=" + this.N + " actual=" + params.length + ": " + Arrays.deepToString(params));
        }
        for (int i = 0; i < this.N; ++i) {
            Object value = params[i];
            if (value == null) {
                this.ps.setNull(i + 1, 0);
                continue;
            }
            ParameterFiller setter = this.setterCache[i];
            if (setter == null) {
                setter = this.setterCache[i] = this.getFiller(value.getClass());
            }
            setter.doFill(this.ps, value, i + 1, 1111);
        }
        this.ps.addBatch();
    }

    private void setExpand(Object[] params) throws SQLException {
        ++this.row;
        if (this.setterCache == null) {
            HashMap<Integer, ParameterFiller> setterMap = new HashMap<Integer, ParameterFiller>(params.length);
            int i = 1;
            for (Object value : params) {
                if (value == null) {
                    this.ps.setNull(i++, 0);
                    continue;
                }
                Pair<Integer, ParameterFiller> setPair = this.setExpand(this.ps, value, i, null);
                setterMap.put(i - 1, setPair.getValue());
                i = setPair.getKey();
            }
            this.N = i - 1;
            this.setterCache = new ParameterFiller[this.N];
            for (i = 0; i < this.N; ++i) {
                this.setterCache[i] = (ParameterFiller)setterMap.get(i);
            }
        } else {
            int i = 1;
            for (Object value : params) {
                if (value == null) {
                    this.ps.setNull(i++, 0);
                    continue;
                }
                ParameterFiller setter = this.setterCache[i - 1];
                Pair<Integer, ParameterFiller> setPair = this.setExpand(this.ps, value, i, setter);
                if (setter == null) {
                    this.setterCache[i - 1] = setPair.getValue();
                }
                i = setPair.getKey();
            }
            if (this.N != i - 1) {
                throw new SQLException("Parameter incorrect @row" + this.row + ", expert length=" + this.N + " actual=" + (i - 1) + ": " + Arrays.deepToString(params));
            }
        }
        this.ps.addBatch();
    }
}

