/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.parameter.common;

import com.microsoft.sqlserver.jdbc.SQLServerDataTable;
import com.microsoft.sqlserver.jdbc.SQLServerPreparedStatement;
import dm.jdbc.driver.DmdbArray;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbPreparedStatement;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import kd.bos.bundle.BosRes;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.parameter.ParameterFiller;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

public class ArrayFiller
extends ParameterFiller {
    @Override
    public void doFill(PreparedStatement stmt, Object value, int index, int sqlType) throws SQLException {
        int c;
        if (value == null) {
            stmt.setObject(index, null);
            return;
        }
        Class<?> type = null;
        Object[] params = null;
        if (value.getClass().isArray()) {
            type = value.getClass().getComponentType();
            if (type == Object.class) {
                params = (Object[])value;
            } else {
                c = Array.getLength(value);
                params = new Object[c];
                for (int i = 0; i < c; ++i) {
                    params[i] = Array.get(value, i);
                }
            }
        } else if (value instanceof Iterable) {
            if (value instanceof Collection) {
                params = ((Collection)value).toArray();
            } else {
                c = 0;
                LinkedList list = new LinkedList();
                Iterator iter = ((Iterable)value).iterator();
                while (iter.hasNext()) {
                    list.add(iter.next());
                    ++c;
                }
                params = new Object[c];
                list.toArray(params);
            }
        } else {
            params = new Object[]{value};
        }
        Connection con = stmt.getConnection();
        DBType dbType = this.getDBType(con);
        if (dbType == DBType.mysql) {
            StringBuilder sb = new StringBuilder(params.length * 19);
            for (Object p : params) {
                sb.append(p);
                sb.append(',');
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            stmt.setObject(index, sb.toString());
        } else {
            OracleConnection ocon;
            String typeName = null;
            if (sqlType != 1111) {
                if (sqlType == -5 || sqlType == 4 || sqlType == 5 || sqlType == -6) {
                    typeName = "UDT_INTTABLE";
                } else if (sqlType == 12) {
                    typeName = "UDT_VARCHARTABLE";
                } else if (sqlType == -9) {
                    typeName = "UDT_NVARCHARTABLE";
                }
            }
            if (typeName == null) {
                if (type == null || type == Object.class) {
                    for (Object v : params) {
                        if (v == null) continue;
                        type = v.getClass();
                        break;
                    }
                }
                typeName = "UDT_NVARCHARTABLE";
                if (type != null && (Number.class.isAssignableFrom(type) || type == Integer.TYPE || type == Long.TYPE)) {
                    typeName = "UDT_INTTABLE";
                }
            }
            if (dbType == DBType.oracle) {
                ocon = con.unwrap(OracleConnection.class);
                ArrayDescriptor des = ArrayDescriptor.createDescriptor((String)typeName, (Connection)ocon);
                stmt.unwrap(OraclePreparedStatement.class).setARRAY(index, new ARRAY(des, (Connection)ocon, (Object)params));
            } else if (dbType == DBType.dm) {
                ocon = con.unwrap(DmdbConnection.class);
                dm.jdbc.desc.ArrayDescriptor des = new dm.jdbc.desc.ArrayDescriptor(typeName, (DmdbConnection)ocon);
                stmt.unwrap(DmdbPreparedStatement.class).setArray(index, (java.sql.Array)new DmdbArray(des, (DmdbConnection)ocon, params));
            } else if (dbType == DBType.postgresql) {
                stmt.setObject(index, value, 2003);
            } else if (dbType == DBType.sqlserver) {
                SQLServerDataTable dataTable = new SQLServerDataTable();
                dataTable.setTvpName(typeName);
                dataTable.addColumnMetadata("fid", sqlType);
                for (Object val : params) {
                    dataTable.addRow(new Object[]{val});
                }
                stmt.unwrap(SQLServerPreparedStatement.class).setObject(index, (Object)dataTable);
            } else {
                java.sql.Array array = stmt.getConnection().createArrayOf(typeName, params);
                stmt.setArray(index, array);
            }
        }
    }

    private DBType getDBType(Connection con) throws SQLException {
        String dbType = con.getMetaData().getDatabaseProductName().toLowerCase();
        if (dbType.indexOf("postgresql") != -1) {
            return DBType.postgresql;
        }
        if (dbType.indexOf("mysql") != -1 || dbType.indexOf("mariadb") != -1) {
            return DBType.mysql;
        }
        if (dbType.indexOf("oracle") != -1) {
            return DBType.oracle;
        }
        if (dbType.indexOf("sqlserver") != -1 || dbType.indexOf("microsoft") != -1) {
            return DBType.sqlserver;
        }
        if (dbType.indexOf("dm") != -1) {
            return DBType.dm;
        }
        if (dbType.indexOf("gs") != -1) {
            return DBType.gs;
        }
        if (dbType.indexOf("gs100") != -1 || dbType.indexOf("zenith") != -1) {
            return DBType.gs100;
        }
        if (dbType.indexOf("kingbase") != -1 || dbType.indexOf("kingbasees") != -1) {
            return DBType.kingbase;
        }
        throw ExceptionUtil.wrap(BosRes.get((String)"bos-xdb", (String)"ParameterSetter_0", (String)"\u4e0d\u652f\u6301\u6570\u636e\u5e93\u7c7b\u578b:{0}\u3002", (Object[])new Object[]{dbType}));
    }
}

