/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding;

import java.util.ArrayList;
import java.util.List;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.ShardingFieldValue;

public final class ShardingGroupTable {
    private String shardingTable;
    private List<ShardingFieldValue> fieldValues = new ArrayList<ShardingFieldValue>();
    private ShardingHintContext shardingHintContext;

    public ShardingGroupTable(String shardingTable) {
        this.shardingTable = shardingTable;
    }

    public void setShardingTableAsPrototypeTable(String prototypeTable) {
        this.shardingTable = prototypeTable;
    }

    public void addShardingFieldValue(ShardingFieldValue fieldValue) {
        this.fieldValues.add(fieldValue);
    }

    public void addShardingFieldValues(List<ShardingFieldValue> fieldValues) {
        this.fieldValues.addAll(fieldValues);
    }

    public void clearFieldValues() {
        this.fieldValues.clear();
    }

    public String getShardingTable() {
        return this.shardingTable;
    }

    public List<ShardingFieldValue> getFieldValues() {
        return this.fieldValues;
    }

    public ShardingHintContext getShardingHintContext() {
        return this.shardingHintContext;
    }

    public void setShardingHintContext(ShardingHintContext shardingHintContext) {
        this.shardingHintContext = shardingHintContext;
    }

    public ShardingHintContext setIfExistsShardingHintContext(String table) {
        ShardingHintContext ctx = ShardingHintContext.get();
        if (ctx != null && ctx.isHintForTable(table)) {
            this.setShardingHintContext(ctx);
            return ctx;
        }
        return null;
    }

    public String toString() {
        ArrayList<ShardingFieldValue> list = new ArrayList<ShardingFieldValue>(this.fieldValues);
        list.sort((f1, f2) -> f1.getPosIndex() - f2.getPosIndex());
        return this.shardingTable + list;
    }
}

