/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.bundle.BosRes;
import kd.bos.xdb.sharding.config.ChildrenTableConfig;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.config.ShardingConfigListener;
import kd.bos.xdb.sharding.config.ShardingConfigProvider;
import kd.bos.xdb.tablemanager.TableName;

public class DefaultShardingConfigProvider
implements ShardingConfigProvider {
    private Map<String, ShardingConfig> map = new ConcurrentHashMap<String, ShardingConfig>();
    private Map<String, MainTableConfig> entitynumberMap = new ConcurrentHashMap<String, MainTableConfig>();
    private List<ShardingConfigListener> scls = new ArrayList<ShardingConfigListener>();
    private String contextKey;
    private volatile boolean hasEnabledShardingConfig;
    private Set<ShardingConfig> configCache = Collections.emptySet();

    @Override
    public Set<ShardingConfig> getConfigs() {
        return this.configCache;
    }

    @Override
    public ShardingConfig getConfig(String tableName) {
        return this.map.get(tableName.toLowerCase());
    }

    @Override
    public MainTableConfig getMainConfig(String tableName) {
        ShardingConfig sc = this.map.get(TableName.of(tableName).getOriginalName().toLowerCase());
        if (sc != null) {
            while (sc instanceof ChildrenTableConfig) {
                sc = ((ChildrenTableConfig)sc).getParent();
            }
            if (sc == null) {
                throw new IllegalArgumentException(BosRes.get((String)"bos-xdb", (String)"DefaultShardingConfigProvider_0", (String)"{0}\u672a\u627e\u5230\u4e3b\u8868\u914d\u7f6e\u3002", (Object[])new Object[]{tableName}));
            }
        }
        return (MainTableConfig)sc;
    }

    @Override
    public List<ShardingConfig> getConfigs(String tableName) {
        HashSet<ShardingConfig> configSet = new HashSet<ShardingConfig>(this.map.values());
        ShardingConfig sc = null;
        tableName = tableName.toLowerCase();
        for (ShardingConfig config : configSet) {
            if (!config.getTable().equals(tableName)) continue;
            sc = config;
            break;
        }
        ArrayList<ShardingConfig> ret = new ArrayList<ShardingConfig>(1);
        if (sc != null) {
            while (sc instanceof ChildrenTableConfig) {
                sc = ((ChildrenTableConfig)sc).getParent();
            }
            if (sc == null) {
                throw new IllegalArgumentException(BosRes.get((String)"bos-xdb", (String)"DefaultShardingConfigProvider_0", (String)"{0}\u672a\u627e\u5230\u4e3b\u8868\u914d\u7f6e\u3002", (Object[])new Object[]{tableName}));
            }
            ret.add(sc);
            for (String table : ((MainTableConfig)sc).getGroupTables()) {
                ShardingConfig groupSC = this.map.get(table);
                if (sc == groupSC) continue;
                ret.add(groupSC);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConfig(ShardingConfig sc) {
        Map<String, ShardingConfig> map = this.map;
        synchronized (map) {
            this.map.put(sc.getTable(), sc);
            if (sc instanceof MainTableConfig) {
                this.entitynumberMap.put(sc.getEntitynumber(), (MainTableConfig)sc);
            }
            this.onShardingConfigChanged();
            this.fireOnAdded(sc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConfigs(ShardingConfig ... scs) {
        Map<String, ShardingConfig> map = this.map;
        synchronized (map) {
            for (ShardingConfig sc : scs) {
                this.map.put(sc.getTable(), sc);
                if (!(sc instanceof MainTableConfig)) continue;
                this.entitynumberMap.put(sc.getEntitynumber(), (MainTableConfig)sc);
            }
            this.onShardingConfigChanged();
            this.fireOnAdded(scs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ShardingConfig removeConfig(String tableName) {
        Map<String, ShardingConfig> map = this.map;
        synchronized (map) {
            ShardingConfig config = this.map.remove(tableName.toLowerCase());
            if (config != null) {
                config.getShardingStrategy().clearCache();
                this.onShardingConfigChanged();
                this.fireOnRemoved(config);
            }
            return config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ShardingConfig> removeConfigs(String tableName) {
        Map<String, ShardingConfig> map = this.map;
        synchronized (map) {
            List<ShardingConfig> removed = this.getConfigs(tableName);
            if (!removed.isEmpty()) {
                for (ShardingConfig sc : removed) {
                    this.map.remove(sc.getTable());
                    sc.getShardingStrategy().clearCache();
                    if (!(sc instanceof MainTableConfig)) continue;
                    this.entitynumberMap.remove(sc.getEntitynumber());
                }
                this.onShardingConfigChanged();
                this.fireOnRemoved(removed.toArray(new ShardingConfig[removed.size()]));
            }
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearConfig() {
        Map<String, ShardingConfig> map = this.map;
        synchronized (map) {
            if (!this.map.isEmpty()) {
                ShardingConfig[] scs;
                for (ShardingConfig sc : scs = this.map.values().toArray(new ShardingConfig[this.map.size()])) {
                    sc.getShardingStrategy().clearCache();
                }
                this.map.clear();
                this.entitynumberMap.clear();
                this.onShardingConfigChanged();
                this.fireOnRemoved(scs);
            }
        }
    }

    @Override
    public void addShardingConfigListener(ShardingConfigListener scl) {
        this.scls.add(scl);
    }

    @Override
    public void removeShardingConfigListener(ShardingConfigListener scl) {
        this.scls.remove(scl);
    }

    @Override
    public void setContextKey(String contextKey) {
        this.contextKey = contextKey;
    }

    @Override
    public String getContextKey() {
        return this.contextKey;
    }

    @Override
    public boolean hasEnabledShardingConfig() {
        return this.hasEnabledShardingConfig;
    }

    private void fireOnAdded(ShardingConfig ... scs) {
        if (!this.scls.isEmpty()) {
            for (ShardingConfigListener scl : this.scls) {
                scl.onAdded(scs);
            }
        }
    }

    private void fireOnRemoved(ShardingConfig ... scs) {
        if (!this.scls.isEmpty()) {
            for (ShardingConfigListener scl : this.scls) {
                scl.onRemoved(scs);
            }
        }
    }

    private void onShardingConfigChanged() {
        HashSet<ShardingConfig> set = new HashSet<ShardingConfig>(this.map.values());
        boolean b = false;
        for (ShardingConfig sc : set) {
            if (!sc.isEnabled()) continue;
            b = true;
            break;
        }
        this.configCache = Collections.unmodifiableSet(set);
        this.hasEnabledShardingConfig = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceConfigs(String tableName, ShardingConfig ... scs) {
        tableName = tableName.toLowerCase();
        Map<String, ShardingConfig> map = this.map;
        synchronized (map) {
            ShardingConfig config = this.map.remove(tableName);
            if (config != null) {
                config.getShardingStrategy().clearCache();
                this.fireOnRemoved(config);
            }
            for (ShardingConfig sc : scs) {
                this.map.put(sc.getTable(), sc);
                if (!(sc instanceof MainTableConfig)) continue;
                this.entitynumberMap.put(sc.getEntitynumber(), (MainTableConfig)sc);
            }
            this.fireOnAdded(scs);
            this.onShardingConfigChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MainTableConfig getConfigByEntity(String entitynumber) {
        Map<String, MainTableConfig> map = this.entitynumberMap;
        synchronized (map) {
            return this.entitynumberMap.get(entitynumber);
        }
    }
}

