/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kd.bos.xdb.sharding.config.BaseShardingConfig;
import kd.bos.xdb.sharding.config.DataRowsRange;
import kd.bos.xdb.sharding.config.FieldDefine;
import kd.bos.xdb.sharding.config.IndexDefine;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.strategy.ShardingStrategy;

public class MainTableConfig
extends BaseShardingConfig
implements ShardingConfig {
    private String name;
    private boolean enabled = true;
    private boolean indexPK = false;
    private String[] shardingFields;
    private String table;
    private ShardingStrategy shardingStragy;
    private Set<String> groupTables = new HashSet<String>();

    MainTableConfig(String entityNumber, String name, String table, FieldDefine[] shardingFieldDefines, ShardingStrategy shardingStragy, DataRowsRange dataRowsRange, IndexDefine[] indexDefines, boolean isMock) {
        this.entityNumber = entityNumber;
        this.name = name;
        this.level = 1;
        this.shardingStragy = shardingStragy;
        this.table = table.toLowerCase();
        this.shardingFields = new String[shardingFieldDefines.length];
        for (int i = 0; i < shardingFieldDefines.length; ++i) {
            this.shardingFields[i] = shardingFieldDefines[i].getField();
        }
        this.groupTables.add(this.table);
        this.getOptions().setDataRowsRange(dataRowsRange);
        this.getOptions().setIndexDefines(indexDefines);
        this.getOptions().setShardingFieldDefines(shardingFieldDefines);
        if (!isMock) {
            shardingStragy.initConfig(this);
        }
    }

    @Override
    public String[] getShardingFields() {
        return this.shardingFields;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    public Set<String> getGroupTables() {
        return Collections.unmodifiableSet(this.groupTables);
    }

    void addGroupTable(String table) {
        this.groupTables.add(table);
    }

    @Override
    public ShardingStrategy getShardingStrategy() {
        return this.shardingStragy;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isIndexPK() {
        return this.indexPK;
    }

    @Override
    public void setIndexPK(boolean indexPK) {
        this.indexPK = indexPK;
    }

    @Override
    public void mockSet(String name, String table) {
        this.name = name;
        this.table = table;
    }

    public void mockSetGroupTables(Set<String> groupTables) {
        this.groupTables = groupTables;
    }

    public String toString() {
        return this.table + ':' + Arrays.asList(this.shardingFields) + ',' + this.shardingStragy;
    }
}

