/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.xdb.sharding.config.DataRowsRange;
import kd.bos.xdb.sharding.config.FieldDefine;
import kd.bos.xdb.sharding.config.IndexDefine;
import kd.bos.xdb.sharding.config.ShardingIndexRoute;

public final class ShardingConfigOptions {
    private DataRowsRange dataRowsRange = DataRowsRange.less10;
    private FieldDefine[] shardDefines;
    private IndexDefine[] indexDefines;
    private final Set<String> indexDefineCache = new HashSet<String>();
    private Map<String, FieldDefine> shardingFieldNameMap = Collections.emptyMap();
    private Set<String> indexNameSet = Collections.emptySet();
    private String dbRouteKey;
    private ShardingIndexRoute indexRoute;

    public DataRowsRange getDataRowsRange() {
        return this.dataRowsRange;
    }

    public void setDataRowsRange(DataRowsRange dataRowsRange) {
        this.dataRowsRange = dataRowsRange;
    }

    public FieldDefine getShardingFieldDefines(String field) {
        return this.shardingFieldNameMap.get(field.toLowerCase());
    }

    public FieldDefine[] getShardDefines() {
        return this.shardDefines;
    }

    public void setShardingFieldDefines(FieldDefine[] shardingFieldDefines) {
        this.shardDefines = shardingFieldDefines;
        HashMap<String, FieldDefine> map = new HashMap<String, FieldDefine>(shardingFieldDefines.length);
        for (FieldDefine def : shardingFieldDefines) {
            this.indexDefineCache.add(def.getTable() + ':' + def.getField());
            map.put(def.getField(), def);
        }
        this.shardingFieldNameMap = Collections.unmodifiableMap(map);
    }

    public IndexDefine[] getIndexDefines() {
        return this.indexDefines;
    }

    public void setIndexDefines(IndexDefine[] indexDefines) {
        this.indexDefines = indexDefines;
        this.indexDefineCache.clear();
        if (indexDefines != null) {
            HashSet<String> set = new HashSet<String>(3);
            for (IndexDefine def : indexDefines) {
                this.indexDefineCache.add(def.getTable() + ':' + def.getField());
                set.add(def.getField());
            }
            this.indexNameSet = Collections.unmodifiableSet(set);
        } else {
            this.indexNameSet = Collections.emptySet();
        }
    }

    public boolean hasIndexDefine(String table, String field) {
        return this.indexDefineCache.contains(table.toLowerCase() + ':' + field.toLowerCase());
    }

    public Set<String> getIndexNameSet() {
        return this.indexNameSet;
    }

    public String getDbRouteKey() {
        return this.dbRouteKey;
    }

    public void setDbRouteKey(String dbRouteKey) {
        this.dbRouteKey = dbRouteKey;
    }

    public ShardingIndexRoute getIndexRoute() {
        return this.indexRoute;
    }

    public void setIndexRoute(ShardingIndexRoute indexRoute) {
        this.indexRoute = indexRoute;
    }
}

