/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.config;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.xdb.XDBLogable;
import kd.bos.xdb.tablemanager.TableName;

public final class ShardingIndexRoute
implements XDBLogable {
    private String mainRouteKey;
    private Map<Long, String> indexRouteMap;

    public ShardingIndexRoute(Map<Long, String> shardingIndexRouteMap) {
        this.indexRouteMap = shardingIndexRouteMap;
    }

    public void clear() {
        this.indexRouteMap.clear();
    }

    public Set<String> getAllArchiveRoutes() {
        return new HashSet<String>(this.indexRouteMap.values());
    }

    public String getRoute(String tableName) {
        if (TableName.of(tableName).isDataTable()) {
            return this.getRoute(TableName.of(tableName).getShardingIndex());
        }
        return this.mainRouteKey;
    }

    public String getRoute(long shardingIndex) {
        String curRoute = this.indexRouteMap.get(shardingIndex);
        return curRoute == null ? this.mainRouteKey : curRoute;
    }

    public String getMainRouteKey() {
        return this.mainRouteKey;
    }

    public void setMainRouteKey(String mainRouteKey) {
        this.mainRouteKey = mainRouteKey;
    }

    public Set<String> getDbRoutes() {
        LinkedHashSet<String> dbRoutes = new LinkedHashSet<String>(1);
        dbRoutes.add(this.mainRouteKey);
        for (String route : this.indexRouteMap.values()) {
            dbRoutes.add(route);
        }
        return dbRoutes;
    }
}

