/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.indexpk;

import java.util.HashMap;
import java.util.Map;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.cache.Cache;
import kd.bos.xdb.cache.CacheContext;
import kd.bos.xdb.cache.global.GlobalCache;
import kd.bos.xdb.sharding.indexpk.IndexPKCache;
import kd.bos.xdb.xpm.metrics.action.ActionMetric;
import kd.bos.xdb.xpm.metrics.action.sharding.pk.ClearPKCacheSpan;
import kd.bos.xdb.xpm.metrics.action.sharding.pk.HitPKCacheSpan;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;

public final class IndexPKLocalCache
implements IndexPKCache {
    private static final String cache_key_suffix = "#PK";
    private final String name;

    public IndexPKLocalCache(String name) {
        this.name = name;
    }

    @Override
    public void initCache(String tableName) {
        CacheContext.get().getCurrentCache().initCacheSize(tableName + cache_key_suffix, XDBConfig.get().getCachePKSize());
    }

    @Override
    public void set(String tableName, long index, Object ... pks) {
        Cache cc = CacheContext.get().getCurrentCache();
        for (Object pk : pks) {
            cc.set(tableName + cache_key_suffix, String.valueOf(this.unwrapPK(pk)), index);
        }
    }

    @Override
    public Long get(ActionMetric am, String tableName, Object pk) {
        if (am == null) {
            return (Long)CacheContext.get().getCurrentCache().get(tableName + cache_key_suffix, String.valueOf(this.unwrapPK(pk)));
        }
        Long ret = (Long)CacheContext.get().getCurrentCache().get(tableName + cache_key_suffix, String.valueOf(this.unwrapPK(pk)));
        if (ret != null) {
            am.stat(new HitPKCacheSpan(tableName, pk, ret));
        }
        return ret;
    }

    @Override
    public Map<Object, Long> get(ActionMetric am, String tableName, Object ... pks) {
        Cache cc = CacheContext.get().getCurrentCache();
        HashMap<Object, Long> ret = new HashMap<Object, Long>(pks.length);
        for (Object pk : pks) {
            ret.put(pk, (Long)cc.get(tableName + cache_key_suffix, String.valueOf(this.unwrapPK(pk))));
        }
        if (am != null) {
            am.stat(new HitPKCacheSpan(tableName, ret));
        }
        return ret;
    }

    @Override
    public void clear(String ... tableNames) {
        Cache cc = CacheContext.get().getCurrentCache();
        for (String tableName : tableNames) {
            cc.clear(tableName + cache_key_suffix);
        }
        MetricsCollector mc = MetricsCollector.getCurrent();
        if (mc.isActionMetricEnabled()) {
            mc.actionMetric().stat(new ClearPKCacheSpan(tableNames));
        }
    }

    @Override
    public void clearParentPk(String tableName, Object pk) {
        Cache parent = CacheContext.get().getCurrentCache().getParent();
        while (!parent.getClass().isAssignableFrom(GlobalCache.class)) {
            parent.remove(tableName + cache_key_suffix, String.valueOf(this.unwrapPK(pk)));
            parent = parent.getParent();
        }
    }

    public String toString() {
        return this.name;
    }
}

