/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.indexpk;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.xdb.XDB;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBManageContext;
import kd.bos.xdb.datasource.ConnectionProvider;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.ext.KSQL;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.util.ArrayUtil;
import kd.bos.xdb.xpm.metrics.action.sharding.index.QueryByIndexSpan;
import kd.bos.xdb.xpm.metrics.action.sharding.pk.QueryByPKBlockSpan;
import kd.bos.xdb.xpm.metrics.action.sharding.pk.QueryByPKSpan;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;

public class QueryIndexPKAction {
    private static final int batchSize = XDBConfig.get().getQueryIndexBatchSize();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object _queryPk(String tableName, long index) {
        StringBuilder sb = new StringBuilder(NoShardingHint.genNoShardingSQL("select top 1 fpk from " + TableName.of(tableName).getPKTable() + " where findex = ? "));
        MainTableConfig mainTableConfig = XDBConfig.getShardingConfigProvider().getMainConfig(tableName);
        Set<String> dbRoutes = mainTableConfig.getOptions().getIndexRoute().getDbRoutes();
        Iterator<String> iterator = dbRoutes.iterator();
        while (iterator.hasNext()) {
            String dbRoute = iterator.next();
            try {
                XDBManageContext xm = XDB.get().withManageContext();
                Throwable throwable = null;
                try {
                    xm.setRoute(dbRoute);
                    ResultSet rs = XDB.get().query(sb.toString(), index);
                    Throwable throwable2 = null;
                    try {
                        if (!rs.next()) continue;
                        Object object = rs.getObject(1);
                        return object;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable2 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (xm == null) continue;
                    if (throwable != null) {
                        try {
                            xm.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    xm.close();
                }
            }
            catch (SQLException e) {
                throw ExceptionUtil.wrap(e);
            }
        }
        return null;
    }

    public static long[] _queryShardingIndexWithCompare(String tableName, String cp, Object pk) {
        ArrayList<Long> ret = new ArrayList<Long>();
        StringBuilder sb = new StringBuilder(NoShardingHint.genNoShardingSQL("select distinct findex from " + TableName.of(tableName).getPKTable() + " where fpk " + cp + "?"));
        MainTableConfig mainTableConfig = XDBConfig.getShardingConfigProvider().getMainConfig(tableName);
        Set<String> dbRoutes = mainTableConfig.getOptions().getIndexRoute().getDbRoutes();
        for (String dbRoute : dbRoutes) {
            try {
                XDBManageContext xm = XDB.get().withManageContext();
                Throwable throwable = null;
                try {
                    xm.setRoute(dbRoute);
                    ResultSet rs = XDB.get().query(sb.toString(), pk);
                    Throwable throwable2 = null;
                    try {
                        while (rs.next()) {
                            ret.add(rs.getLong(1));
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable2 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (xm == null) continue;
                    if (throwable != null) {
                        try {
                            xm.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    xm.close();
                }
            }
            catch (SQLException e) {
                throw ExceptionUtil.wrap(e);
            }
        }
        return ArrayUtil.toArray(ret);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Long _getShardingIndexWithoutCache(String tableName, Object pk) {
        String sql = NoShardingHint.genNoShardingSQL("select findex from " + TableName.of(tableName).getPKTable() + " where fpk=?");
        sql = KSQL.dialect(sql);
        MetricsCollector mc = MetricsCollector.getCurrent();
        MainTableConfig mainTableConfig = XDBConfig.getShardingConfigProvider().getMainConfig(tableName);
        Set<String> dbRoutes = mainTableConfig.getOptions().getIndexRoute().getDbRoutes();
        Iterator<String> iterator = dbRoutes.iterator();
        while (iterator.hasNext()) {
            String dbRoute = iterator.next();
            try {
                XDBManageContext xm = XDB.get().withManageContext();
                Throwable throwable = null;
                try {
                    xm.setRoute(dbRoute);
                    ResultSet rs = XDB.get().query(sql, pk);
                    Throwable throwable2 = null;
                    try {
                        if (!rs.next()) continue;
                        if (mc.isActionMetricEnabled()) {
                            long ret = rs.getLong(1);
                            mc.actionMetric().stat(new QueryByPKSpan(tableName, pk, ret));
                        }
                        Long l = rs.getLong(1);
                        return l;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable2 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (xm == null) continue;
                    if (throwable != null) {
                        try {
                            xm.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    xm.close();
                }
            }
            catch (SQLException e) {
                throw ExceptionUtil.wrap(e);
            }
        }
        return null;
    }

    public static Map<Object, Long> _queryShardingIndexWithoutCache(String tableName, List<Object> noCachePKs) {
        HashMap<Object, Long> ret = new HashMap<Object, Long>();
        DBType dbType = ConnectionProvider.get().getConnectionHolder().getDBType();
        for (Object[] segpks : ArrayUtil.split(noCachePKs.toArray(), batchSize)) {
            StringBuilder sb = new StringBuilder();
            sb.append(NoShardingHint.genNoShardingSQL("select fpk,findex from " + TableName.of(tableName).getPKTable() + " where fpk "));
            String sql = QueryIndexPKAction.getParamInSQLByDBType(sb, "fpk", segpks.length, dbType);
            MainTableConfig mainTableConfig = XDBConfig.getShardingConfigProvider().getMainConfig(tableName);
            Set<String> dbRoutes = mainTableConfig.getOptions().getIndexRoute().getDbRoutes();
            for (String dbRoute : dbRoutes) {
                try {
                    XDBManageContext xm = XDB.get().withManageContext();
                    Throwable throwable = null;
                    try {
                        xm.setRoute(dbRoute);
                        ResultSet rs = XDB.get().query(sql, segpks);
                        Throwable throwable2 = null;
                        try {
                            boolean longType = false;
                            if (rs.next()) {
                                Object key = rs.getObject(1);
                                if (key instanceof Number) {
                                    ret.put(rs.getLong(1), rs.getLong(2));
                                    longType = true;
                                } else {
                                    ret.put(rs.getObject(1), rs.getLong(2));
                                }
                            }
                            if (longType) {
                                while (rs.next()) {
                                    ret.put(rs.getLong(1), rs.getLong(2));
                                }
                                continue;
                            }
                            while (rs.next()) {
                                ret.put(rs.getObject(1), rs.getLong(2));
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (rs == null) continue;
                            if (throwable2 != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            rs.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (xm == null) continue;
                        if (throwable != null) {
                            try {
                                xm.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        xm.close();
                    }
                }
                catch (SQLException e) {
                    throw ExceptionUtil.wrap(e);
                }
            }
        }
        MetricsCollector mc = MetricsCollector.getCurrent();
        if (mc.isActionMetricEnabled()) {
            mc.actionMetric().stat(new QueryByPKSpan(tableName, ret));
        }
        return ret;
    }

    public static Map<Object, Set<Long>> _queryShardingIndexWithoutCache(String tableName, String field, List<Object> noCachePKs) {
        HashMap<Object, Set<Long>> ret = new HashMap<Object, Set<Long>>();
        HashSet<Long> indexies = new HashSet<Long>(8);
        DBType dbType = ConnectionProvider.get().getConnectionHolder().getDBType();
        for (Object[] segpks : ArrayUtil.split(noCachePKs.toArray(), batchSize)) {
            StringBuilder sb = new StringBuilder();
            sb.append(NoShardingHint.genNoShardingSQL("select " + field + ",findex from " + TableName.of(tableName).getPKTable() + " where " + field + " "));
            String sql = QueryIndexPKAction.getParamInSQLByDBType(sb, field, segpks.length, dbType);
            MainTableConfig mainTableConfig = XDBConfig.getShardingConfigProvider().getMainConfig(tableName);
            Set<String> dbRoutes = mainTableConfig.getOptions().getIndexRoute().getDbRoutes();
            for (String dbRoute : dbRoutes) {
                try {
                    XDBManageContext xm = XDB.get().withManageContext();
                    Throwable throwable = null;
                    try {
                        xm.setRoute(dbRoute);
                        ResultSet rs = XDB.get().query(sql, segpks);
                        Throwable throwable2 = null;
                        try {
                            while (rs.next()) {
                                Set longs = ret.computeIfAbsent(rs.getObject(1), key -> new HashSet());
                                long index = rs.getLong(2);
                                longs.add(index);
                                indexies.add(index);
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (rs == null) continue;
                            if (throwable2 != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            rs.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (xm == null) continue;
                        if (throwable != null) {
                            try {
                                xm.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        xm.close();
                    }
                }
                catch (SQLException e) {
                    throw ExceptionUtil.wrap(e);
                }
            }
        }
        MetricsCollector mc = MetricsCollector.getCurrent();
        if (mc.isActionMetricEnabled()) {
            mc.actionMetric().stat(new QueryByIndexSpan(TableName.of(tableName).getPKTable(), field, noCachePKs.toArray(), ArrayUtil.toArray(indexies)));
        }
        return ret;
    }

    public static long[] _queryShardingIndexWithoutCache(String tableName, String indexField, Object ... pks) {
        if (pks.length == 1 && pks[0] != null && pks[0].getClass().isArray()) {
            pks = (Object[])pks[0];
        }
        if (pks.length == 1 && indexField.equalsIgnoreCase("fpk")) {
            long[] lArray;
            Long v = QueryIndexPKAction._getShardingIndexWithoutCache(tableName, pks[0]);
            if (v == null) {
                lArray = ArrayUtil.EMPTY_INDEXIES;
            } else {
                long[] lArray2 = new long[1];
                lArray = lArray2;
                lArray2[0] = v;
            }
            return lArray;
        }
        HashSet<Long> ret = new HashSet<Long>(Math.min(1000, pks.length));
        DBType dbType = ConnectionProvider.get().getConnectionHolder().getDBType();
        for (Object[] segpks : ArrayUtil.split(pks, batchSize)) {
            StringBuilder sb = new StringBuilder(NoShardingHint.genNoShardingSQL("select distinct findex from " + TableName.of(tableName).getPKTable() + " where " + indexField + " "));
            String sql = QueryIndexPKAction.getParamInSQLByDBType(sb, indexField, segpks.length, dbType);
            MainTableConfig mainTableConfig = XDBConfig.getShardingConfigProvider().getMainConfig(tableName);
            Set<String> dbRoutes = mainTableConfig.getOptions().getIndexRoute().getDbRoutes();
            for (String dbRoute : dbRoutes) {
                try {
                    XDBManageContext xm = XDB.get().withManageContext();
                    Throwable throwable = null;
                    try {
                        xm.setRoute(dbRoute);
                        ResultSet rs = XDB.get().query(sql, segpks);
                        Throwable throwable2 = null;
                        try {
                            while (rs.next()) {
                                ret.add(rs.getLong(1));
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (rs == null) continue;
                            if (throwable2 != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            rs.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (xm == null) continue;
                        if (throwable != null) {
                            try {
                                xm.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        xm.close();
                    }
                }
                catch (SQLException e) {
                    throw ExceptionUtil.wrap(e);
                }
            }
        }
        long[] indexies = ArrayUtil.toArray(ret);
        MetricsCollector mc = MetricsCollector.getCurrent();
        if (mc.isActionMetricEnabled()) {
            mc.actionMetric().stat(indexField.equalsIgnoreCase("fpk") ? new QueryByPKBlockSpan(tableName, pks, indexies) : new QueryByIndexSpan(tableName, indexField, pks, indexies));
            return indexies;
        }
        return indexies;
    }

    private static String getParamInSQLByDBType(StringBuilder sb, String indexField, int pksLen, DBType dbType) {
        block0 : switch (dbType) {
            case dm: 
            case oracle: 
            case oceanbase_oracle: 
            case hana: 
            case yasdb: {
                int paramLen;
                int record;
                int n = record = paramLen % 1000 == 0 ? paramLen / 1000 : paramLen / 1000 + 1;
                for (paramLen = pksLen; paramLen > 0; paramLen -= 1000) {
                    StringBuilder inParam = new StringBuilder(paramLen * 2);
                    if (record == 1) {
                        QueryIndexPKAction.toParamArray(inParam, paramLen);
                        sb.append(" in(");
                        sb.append((CharSequence)inParam);
                        sb.append(')');
                        break block0;
                    }
                    QueryIndexPKAction.toParamArray(inParam, 1000);
                    sb.append("in(");
                    sb.append((CharSequence)inParam);
                    sb.append(") or ").append(indexField).append(" ");
                    inParam.delete(0, inParam.length());
                    --record;
                }
                break;
            }
            case postgresql: 
            case gs: 
            case gs100: 
            case gaussdb: 
            case gauss200: 
            case gbase: 
            case kingbase: 
            case vastbase: 
            case derby: 
            case mysql: 
            case tdsql: 
            case tidb: 
            case sqlserver: {
                StringBuilder inParam = new StringBuilder(pksLen * 2);
                QueryIndexPKAction.toParamArray(inParam, pksLen);
                sb.append(" in(");
                sb.append((CharSequence)inParam);
                sb.append(')');
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupport dbType: " + (Object)((Object)dbType));
            }
        }
        return KSQL.dialect(sb.toString());
    }

    private static void toParamArray(StringBuilder inParam, int paramLen) {
        for (int i = 0; i < paramLen; ++i) {
            if (i > 0) {
                inParam.append(',');
            }
            inParam.append('?');
        }
    }
}

