/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.sql;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.bos.xdb.sharding.sql.SQLInfo;
import kd.bos.xdb.sharding.sql.StatementType;
import kd.bos.xdb.sharding.sql.condition.AlwaysValue;
import kd.bos.xdb.sharding.sql.condition.EffectiveParametersTester;

public class ParamsGroup {
    private final StatementType statementType;
    private final SQLInfo sqlInfo;
    private Map<ParameterKey, List<Object>> paramMap;
    private EffectiveParametersTester tester;
    private AlwaysValue alwaysValue;

    public ParamsGroup(StatementType statementType, SQLInfo sqlInfo) {
        this(2, statementType, sqlInfo);
    }

    public ParamsGroup(int initSize, StatementType statementType, SQLInfo sqlInfo) {
        this.paramMap = new HashMap<ParameterKey, List<Object>>(initSize);
        this.statementType = statementType;
        this.sqlInfo = sqlInfo;
    }

    public StatementType getStatementType() {
        return this.statementType;
    }

    public SQLInfo getSqlInfo() {
        return this.sqlInfo;
    }

    public ParameterKey add(String field, int paramsFromPos, Object value, int posIndex, FilterType filterType, SQLExpr expr, SQLObject owner) {
        ParameterKey key = new ParameterKey(field, paramsFromPos, posIndex, filterType, expr, owner);
        final List vs = this.paramMap.computeIfAbsent(key, k -> new ArrayList());
        if (value instanceof Iterable) {
            Iterable iter = (Iterable)value;
            iter.forEach(new Consumer<Object>(){

                @Override
                public void accept(Object value) {
                    vs.add(value);
                }
            });
        } else if (value != null && value.getClass().isArray()) {
            int n = Array.getLength(value);
            for (int i = 0; i < n; ++i) {
                vs.add(Array.get(value, i));
            }
        } else {
            vs.add(value);
        }
        return key;
    }

    public List<Object> get(String field, int posIndex) {
        return this.paramMap.get(new ParameterKey(field, 0, posIndex, null, null, null));
    }

    public List<Object> get(ParameterKey k) {
        return this.paramMap.get(k);
    }

    public Set<ParameterKey> keys() {
        return this.paramMap.keySet();
    }

    public Set<ParameterKey> shardingEffectiveKeys() {
        HashSet<ParameterKey> set = new HashSet<ParameterKey>();
        for (ParameterKey k : this.paramMap.keySet()) {
            if (!k.isShardingEffective()) continue;
            set.add(k);
        }
        return set;
    }

    public Set<ParameterKey> keys(String field) {
        HashSet<ParameterKey> set = new HashSet<ParameterKey>();
        for (ParameterKey k : this.paramMap.keySet()) {
            if (!field.equals(k.field)) continue;
            set.add(k);
        }
        return set;
    }

    public void reTestShardingEffectiveKeys(String[] shardingFields) {
        if (this.tester != null) {
            this.tester.testEffectiveParameters(shardingFields);
        }
    }

    public void setEffectiveParametersTester(EffectiveParametersTester tester) {
        this.tester = tester;
    }

    public AlwaysValue getAlwaysValue() {
        return this.alwaysValue;
    }

    public void setAlwaysValue(AlwaysValue alwaysValue) {
        this.alwaysValue = alwaysValue;
    }

    public String toString() {
        return this.paramMap.toString();
    }

    public Function<Integer, Object> asVarRefValueProvider() {
        HashMap<Integer, Object> pmap = new HashMap<Integer, Object>(this.paramMap.size());
        for (Map.Entry<ParameterKey, List<Object>> e : this.paramMap.entrySet()) {
            ParameterKey k2 = e.getKey();
            List<Object> vs = e.getValue();
            Object v = vs.size() == 1 ? vs.get(0) : vs;
            pmap.put(k2.posIndex, v);
        }
        return k -> pmap.get(k);
    }

    public Map<ParameterKey, List<Object>> getParamMap() {
        return this.paramMap;
    }

    public static class ParameterKey
    implements Comparable<ParameterKey> {
        public final String field;
        public final int posIndex;
        public final int paramsFromPos;
        private boolean shardingEffective;
        private final FilterType filterType;
        private final SQLObject owner;
        private final SQLExpr expr;
        private final int hashCode;

        public ParameterKey(String field, int paramsFromPos, int posIndex, FilterType filterType, SQLExpr expr, SQLObject owner) {
            this.field = field.toLowerCase();
            this.paramsFromPos = paramsFromPos;
            this.posIndex = posIndex;
            this.filterType = filterType;
            this.expr = expr;
            this.owner = owner;
            this.hashCode = (posIndex + 32 + field).hashCode();
        }

        public SQLExpr getSQLExpr() {
            return this.expr;
        }

        public boolean equals(Object obj) {
            if (null != obj) {
                ParameterKey k = (ParameterKey)obj;
                return this.field.equals(k.field) && this.posIndex == k.posIndex;
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public void setShardingEffective(boolean b) {
            this.shardingEffective = b;
        }

        public boolean isShardingEffective() {
            return this.shardingEffective;
        }

        public FilterType getFilterType() {
            return this.filterType;
        }

        public SQLObject getOwner() {
            return this.owner;
        }

        public int getParameterPositionIndex() {
            return this.posIndex;
        }

        public String toString() {
            return String.valueOf(this.posIndex) + '#' + this.field;
        }

        @Override
        public int compareTo(ParameterKey o) {
            return this.hashCode() - o.hashCode();
        }
    }
}

