/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.sql;

import java.util.ArrayList;
import java.util.List;
import kd.bos.xdb.sharding.sql.SQLInfo;
import kd.bos.xdb.sharding.sql.parser.StatementInfo;
import kd.bos.xdb.sharding.sql.parser.TableInfo;
import kd.bos.xdb.sharding.strategy.ShardingStrategy;

public abstract class ShardingSQL {
    protected final StatementInfo stmtInfo;
    private List<String> shardingTables = new ArrayList<String>();

    public ShardingSQL(StatementInfo stmtInfo) {
        this.stmtInfo = stmtInfo;
    }

    protected ShardingSQL() {
        this.stmtInfo = null;
    }

    public StatementInfo getStatementInfo() {
        return this.stmtInfo;
    }

    public SQLInfo getSQLInfo() {
        return this.stmtInfo.getSQLInfo();
    }

    public List<String> getShardingTables() {
        return this.shardingTables;
    }

    protected void addShardingTable(String shardingTable) {
        this.shardingTables.add(shardingTable);
    }

    protected void addShardingTables(List<String> shardingTables) {
        this.shardingTables.addAll(shardingTables);
    }

    public boolean canSharding() {
        return true;
    }

    public String toString() {
        return this.stmtInfo.toString();
    }

    public abstract ShardingSQL[] sharding(TableInfo var1, ShardingStrategy var2);
}

