/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.sql.condition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.xdb.ext.SelfSetParameter;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.bos.xdb.sharding.sql.ParamsGroup;
import kd.bos.xdb.sharding.sql.parser.ConditionInfo;
import kd.bos.xdb.sharding.sql.parser.StatementInfo;

final class ConditionOptimize {
    private final StatementInfo stmtInfo;
    private final List<ParamsGroup.ParameterKey> pks;
    private final List<ConditionInfo> allCI;

    ConditionOptimize(StatementInfo stmtInfo, List<ParamsGroup.ParameterKey> pks, List<ConditionInfo> allCI) {
        this.stmtInfo = stmtInfo;
        this.pks = pks;
        this.allCI = allCI;
    }

    void optimizeMergeIn() {
        boolean hasIn = false;
        for (ParamsGroup.ParameterKey pk : this.pks) {
            if (pk.getFilterType() != FilterType.in_range) continue;
            hasIn = true;
        }
        if (!hasIn) {
            return;
        }
        Object[] params = this.stmtInfo.getSQLInfo().getParams();
        HashSet<Object> values = new HashSet<Object>(8);
        ArrayList<ValueFilter> filters = new ArrayList<ValueFilter>(8);
        ArrayList<Integer> inList = new ArrayList<Integer>(2);
        for (ParamsGroup.ParameterKey pk : this.pks) {
            int index = pk.getParameterPositionIndex();
            Object param = params[index];
            FilterType filterType = pk.getFilterType();
            switch (filterType) {
                case eq: {
                    values.add(param);
                    filters.add(vs -> vs.removeIf(v -> !Objects.equals(v, param)));
                    break;
                }
                case in_range: {
                    Object[] paramArray = (Object[])param;
                    boolean existSqlParameter = paramArray[0] instanceof SelfSetParameter;
                    if (existSqlParameter) {
                        for (int i = 0; i < paramArray.length; ++i) {
                            if (!(paramArray[i] instanceof SelfSetParameter)) continue;
                            paramArray[i] = ((SelfSetParameter)paramArray[i]).getValue();
                        }
                    }
                    List<Object> ins = Arrays.asList(paramArray);
                    values.addAll(ins);
                    filters.add(vs -> vs.retainAll(ins));
                    inList.add(index);
                    break;
                }
                case not_eq: {
                    filters.add(vs -> vs.remove(param));
                    break;
                }
                case not_in_range: {
                    filters.add(vs -> vs.removeAll(Arrays.asList((Object[])param)));
                    break;
                }
                case gt: {
                    if (param == null) break;
                    filters.add(vs -> {
                        for (Object v : new ArrayList(vs)) {
                            Integer cp = this.compare(v, param);
                            if (cp == null || cp > 0) continue;
                            vs.remove(v);
                        }
                    });
                    break;
                }
                case ge: {
                    if (param == null) break;
                    filters.add(vs -> {
                        for (Object v : new ArrayList(vs)) {
                            Integer cp = this.compare(v, param);
                            if (cp == null || cp >= 0) continue;
                            vs.remove(v);
                        }
                    });
                    break;
                }
                case lt: {
                    if (param == null) break;
                    filters.add(vs -> {
                        for (Object v : new ArrayList(vs)) {
                            Integer cp = this.compare(v, param);
                            if (cp == null || cp < 0) continue;
                            vs.remove(v);
                        }
                    });
                    break;
                }
                case le: {
                    if (param == null) break;
                    filters.add(vs -> {
                        for (Object v : new ArrayList(vs)) {
                            Integer cp = this.compare(v, param);
                            if (cp == null || cp <= 0) continue;
                            vs.remove(v);
                        }
                    });
                    break;
                }
                case between_and: {
                    if (param == null) break;
                    Object param2 = params[index + 1];
                    filters.add(vs -> {
                        for (Object v : new ArrayList(vs)) {
                            Integer cp1 = this.compare(v, param);
                            if (cp1 != null && cp1 < 0) {
                                vs.remove(v);
                                continue;
                            }
                            Integer cp2 = this.compare(v, param2);
                            if (cp2 == null || cp2 <= 0) continue;
                            vs.remove(v);
                        }
                    });
                    break;
                }
                case not_between_and: {
                    if (param == null) break;
                    Object param2 = params[index + 1];
                    filters.add(vs -> {
                        for (Object v : new ArrayList(vs)) {
                            Integer cp1 = this.compare(v, param);
                            if (cp1 != null && cp1 >= 0) {
                                vs.remove(v);
                                continue;
                            }
                            Integer cp2 = this.compare(v, param2);
                            if (cp2 == null || cp2 > 0) continue;
                            vs.remove(v);
                        }
                    });
                    break;
                }
                case like: {
                    Pattern p;
                    String regex2;
                    try {
                        regex2 = String.valueOf(param).replaceAll("_", ".?").replaceAll("%", ".*");
                        p = Pattern.compile(regex2);
                        filters.add(vs -> vs.removeIf(v -> p.matcher(String.valueOf(v)).matches()));
                    }
                    catch (Exception regex2) {}
                    break;
                }
                case not_like: {
                    Pattern p;
                    String regex2;
                    try {
                        regex2 = String.valueOf(param).replaceAll("_", ".?").replaceAll("%", ".*");
                        p = Pattern.compile(regex2);
                        filters.add(vs -> vs.removeIf(v -> !p.matcher(String.valueOf(v)).matches()));
                    }
                    catch (Exception exception) {}
                    break;
                }
            }
        }
        if (!inList.isEmpty()) {
            if (values.isEmpty()) {
                throw new IllegalArgumentException("in parameter can not be empty: " + this.allCI.get((Integer)inList.get(0)).getSQLExpr());
            }
            Object firstParameter = values.iterator().next();
            for (ValueFilter filter : filters) {
                filter.filter(values);
            }
            if (values.isEmpty()) {
                values.add(firstParameter);
            }
            Iterator iterator = inList.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                this.stmtInfo.getSQLInfo().getParams()[index] = values.toArray();
            }
        }
    }

    private Integer compare(Object obj1, Object obj2) {
        if (obj1 != null && obj2 != null && obj1.getClass() == obj2.getClass()) {
            return ((Comparable)obj1).compareTo(obj2);
        }
        return null;
    }

    private static interface ValueFilter {
        public void filter(Set<Object> var1);
    }
}

