/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.sql.condition;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bundle.BosRes;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.sharding.ShardingGroupTable;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.bos.xdb.sharding.sql.ParamsGroup;
import kd.bos.xdb.sharding.sql.SQLInfo;
import kd.bos.xdb.sharding.sql.ShardingSQL;
import kd.bos.xdb.sharding.sql.condition.AlwaysValue;
import kd.bos.xdb.sharding.sql.condition.ConditionExprList;
import kd.bos.xdb.sharding.sql.condition.ConditionOptimize;
import kd.bos.xdb.sharding.sql.condition.EffectiveConditionTester;
import kd.bos.xdb.sharding.sql.condition.EffectiveParametersTester;
import kd.bos.xdb.sharding.sql.condition.ShardingUnreplace;
import kd.bos.xdb.sharding.sql.parser.ConditionInfo;
import kd.bos.xdb.sharding.sql.parser.SQLParser;
import kd.bos.xdb.sharding.sql.parser.SQLUtil;
import kd.bos.xdb.sharding.sql.parser.StatementInfo;
import kd.bos.xdb.sharding.sql.parser.TableInfo;
import kd.bos.xdb.sharding.sql.visitor.ConditionVisitor;
import kd.bos.xdb.sharding.sql.visitor.ExplanSQLVariantVisitor;
import kd.bos.xdb.sharding.sql.visitor.ResolvePropertyOwnerVisitor;
import kd.bos.xdb.sharding.strategy.ShardingStrategy;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.xpm.config.XpmConfig;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;
import kd.bos.xdb.xpm.metrics.performance.MetricFlagEnum;
import kd.bos.xdb.xpm.metrics.performance.PerformanceMetric;

public abstract class ConditionShardingSQL
extends ShardingSQL {
    private int paramsFromPos;
    private List<SQLStatement> expandedStmts = new ArrayList<SQLStatement>();

    public ConditionShardingSQL(StatementInfo stmtInfo) {
        super(stmtInfo);
    }

    public void optimize() {
        ConditionExprList ce = this.collectConditionExprs();
        Pair<ParamsGroup, List<ConditionInfo>> pair = this.mapParamsGroup(ce);
        List allCI = (List)((Pair)pair).value;
        ParamsGroup pg = (ParamsGroup)((Pair)pair).key;
        List<TableInfo> tableInfos = this.stmtInfo.getTableInfos();
        if (pg.getAlwaysValue() == AlwaysValue.always_none) {
            HashMap tobeMergeMap = new HashMap(8);
            EffectiveParametersTester tester = fields -> {
                for (TableInfo tableInfo : tableInfos) {
                    for (SQLExpr expr : ce.getExprList()) {
                        EffectiveConditionTester cet = new EffectiveConditionTester(expr);
                        List<ParamsGroup.ParameterKey> effectiveParameters = cet.testEffectiveParameters(pg, tableInfo, fields);
                        if (effectiveParameters.size() <= 1) continue;
                        tobeMergeMap.put(effectiveParameters, expr);
                    }
                }
            };
            pg.setEffectiveParametersTester(tester);
            HashSet<String> fieldSet = new HashSet<String>(8);
            for (ConditionInfo conditionInfo : allCI) {
                String field = conditionInfo.getField().toLowerCase();
                if (!fieldSet.add(field)) continue;
                tester.testEffectiveParameters(field);
            }
            for (Map.Entry entry : tobeMergeMap.entrySet()) {
                List pks = (List)entry.getKey();
                new ConditionOptimize(this.stmtInfo, pks, allCI).optimizeMergeIn();
            }
        }
    }

    public Pair<ParamsGroup, List<ConditionInfo>> paramsGroup() {
        ConditionExprList ce = this.collectConditionExprs();
        return this.mapParamsGroup(ce);
    }

    public boolean isSupportOptimize() {
        return true;
    }

    @Override
    public ShardingSQL[] sharding(TableInfo shardingSourceTable, ShardingStrategy strategy) {
        ConditionExprList ce = this.collectConditionExprs();
        Pair<ParamsGroup, List<ConditionInfo>> pair = this.mapParamsGroup(ce);
        List allCI = (List)((Pair)pair).value;
        ParamsGroup pg = (ParamsGroup)((Pair)pair).key;
        if (pg.getAlwaysValue() == AlwaysValue.always_none) {
            EffectiveParametersTester tester = shardingFields -> {
                for (ParamsGroup.ParameterKey key : pg.keys()) {
                    key.setShardingEffective(false);
                }
                for (SQLExpr expr : ce.getExprList()) {
                    EffectiveConditionTester cet = new EffectiveConditionTester(expr);
                    List<ParamsGroup.ParameterKey> effectiveParameters = cet.testEffectiveParameters(pg, shardingSourceTable, shardingFields);
                    for (ParamsGroup.ParameterKey pk : effectiveParameters) {
                        pk.setShardingEffective(true);
                    }
                }
            };
            pg.setEffectiveParametersTester(tester);
        }
        ShardingGroupTable[] groups = strategy.shardingGroups(pg, this.isFullShardingValueRequired());
        MetricsCollector mc = MetricsCollector.getCurrent();
        if (mc.isPerformanceMetricEnabled()) {
            PerformanceMetric pm = mc.performanceMetric();
            if (!(pm.isFullShardingCondition() || pm.isUseHint() || pm.isUsePK() || pm.isUseIndex())) {
                ShardingConfig config = strategy.getConfig();
                String tag = pm.isPartShardingCondition() ? "WithoutFullShardingCondition" : "WithoutShardingCondition";
                pm.logCallStack(tag + ' ' + config.getName() + '@' + strategy.getClass().getSimpleName() + ": " + config.getTable() + Arrays.asList(config.getShardingFields()) + "\n\tSQL:\n\t" + this.stmtInfo.toString().replaceAll("\n", "\n\t"));
                pm.setMetricFlag(pm.isPartShardingCondition() ? MetricFlagEnum.withoutFullShardingCondition : MetricFlagEnum.withoutShardingCondition);
            }
            if (groups.length > XpmConfig.getAlarmShardingTableCount()) {
                ArrayList<String> shardingTables = new ArrayList<String>(groups.length);
                TableName tn = null;
                for (ShardingGroupTable group : groups) {
                    tn = TableName.of(group.getShardingTable());
                    shardingTables.add(tn.getSuffix());
                }
                pm.logCallStack("TooManyShardingTables(" + groups.length + '>' + XpmConfig.getAlarmShardingTableCount() + "): " + (tn == null ? "" : tn.getOriginalName()) + '$' + shardingTables + "\n\tSQL:\n\t" + this.stmtInfo.toString().replaceAll("\n", "\n\t"));
                pm.setMetricFlag(MetricFlagEnum.tooManyShardingTables);
            }
        }
        groups = this.appendGroups(groups);
        return this.sharding(shardingSourceTable, allCI, groups);
    }

    public ShardingSQL[] sharding(TableInfo shardingSourceTable, List<ConditionInfo> allCI, ShardingGroupTable[] groups) {
        ArrayList<ConditionShardingSQL> ret = new ArrayList<ConditionShardingSQL>(16);
        for (ShardingGroupTable group : groups) {
            SQLInfo shardedSQLInfo = this.genSQL(group, allCI, shardingSourceTable);
            ConditionShardingSQL shardingSQL = this.genShardingSQL(shardedSQLInfo, group.getShardingTable());
            ret.add(shardingSQL);
        }
        return ret.toArray(new ShardingSQL[ret.size()]);
    }

    protected ShardingGroupTable[] appendGroups(ShardingGroupTable[] groups) {
        return groups;
    }

    protected final ConditionShardingSQL genShardingSQL(SQLInfo shardedSQLInfo, String shardingTable) {
        StatementInfo shardedStmt = SQLParser.parse(shardedSQLInfo);
        shardedStmt.getSQLInfo().setShardingHintContext(shardedSQLInfo.getShardingHintContext());
        try {
            ConditionShardingSQL shardingSQL = (ConditionShardingSQL)this.getClass().getConstructor(StatementInfo.class).newInstance(shardedStmt);
            shardingSQL.addShardingTables(this.getShardingTables());
            shardingSQL.addShardingTable(shardingTable);
            return shardingSQL;
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(BosRes.get((String)"bos-xdb", (String)"ConditionShardingSQL_0", (String)"\u751f\u6210\u5206\u7247\u8bed\u53e5\u9519\u8bef:{0}\u3002", (Object[])new Object[]{e.getMessage()}), e);
        }
    }

    protected Pair<ParamsGroup, List<ConditionInfo>> mapParamsGroup(ConditionExprList ce) {
        ParamsGroup group = new ParamsGroup(this.stmtInfo.getStatementType(), this.stmtInfo.getSQLInfo());
        ArrayList<ConditionInfo> allCI = new ArrayList<ConditionInfo>();
        int invalidIndex = 0;
        int posIndex = 0;
        for (SQLExpr exp : ce.getExprList()) {
            ConditionVisitor cv = new ConditionVisitor();
            cv.setPosIndex(posIndex);
            exp.accept((SQLASTVisitor)cv);
            List<ConditionInfo> cis = cv.getConditionInfos();
            allCI.addAll(cis);
            invalidIndex = cv.getInvalidIndex();
            posIndex = cv.getPosIndex();
        }
        if (!allCI.isEmpty()) {
            Object[] params = this.getSQLInfo().getParams();
            if (params.length > invalidIndex + allCI.size()) {
                this.paramsFromPos = params.length - allCI.size();
            }
            for (ConditionInfo ci : allCI) {
                String field = ci.getField();
                FilterType filterType = ci.getFilterType();
                SQLObject owner = ci.getOwner();
                group.add(field, this.paramsFromPos, params[this.paramsFromPos + ci.getPosIndex()], this.paramsFromPos + ci.getPosIndex(), filterType, ci.getSQLExpr(), owner);
            }
        }
        group.setAlwaysValue(AlwaysValue.of(ce, group.asVarRefValueProvider()));
        return new Pair<ParamsGroup, List<ConditionInfo>>(group, allCI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SQLInfo genSQL(ShardingGroupTable group, List<ConditionInfo> allCI, TableInfo shardingTable) {
        SQLInfo sqlInfo = this.stmtInfo.getSQLInfo();
        SQLStatement stmt = this.stmtInfo.getSQLStatement();
        Object[] params = sqlInfo.getParams();
        ShardingUnreplace unreplace = null;
        SQLExpr originTableExpr = shardingTable.getSQLTableSource().getExpr();
        try {
            shardingTable.getSQLTableSource().setExpr(SQLUtil.wrapSQLTableName(group.getShardingTable()));
            this.resolveSQLPropertyExprOwner(stmt);
            unreplace = this.replaceWhenGenSQL(stmt, shardingTable.getSQLTableSource());
            String dbRoute = XDBConfig.getShardingConfigProvider().getMainConfig(TableName.of(group.getShardingTable()).getOriginalName()).getOptions().getIndexRoute().getRoute(group.getShardingTable());
            SQLInfo ret = new SQLInfo(dbRoute, stmt.toString(), params, true);
            ret.setShardingHintContext(group.getShardingHintContext());
            SQLInfo sQLInfo = ret;
            return sQLInfo;
        }
        finally {
            if (unreplace != null) {
                unreplace.unreplace();
            }
            shardingTable.getSQLTableSource().setExpr(originTableExpr);
            this.resolveSQLPropertyExprOwner(stmt);
        }
    }

    protected void expandSQLVariant(SQLStatement stmt, Object[] params) {
        if (!this.expandedStmts.contains(stmt)) {
            this.expandedStmts.add(stmt);
            new ExplanSQLVariantVisitor(params).expand(stmt);
        }
    }

    protected ShardingUnreplace replaceWhenGenSQL(SQLStatement stmt, SQLExprTableSource shardingTableExpr) {
        return null;
    }

    protected void resolveSQLPropertyExprOwner(SQLStatement stmt) {
        stmt.accept((SQLASTVisitor)new ResolvePropertyOwnerVisitor());
    }

    public SQLInfo genNoShardingSQL() {
        SQLInfo sqlInfo = this.stmtInfo.getSQLInfo();
        SQLStatement stmt = this.stmtInfo.getSQLStatement();
        Object[] params = sqlInfo.getParams();
        this.expandSQLVariant(stmt, params);
        String sql = stmt.toString();
        return new SQLInfo(sqlInfo.getDbRoute(), sql, params, sqlInfo.isShardingSQL());
    }

    protected abstract boolean isFullShardingValueRequired();

    protected abstract ConditionExprList collectConditionExprs();

    public static class Pair<K, V> {
        private K key;
        private V value;

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

