/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.sql.condition;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.sharding.config.ChildrenTableConfig;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.sql.ParamsGroup;
import kd.bos.xdb.sharding.sql.condition.AlwaysValue;
import kd.bos.xdb.sharding.sql.condition.eval.Evalor;
import kd.bos.xdb.sharding.sql.condition.eval.SQLExprEvalorGenner;
import kd.bos.xdb.sharding.sql.parser.TableInfo;

public class EffectiveConditionTester {
    private Evalor executor;

    public EffectiveConditionTester(SQLExpr conditionExpr) {
        SQLExprEvalorGenner conditionEval = new SQLExprEvalorGenner(conditionExpr);
        this.executor = conditionEval.gen();
    }

    private boolean isOwnGroupTableIndexField(ParamsGroup.ParameterKey key, TableInfo shardingSourceTable, Map<SQLObject, Optional<MainTableConfig>> groupTableMainTableConfigMap) {
        SQLObject owner = key.getOwner();
        Optional<MainTableConfig> option = groupTableMainTableConfigMap.get(owner);
        if (option == null) {
            ShardingConfig mainConfig = null;
            boolean groupTable = false;
            SQLExprTableSource sqlTableSource = shardingSourceTable.getSQLTableSource();
            if (sqlTableSource.getParent() instanceof SQLJoinTableSource && owner == ((SQLJoinTableSource)sqlTableSource.getParent()).getRight()) {
                ChildrenTableConfig childrenConfig;
                SQLTableSource ss = (SQLTableSource)owner;
                String tableName = null;
                tableName = ss instanceof SQLExprTableSource ? ((SQLExprTableSource)ss).getTableName() : ss.toString();
                ShardingConfig config = XDBConfig.getShardingConfigProvider().getConfig(tableName);
                if (config instanceof ChildrenTableConfig && (mainConfig = (childrenConfig = (ChildrenTableConfig)config).getParent()) instanceof MainTableConfig) {
                    groupTable = childrenConfig.isGroupTableConfig();
                }
            }
            option = groupTable ? Optional.of((MainTableConfig)mainConfig) : Optional.empty();
            groupTableMainTableConfigMap.put(owner, option);
        }
        return option.isPresent() && option.get().getOptions().hasIndexDefine(owner.toString(), key.field);
    }

    public List<ParamsGroup.ParameterKey> testEffectiveParameters(ParamsGroup pg, TableInfo shardingSourceTable, String ... fields) {
        ArrayList<ParamsGroup.ParameterKey> ret = new ArrayList<ParamsGroup.ParameterKey>();
        HashSet<String> fieldSet = new HashSet<String>(Arrays.asList(fields));
        Function<Integer, Object> varRefValueProvider = pg.asVarRefValueProvider();
        SQLExprTableSource sqlTableSource = shardingSourceTable.getSQLTableSource();
        HashMap<SQLObject, Optional<MainTableConfig>> groupTableMainTableConfigMap = null;
        for (ParamsGroup.ParameterKey key : pg.keys()) {
            boolean b;
            if (!fieldSet.contains(key.field)) continue;
            if (key.getOwner() != sqlTableSource) {
                if (groupTableMainTableConfigMap == null) {
                    groupTableMainTableConfigMap = new HashMap<SQLObject, Optional<MainTableConfig>>();
                }
                if (!this.isOwnGroupTableIndexField(key, shardingSourceTable, groupTableMainTableConfigMap)) continue;
            }
            if (b = this.executor.eval(expr -> {
                SQLExpr keySQLExpr = key.getSQLExpr();
                if (expr == keySQLExpr || expr instanceof SQLInSubQueryExpr && keySQLExpr instanceof SQLMethodInvokeExpr && ((SQLMethodInvokeExpr)keySQLExpr).getMethodName().toUpperCase().equals("TABLE")) {
                    return false;
                }
                return AlwaysValue.testAlways(expr.clone(), varRefValueProvider) != AlwaysValue.always_false;
            })) continue;
            ret.add(key);
        }
        return ret;
    }
}

