/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.sql.ddl;

import com.alibaba.druid.sql.ast.statement.SQLDDLStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropIndexStatement;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.sharding.sql.ddl.DDLShardingSQL;
import kd.bos.xdb.sharding.sql.parser.SQLUtil;
import kd.bos.xdb.sharding.sql.parser.StatementInfo;
import kd.bos.xdb.tablemanager.AliasManager;

public class DropIndexShardingSQL
extends DDLShardingSQL {
    public DropIndexShardingSQL(StatementInfo stmtInfo) {
        super(stmtInfo);
    }

    @Override
    protected SQLDDLStatement reParseStatement() {
        return (SQLDDLStatement)this.stmtInfo.getSQLStatement();
    }

    @Override
    protected String genDDL(String shardingTable, SQLDDLStatement stmt) {
        SQLDropIndexStatement dropStmt = (SQLDropIndexStatement)stmt;
        String constraint_name = dropStmt.getIndexName().getSimpleName();
        String indexName = AliasManager.get().getIndexAliasName(shardingTable, constraint_name);
        if (XDBConfig.get().isUseKSQL()) {
            return "DROP INDEX " + SQLUtil.wrapSQLTableName(shardingTable) + '.' + SQLUtil.wrapSQLTableName(indexName);
        }
        return "DROP INDEX " + SQLUtil.wrapSQLTableName(indexName) + " ON " + SQLUtil.wrapSQLTableName(shardingTable);
    }
}

