/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.sql.dml;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.KSQLPAlterColumnStatement;
import com.alibaba.druid.sql.ast.statement.KSQLPAlterPKStatement;
import com.alibaba.druid.sql.ast.statement.KSQLPDropIdxStatement;
import com.alibaba.druid.sql.ast.statement.KSQLPModifyObjectNameStatement;
import com.alibaba.druid.sql.ast.statement.SQLEXECIndex;
import com.alibaba.druid.sql.ast.statement.SQLEXECStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bundle.BosRes;
import kd.bos.exception.XDBErrorCode;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.engine.ShardingEngineFactory;
import kd.bos.xdb.exception.LimitedSQLException;
import kd.bos.xdb.sharding.ShardingFieldValue;
import kd.bos.xdb.sharding.ShardingGroupTable;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.config.ShardingConfigProvider;
import kd.bos.xdb.sharding.sql.ParamsGroup;
import kd.bos.xdb.sharding.sql.PropertyInfo;
import kd.bos.xdb.sharding.sql.SQLInfo;
import kd.bos.xdb.sharding.sql.ShardingSQL;
import kd.bos.xdb.sharding.sql.condition.ConditionExprList;
import kd.bos.xdb.sharding.sql.condition.ConditionShardingSQL;
import kd.bos.xdb.sharding.sql.condition.ShardingUnreplace;
import kd.bos.xdb.sharding.sql.dml.DMLShardingSQL;
import kd.bos.xdb.sharding.sql.parser.ConditionInfo;
import kd.bos.xdb.sharding.sql.parser.SQLUtil;
import kd.bos.xdb.sharding.sql.parser.StatementInfo;
import kd.bos.xdb.sharding.sql.parser.TableInfo;
import kd.bos.xdb.sharding.strategy.ShardingStrategy;
import kd.bos.xdb.tablemanager.AliasManager;
import kd.bos.xdb.tablemanager.TableName;

public class ExecShardingSQL
extends DMLShardingSQL {
    public ExecShardingSQL(StatementInfo statementInfo) {
        super(statementInfo);
        this.limitDropTabOrChgShardField((SQLEXECStatement)this.stmtInfo.getSQLStatement());
    }

    private void limitDropTabOrChgShardField(SQLEXECStatement stmt) {
        PropertyInfo pi;
        HashSet<String> fields;
        SQLExprTableSource tableSource = stmt.getTableSource();
        SQLExpr column = null;
        if (stmt instanceof KSQLPModifyObjectNameStatement) {
            if (((KSQLPModifyObjectNameStatement)stmt).isAlterTable()) {
                throw new LimitedSQLException(XDBErrorCode.xdbDeleteShardingTable, BosRes.get((String)"bos-xdb", (String)"ExecShardingSQL_0", (String)"\u4e0d\u5141\u8bb8\u5220\u9664\u5206\u7247\u8868\uff0c\u8bf7\u5148\u5220\u9664\u5206\u7247\u914d\u7f6e\u3002", (Object[])new Object[0]) + stmt.getTableSource().getName().getSimpleName());
            }
            column = ((KSQLPModifyObjectNameStatement)stmt).getColumn();
        }
        if (stmt instanceof KSQLPAlterPKStatement) {
            // empty if block
        }
        if (stmt instanceof KSQLPDropIdxStatement) {
            // empty if block
        }
        if (stmt instanceof KSQLPAlterColumnStatement) {
            column = ((KSQLPAlterColumnStatement)stmt).getColumn();
        }
        ShardingConfigProvider scp = ShardingEngineFactory.get().getShardingConfigProvider();
        ShardingConfig config = scp.getConfig(tableSource.getName().toString());
        if (column != null && config != null && (fields = new HashSet<String>(Arrays.asList(config.getShardingFields()))).contains((pi = PropertyInfo.of(column, true)).getField())) {
            throw new LimitedSQLException(XDBErrorCode.xdbDeleteShardingColumn, BosRes.get((String)"bos-xdb", (String)"ExecShardingSQL_1", (String)"\u4e0d\u5141\u8bb8\u5220\u9664\u5206\u7247\u5c5e\u6027: ", (Object[])new Object[0]) + column);
        }
    }

    @Override
    public ShardingSQL[] sharding(TableInfo shardingSourceTable, ShardingStrategy strategy) {
        ConditionExprList ce = this.collectConditionExprs();
        ConditionShardingSQL.Pair<ParamsGroup, List<ConditionInfo>> pair = this.mapParamsGroup(ce);
        List<ConditionInfo> allCI = pair.getValue();
        ParamsGroup pg = pair.getKey();
        ArrayList<ConditionShardingSQL> ret = new ArrayList<ConditionShardingSQL>(16);
        ShardingGroupTable[] groups = strategy.shardingGroups(pg, this.isFullShardingValueRequired());
        List<Object> fieldValues = new ArrayList();
        boolean isFirst = true;
        for (ShardingGroupTable group : groups) {
            if (isFirst) {
                fieldValues = group.getFieldValues();
                isFirst = false;
            }
            SQLInfo shardedSQLInfo = this.genSQL(group, allCI, shardingSourceTable);
            ConditionShardingSQL conditionShardingSQL = this.genShardingSQL(shardedSQLInfo, group.getShardingTable());
            ret.add(conditionShardingSQL);
        }
        String originalTableName = shardingSourceTable.getName();
        TableName tableName = TableName.of(originalTableName);
        String prototypeTable = tableName.getPrototypeTable();
        ShardingGroupTable prototypeGroup = new ShardingGroupTable(prototypeTable);
        for (ShardingFieldValue shardingFieldValue : fieldValues) {
            prototypeGroup.addShardingFieldValue(shardingFieldValue);
        }
        prototypeGroup.setIfExistsShardingHintContext(tableName.getOriginalName());
        SQLInfo prototypeSqlInfo = this.genSQL(prototypeGroup, allCI, shardingSourceTable);
        ConditionShardingSQL conditionShardingSQL = this.genShardingSQL(prototypeSqlInfo, prototypeTable);
        ret.add(conditionShardingSQL);
        Set<String> archiveRoutes = XDBConfig.getShardingConfigProvider().getMainConfig(tableName.getOriginalName()).getOptions().getIndexRoute().getAllArchiveRoutes();
        for (String archiveRoute : archiveRoutes) {
            SQLInfo archiveSqlInfo = new SQLInfo(archiveRoute, prototypeSqlInfo.getSql(), prototypeSqlInfo.getParams(), true);
            archiveSqlInfo.setShardingHintContext(prototypeSqlInfo.getShardingHintContext());
            ConditionShardingSQL conditionShardingSQL2 = this.genShardingSQL(archiveSqlInfo, prototypeTable);
            ret.add(conditionShardingSQL2);
        }
        String originalsnapTable = tableName.getOriginalsnapTable();
        ShardingGroupTable originalsnapGroup = new ShardingGroupTable(originalsnapTable);
        for (ShardingFieldValue shardingFieldValue : fieldValues) {
            originalsnapGroup.addShardingFieldValue(shardingFieldValue);
        }
        originalsnapGroup.setIfExistsShardingHintContext(tableName.getOriginalName());
        SQLInfo originalsnapSqlInfo = this.genSQL(originalsnapGroup, allCI, shardingSourceTable);
        ConditionShardingSQL conditionShardingSQL3 = this.genShardingSQL(originalsnapSqlInfo, originalsnapTable);
        ret.add(conditionShardingSQL3);
        return ret.toArray(new ShardingSQL[ret.size()]);
    }

    @Override
    protected boolean isFullShardingValueRequired() {
        return false;
    }

    @Override
    protected ConditionExprList collectConditionExprs() {
        return new ConditionExprList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SQLInfo genSQL(ShardingGroupTable group, List<ConditionInfo> allCI, TableInfo shardingTable) {
        SQLInfo sqlInfo = this.stmtInfo.getSQLInfo();
        SQLStatement stmt = this.stmtInfo.getSQLStatement();
        Object[] params = sqlInfo.getParams();
        this.expandSQLVariant(stmt, params);
        ShardingUnreplace unreplace = null;
        SQLExpr originTableExpr = shardingTable.getSQLTableSource().getExpr();
        try {
            shardingTable.getSQLTableSource().setExpr(SQLUtil.wrapSQLTableName(group.getShardingTable()));
            this.resolveSQLPropertyExprOwner(stmt);
            unreplace = this.replaceWhenGenSQL(stmt, shardingTable.getSQLTableSource());
            String orignalIndexName = null;
            if (stmt instanceof SQLEXECIndex) {
                orignalIndexName = ((SQLEXECIndex)stmt).getIndexName().toString();
                String shardingTableName = shardingTable.getSQLTableSource().getName().toString();
                String shardingIndexName = AliasManager.get().getIndexAliasName(shardingTableName, orignalIndexName);
                ((SQLEXECIndex)stmt).setIndexName((SQLName)new SQLIdentifierExpr(shardingIndexName));
            }
            String sql = stmt.toString();
            if (stmt instanceof SQLEXECIndex) {
                ((SQLEXECIndex)stmt).setIndexName((SQLName)new SQLIdentifierExpr(orignalIndexName));
            }
            String dbRoute = XDBConfig.getShardingConfigProvider().getMainConfig(TableName.of(group.getShardingTable()).getOriginalName()).getOptions().getIndexRoute().getRoute(group.getShardingTable());
            SQLInfo ret = new SQLInfo(dbRoute, sql, params, true);
            ret.setShardingHintContext(group.getShardingHintContext());
            SQLInfo sQLInfo = ret;
            return sQLInfo;
        }
        finally {
            if (unreplace != null) {
                unreplace.unreplace();
            }
            shardingTable.getSQLTableSource().setExpr(originTableExpr);
            this.resolveSQLPropertyExprOwner(stmt);
        }
    }
}

