/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.sql.dml;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.KSQLIfExistsStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropColumnItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLDDLStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bundle.BosRes;
import kd.bos.exception.XDBErrorCode;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.engine.ShardingEngineFactory;
import kd.bos.xdb.exception.LimitedSQLException;
import kd.bos.xdb.sharding.ShardingFieldValue;
import kd.bos.xdb.sharding.ShardingGroupTable;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.config.ShardingConfigProvider;
import kd.bos.xdb.sharding.sql.ParamsGroup;
import kd.bos.xdb.sharding.sql.PropertyInfo;
import kd.bos.xdb.sharding.sql.SQLInfo;
import kd.bos.xdb.sharding.sql.ShardingSQL;
import kd.bos.xdb.sharding.sql.condition.ConditionExprList;
import kd.bos.xdb.sharding.sql.condition.ConditionShardingSQL;
import kd.bos.xdb.sharding.sql.condition.ShardingUnreplace;
import kd.bos.xdb.sharding.sql.dml.DMLShardingSQL;
import kd.bos.xdb.sharding.sql.parser.ConditionInfo;
import kd.bos.xdb.sharding.sql.parser.SQLUtil;
import kd.bos.xdb.sharding.sql.parser.StatementInfo;
import kd.bos.xdb.sharding.sql.parser.TableInfo;
import kd.bos.xdb.sharding.strategy.ShardingStrategy;
import kd.bos.xdb.tablemanager.AliasManager;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.xpm.metrics.action.sharding.spec.IfExistsSpan;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;

public class IfExistsShardingSQL
extends DMLShardingSQL {
    private static final String ksqlTabNameKeys = "ksql_tabname,ksql_col_tabname,ksql_cons_tabname";
    private static final Set<String> ksqlTabNameKeySet = new HashSet<String>(Arrays.asList("ksql_tabname,ksql_col_tabname,ksql_cons_tabname".split(",")));

    public IfExistsShardingSQL(StatementInfo stmtInfo) {
        super(stmtInfo);
        this.limitDropTabOrChgShardField((KSQLIfExistsStatement)stmtInfo.getSQLStatement());
    }

    private void limitDropTabOrChgShardField(KSQLIfExistsStatement stmt) {
        List<SQLStatement> sqlStatementList = stmt.getStatements();
        if (!sqlStatementList.isEmpty()) {
            ShardingConfigProvider scp;
            ShardingConfig config;
            SQLStatement sqlStatement = sqlStatementList.get(0);
            if (sqlStatement instanceof SQLDropTableStatement) {
                throw new LimitedSQLException(XDBErrorCode.xdbDeleteShardingTable, BosRes.get((String)"bos-xdb", (String)"IfExistsShardingSQL_0", (String)"\u4e0d\u5141\u8bb8\u5220\u9664\u5206\u7247\u8868\uff0c\u8bf7\u5148\u5220\u9664\u5206\u7247\u914d\u7f6e\u3002", (Object[])new Object[0]) + ((SQLExprTableSource)((SQLDropTableStatement)sqlStatement).getTableSources().get(0)).getName().toString());
            }
            if (sqlStatement instanceof SQLAlterTableStatement && (config = (scp = ShardingEngineFactory.get().getShardingConfigProvider()).getConfig(((SQLAlterTableStatement)sqlStatement).getTableSource().getName().toString())) != null) {
                HashSet<String> fields = new HashSet<String>(Arrays.asList(config.getShardingFields()));
                for (SQLAlterTableItem alterItem : ((SQLAlterTableStatement)sqlStatement).getItems()) {
                    if (!(alterItem instanceof SQLAlterTableDropColumnItem)) continue;
                    for (SQLName sqlName : ((SQLAlterTableDropColumnItem)alterItem).getColumns()) {
                        PropertyInfo pi = PropertyInfo.of((SQLExpr)sqlName, true);
                        if (!fields.contains(pi.getField())) continue;
                        throw new LimitedSQLException(XDBErrorCode.xdbDeleteShardingColumn, BosRes.get((String)"bos-xdb", (String)"IfExistsShardingSQL_1", (String)"\u4e0d\u5141\u8bb8\u5220\u9664\u5206\u7247\u5c5e\u6027: ", (Object[])new Object[0]) + sqlName);
                    }
                }
            }
        }
    }

    @Override
    protected boolean isFullShardingValueRequired() {
        return false;
    }

    @Override
    protected ConditionExprList collectConditionExprs() {
        SQLSelect condition;
        SQLExpr where;
        ConditionExprList ce = new ConditionExprList();
        KSQLIfExistsStatement stmt = (KSQLIfExistsStatement)this.stmtInfo.getSQLStatement();
        List childrens = stmt.getCondition().getChildren();
        if (!childrens.isEmpty() && childrens.get(0) instanceof SQLSelect && (where = (condition = (SQLSelect)childrens.get(0)).getFirstQueryBlock().getWhere()) != null) {
            ce.add(where);
        }
        return ce;
    }

    @Override
    public ShardingSQL[] sharding(TableInfo shardingSourceTable, ShardingStrategy strategy) {
        ConditionExprList ce = this.collectConditionExprs();
        ConditionShardingSQL.Pair<ParamsGroup, List<ConditionInfo>> pair = this.mapParamsGroup(ce);
        List<ConditionInfo> allCI = pair.getValue();
        ParamsGroup pg = pair.getKey();
        ShardingGroupTable[] groups = strategy.shardingGroups(pg, this.isFullShardingValueRequired());
        if (groups.length == 0) {
            return new ShardingSQL[0];
        }
        List<ShardingFieldValue> fieldValues = groups[0].getFieldValues();
        ArrayList<ShardingSQL> ret = new ArrayList<ShardingSQL>(groups.length + 1);
        for (ShardingGroupTable group : groups) {
            SQLInfo shardedSQLInfo = this.genSQL(group, allCI, shardingSourceTable);
            ConditionShardingSQL shardingSQL = this.genShardingSQL(shardedSQLInfo, group.getShardingTable());
            ret.add(shardingSQL);
        }
        String originalTableName = shardingSourceTable.getName();
        TableName tableName = TableName.of(originalTableName);
        KSQLIfExistsStatement ifStmt = (KSQLIfExistsStatement)this.stmtInfo.getSQLStatement();
        SQLStatement execStmt = ifStmt.getStatements().get(0);
        if (execStmt instanceof SQLDDLStatement) {
            String prototypeTable = tableName.getPrototypeTable();
            ShardingGroupTable prototypeGroup = new ShardingGroupTable(prototypeTable);
            for (ShardingFieldValue fieldValue : fieldValues) {
                prototypeGroup.addShardingFieldValue(fieldValue);
            }
            prototypeGroup.setIfExistsShardingHintContext(tableName.getOriginalName());
            SQLInfo prototypeSqlInfo = this.genSQL(prototypeGroup, allCI, shardingSourceTable);
            ConditionShardingSQL prototypeShardingSQL = this.genShardingSQL(prototypeSqlInfo, prototypeTable);
            ret.add(prototypeShardingSQL);
            Set<String> archiveRoutes = XDBConfig.getShardingConfigProvider().getMainConfig(tableName.getOriginalName()).getOptions().getIndexRoute().getAllArchiveRoutes();
            for (String archiveRoute : archiveRoutes) {
                SQLInfo archiveSqlInfo = new SQLInfo(archiveRoute, prototypeSqlInfo.getSql(), prototypeSqlInfo.getParams(), true);
                archiveSqlInfo.setShardingHintContext(prototypeSqlInfo.getShardingHintContext());
                ConditionShardingSQL archiveRrototypeShardingSQL = this.genShardingSQL(archiveSqlInfo, prototypeTable);
                ret.add(archiveRrototypeShardingSQL);
            }
            String originalsnapTable = tableName.getOriginalsnapTable();
            ShardingGroupTable originalsnapGroup = new ShardingGroupTable(originalsnapTable);
            for (ShardingFieldValue fieldValue : fieldValues) {
                originalsnapGroup.addShardingFieldValue(fieldValue);
            }
            originalsnapGroup.setIfExistsShardingHintContext(tableName.getOriginalName());
            SQLInfo originalsnapSqlInfo = this.genSQL(originalsnapGroup, allCI, shardingSourceTable);
            ConditionShardingSQL originalsnapShardingSQL = this.genShardingSQL(originalsnapSqlInfo, originalsnapTable);
            ret.add(originalsnapShardingSQL);
        }
        HashSet<String> ks = new HashSet<String>(fieldValues.size());
        for (ShardingFieldValue fv : fieldValues) {
            if (!ksqlTabNameKeySet.contains(fv.getField())) continue;
            ks.add(fv.getField());
        }
        if (!ks.isEmpty()) {
            boolean hasAlterValue = false;
            boolean[] alterValue = new boolean[allCI.size()];
            for (int i = 0; i < alterValue.length; ++i) {
                if (!ks.contains(allCI.get(i).getField().toLowerCase())) continue;
                alterValue[i] = true;
                if (hasAlterValue) continue;
                hasAlterValue = true;
            }
            if (hasAlterValue) {
                MetricsCollector mc = MetricsCollector.getCurrent();
                for (ShardingSQL ss : ret) {
                    SQLInfo si = ss.getSQLInfo();
                    TableName tn = TableName.of(ss.getShardingTables().get(0));
                    String replaceTableName = tn.getAliasName() + "$" + tn.getSuffix();
                    Object[] params = si.getParams();
                    Object[] newParams = Arrays.copyOf(params, params.length);
                    for (int j = 0; j < alterValue.length; ++j) {
                        if (!alterValue[j]) continue;
                        newParams[j] = replaceTableName;
                    }
                    si.setParams(newParams);
                    if (!mc.isActionMetricEnabled()) continue;
                    mc.actionMetric().stat(new IfExistsSpan(si.getSql(), params, Arrays.copyOf(newParams, params.length)));
                }
            }
        }
        this.replaceParams(originalTableName, ret);
        return ret.toArray(new ShardingSQL[ret.size()]);
    }

    private void replaceParams(String originalTableName, List<ShardingSQL> ret) {
        for (ShardingSQL shadingSql : ret) {
            Object[] params = shadingSql.getSQLInfo().getParams();
            if (params == null) continue;
            int paramIndex = 0;
            String shardingTable = shadingSql.getShardingTables().get(0);
            for (Object param : params) {
                if (param != null && originalTableName.equalsIgnoreCase(String.valueOf(param))) {
                    params[paramIndex] = shardingTable;
                }
                ++paramIndex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SQLInfo genSQL(ShardingGroupTable group, List<ConditionInfo> allCI, TableInfo shardingTable) {
        SQLInfo sqlInfo = this.stmtInfo.getSQLInfo();
        SQLStatement stmt = this.stmtInfo.getSQLStatement();
        Object[] params = sqlInfo.getParams();
        this.expandSQLVariant(stmt, params);
        ShardingUnreplace unreplace = null;
        SQLExpr originTableExpr = shardingTable.getSQLTableSource().getExpr();
        try {
            shardingTable.getSQLTableSource().setExpr(SQLUtil.wrapSQLTableName(group.getShardingTable()));
            this.resolveSQLPropertyExprOwner(stmt);
            unreplace = this.replaceWhenGenSQL(stmt, shardingTable.getSQLTableSource());
            String dbRoute = XDBConfig.getShardingConfigProvider().getMainConfig(TableName.of(group.getShardingTable()).getOriginalName()).getOptions().getIndexRoute().getRoute(group.getShardingTable());
            List<SQLStatement> sqlStatementList = ((KSQLIfExistsStatement)stmt).getStatements();
            if (!sqlStatementList.isEmpty()) {
                SQLStatement sqlStatement = sqlStatementList.get(0);
                if (sqlStatement instanceof SQLCreateIndexStatement) {
                    SQLInfo sQLInfo = this.getCreateIndexSQLInfo((KSQLIfExistsStatement)stmt, shardingTable, params, dbRoute);
                    return sQLInfo;
                }
                if (sqlStatement instanceof SQLDropIndexStatement) {
                    SQLInfo sQLInfo = this.getDropIndexSQLInfo((KSQLIfExistsStatement)stmt, shardingTable, params, dbRoute);
                    return sQLInfo;
                }
            }
            SQLInfo ret = new SQLInfo(dbRoute, stmt.toString(), params, true);
            ret.setShardingHintContext(group.getShardingHintContext());
            SQLInfo sQLInfo = ret;
            return sQLInfo;
        }
        finally {
            if (unreplace != null) {
                unreplace.unreplace();
            }
            shardingTable.getSQLTableSource().setExpr(originTableExpr);
            this.resolveSQLPropertyExprOwner(stmt);
        }
    }

    private SQLInfo getCreateIndexSQLInfo(KSQLIfExistsStatement stmt, TableInfo shardingTable, Object[] params, String dbRoute) {
        Object[] cloneParams = null;
        SQLCreateIndexStatement sqlStatement = (SQLCreateIndexStatement)stmt.getStatements().get(0);
        String orignalIndexName = sqlStatement.getName().toString();
        String shardingTableName = shardingTable.getSQLTableSource().getName().toString();
        String shardingIndexName = AliasManager.get().getIndexAliasName(shardingTableName, orignalIndexName);
        sqlStatement.setName((SQLName)new SQLIdentifierExpr(shardingIndexName));
        if (params != null) {
            cloneParams = (Object[])params.clone();
            for (int i = 0; i < cloneParams.length; ++i) {
                String paramStr = String.valueOf(cloneParams[i]);
                if (!orignalIndexName.equalsIgnoreCase(paramStr)) continue;
                cloneParams[i] = shardingIndexName;
            }
        }
        String sql = stmt.toString();
        sqlStatement.setName((SQLName)new SQLIdentifierExpr(orignalIndexName));
        return new SQLInfo(dbRoute, sql, cloneParams, true);
    }

    private SQLInfo getDropIndexSQLInfo(KSQLIfExistsStatement stmt, TableInfo shardingTable, Object[] params, String dbRoute) {
        Object[] cloneParams = null;
        SQLDropIndexStatement sqlStatement = (SQLDropIndexStatement)stmt.getStatements().get(0);
        String orignalIndexName = sqlStatement.getIndexName().toString();
        String shardingTableName = shardingTable.getSQLTableSource().getName().toString();
        String shardingIndexName = AliasManager.get().getIndexAliasName(shardingTableName, orignalIndexName);
        sqlStatement.setIndexName((SQLName)new SQLIdentifierExpr(shardingIndexName));
        if (params != null) {
            cloneParams = (Object[])params.clone();
            for (int i = 0; i < cloneParams.length; ++i) {
                String paramStr = String.valueOf(cloneParams[i]);
                if (!orignalIndexName.equalsIgnoreCase(paramStr)) continue;
                cloneParams[i] = shardingIndexName;
            }
        }
        String sql = stmt.toString();
        sqlStatement.setIndexName((SQLName)new SQLIdentifierExpr(orignalIndexName));
        return new SQLInfo(dbRoute, sql, cloneParams, true);
    }
}

