/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.sql.dml;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bundle.BosRes;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.engine.ShardingContext;
import kd.bos.xdb.exception.XdbException;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.ShardingFieldValue;
import kd.bos.xdb.sharding.ShardingGroupTable;
import kd.bos.xdb.sharding.config.ChildrenTableConfig;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.bos.xdb.sharding.sql.FinalShardingSQL;
import kd.bos.xdb.sharding.sql.ParamsGroup;
import kd.bos.xdb.sharding.sql.SQLInfo;
import kd.bos.xdb.sharding.sql.ShardingSQL;
import kd.bos.xdb.sharding.sql.StatementType;
import kd.bos.xdb.sharding.sql.condition.ConditionExprList;
import kd.bos.xdb.sharding.sql.dml.DMLShardingSQL;
import kd.bos.xdb.sharding.sql.parser.ConditionInfo;
import kd.bos.xdb.sharding.sql.parser.StatementInfo;
import kd.bos.xdb.sharding.sql.parser.TableInfo;
import kd.bos.xdb.sharding.strategy.AbstractShardingStrategy;
import kd.bos.xdb.sharding.strategy.ShardingStrategy;
import kd.bos.xdb.tablemanager.TableName;

public class InsertShardingSQL
extends DMLShardingSQL {
    private String[] insertFields;

    public InsertShardingSQL(StatementInfo stmtInfo) {
        super(stmtInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ShardingSQL[] sharding(TableInfo shardingSourceTable, ShardingStrategy strategy) {
        List<ParamsGroup> pgs = this.mapParamsGroups();
        HashSet<String> shardingFieldSet = new HashSet<String>(Arrays.asList(strategy.getConfig().getShardingFields()));
        for (ParamsGroup pg : pgs) {
            for (ParamsGroup.ParameterKey key : pg.keys()) {
                if (!shardingFieldSet.contains(key.field)) continue;
                key.setShardingEffective(true);
            }
        }
        ArrayList<FinalShardingSQL> ret = new ArrayList<FinalShardingSQL>();
        for (ParamsGroup pg : pgs) {
            ShardingGroupTable[] groups = strategy.shardingGroups(pg, true);
            if (groups.length != 1) {
                String msg = "Insert sharding failed: ";
                if (groups.length == 0) {
                    throw new XdbException(msg + " found none sharding table index.");
                }
                HashSet<String> hintShardingTableSet = new HashSet<String>();
                ShardingHintContext sc = groups[0].getShardingHintContext();
                long[] shardingIndex = groups[0].getShardingHintContext().tryShardingIndex(strategy.getConfig());
                boolean skipHint = sc.isSkipHint();
                ShardingContext shardingContext = ShardingContext.get();
                try {
                    sc.setSkipHint(true);
                    TableName tn = TableName.of(strategy.getConfig().getTable());
                    String[] hintShardingTables = new String[shardingIndex.length];
                    for (int i = 0; i < shardingIndex.length; ++i) {
                        hintShardingTables[i] = tn.getShardingTable(shardingIndex[i]);
                    }
                    hintShardingTableSet.addAll(Arrays.asList(hintShardingTables));
                    shardingContext.setHintShardingTables(strategy, hintShardingTables);
                    groups = strategy.shardingGroups(pg, true);
                }
                finally {
                    sc.setSkipHint(skipHint);
                    shardingContext.setHintShardingTables(strategy, null);
                }
                if (groups.length != 1) {
                    if (groups.length == 0) {
                        throw new XdbException(msg + " found none sharding table index.");
                    }
                    throw new XdbException(msg + " found more than one sharding table " + hintShardingTableSet + (sc == null ? "" : ", in sharding hint=" + sc) + '.');
                }
                if (!hintShardingTableSet.contains(groups[0].getShardingTable())) {
                    throw new XdbException(msg + ", sharding data has been changed while re-sharding:" + hintShardingTableSet + "->" + groups[0].getShardingTable() + (sc == null ? "" : ", in sharding hint=" + sc) + '.');
                }
            }
            for (ShardingGroupTable group : groups) {
                MainTableConfig mc;
                Set<String> indexNameSet;
                ChildrenTableConfig cc;
                SQLInfo sqlInfo = this.genSQL(group, null, shardingSourceTable);
                ret.add(new FinalShardingSQL(sqlInfo, group.getShardingTable()));
                if (!(strategy.getConfig() instanceof ChildrenTableConfig) || !(cc = (ChildrenTableConfig)strategy.getConfig()).isGroupTableConfig() || !(cc.getParent() instanceof MainTableConfig) || (indexNameSet = (mc = (MainTableConfig)cc.getParent()).getOptions().getIndexNameSet()).isEmpty()) continue;
                String pkField = ((AbstractShardingStrategy)mc.getShardingStrategy()).getPKField();
                ShardingFieldValue pkFV = null;
                ArrayList<ShardingFieldValue> indexFV = new ArrayList<ShardingFieldValue>();
                for (ShardingFieldValue fv : group.getFieldValues()) {
                    if (indexNameSet.contains(fv.getField())) {
                        indexFV.add(fv);
                    }
                    if (pkFV != null || !pkField.equals(fv.getField())) continue;
                    pkFV = fv;
                }
                if (indexFV.isEmpty() || pkFV == null) continue;
                TableName tn = TableName.of(mc.getTable());
                Object[] ps = new Object[indexFV.size() + 1];
                StringBuilder updateIndexSQL = new StringBuilder(64);
                updateIndexSQL.append("/*dialect*/UPDATE ").append(tn.getPKTable()).append(" SET ");
                int n = indexFV.size();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        updateIndexSQL.append(',');
                    }
                    updateIndexSQL.append(((ShardingFieldValue)indexFV.get(i)).getField()).append('=').append('?');
                    ps[i] = ((ShardingFieldValue)indexFV.get(i)).getValues().get(0);
                }
                updateIndexSQL.append(" WHERE FPK=?");
                ps[ps.length - 1] = pkFV.getValues().get(0);
                SQLInfo si = new SQLInfo(updateIndexSQL.toString(), ps, true);
                ret.add(new FinalShardingSQL(si, tn.getPKTable()));
            }
        }
        return ret.toArray(new ShardingSQL[ret.size()]);
    }

    private List<ParamsGroup> mapParamsGroups() {
        SQLInsertStatement stmt = (SQLInsertStatement)this.getStatementInfo().getSQLStatement();
        List columns = stmt.getColumns();
        Object[] params = this.stmtInfo.getSQLInfo().getParams();
        if (columns.size() == 0) {
            throw new IllegalArgumentException(BosRes.get((String)"bos-xdb", (String)"InsertShardingSQL_0", (String)"Insert\u8bed\u53e5\u4e2d\u987b\u6307\u5b9a\u5217:{0} \u3002", (Object[])new Object[]{this.getSQLInfo().getSql()}));
        }
        this.insertFields = new String[columns.size()];
        int i = 0;
        for (SQLExpr column : columns) {
            this.insertFields[i++] = column.toString().toLowerCase();
        }
        if (params.length == 0 || params.length != this.insertFields.length) {
            throw new IllegalArgumentException(BosRes.get((String)"bos-xdb", (String)"InsertShardingSQL_1", (String)"Insert\u53c2\u6570\u4e0d\u6b63\u786e:{0} ", (Object[])new Object[]{this.stmtInfo.getSQLInfo().getSql() + ", " + Arrays.asList(params)}));
        }
        ArrayList<ParamsGroup> maps = new ArrayList<ParamsGroup>(1);
        ParamsGroup group = new ParamsGroup(this.insertFields.length, StatementType.insert, this.stmtInfo.getSQLInfo());
        for (int j = 0; j < this.insertFields.length; ++j) {
            group.add(this.insertFields[j], 0, params[j], j, FilterType.eq, (SQLExpr)columns.get(j), (SQLObject)this.stmtInfo.getTableInfos().get(0).getSQLTableSource());
        }
        maps.add(group);
        return maps;
    }

    @Override
    protected SQLInfo genSQL(ShardingGroupTable group, List<ConditionInfo> allCI, TableInfo shardingSourceTable) {
        String shardingTable = group.getShardingTable();
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ").append(shardingTable).append('(');
        for (String string : this.insertFields) {
            sql.append(string).append(',');
        }
        sql.setCharAt(sql.length() - 1, ')');
        sql.append(" VALUES(");
        for (int i = 0; i < this.insertFields.length; ++i) {
            sql.append("?,");
        }
        sql.setCharAt(sql.length() - 1, ')');
        Object[] params = new Object[this.insertFields.length];
        HashMap<String, Object> valueMap = new HashMap<String, Object>(this.insertFields.length);
        for (ShardingFieldValue shardingFieldValue : group.getFieldValues()) {
            valueMap.put(shardingFieldValue.getField(), shardingFieldValue.getValues().get(0));
        }
        int i = 0;
        for (String field : this.insertFields) {
            params[i++] = valueMap.get(field);
        }
        String string = XDBConfig.getShardingConfigProvider().getMainConfig(TableName.of(group.getShardingTable()).getOriginalName()).getOptions().getIndexRoute().getRoute(group.getShardingTable());
        SQLInfo ret = new SQLInfo(string, sql.toString(), params, true);
        ret.setShardingHintContext(group.getShardingHintContext());
        return ret;
    }

    @Override
    protected boolean isFullShardingValueRequired() {
        return true;
    }

    @Override
    protected ConditionExprList collectConditionExprs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSupportOptimize() {
        return false;
    }
}

