/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.sql.dml;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionOperator;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import kd.bos.bundle.BosRes;
import kd.bos.xdb.XDBLogable;
import kd.bos.xdb.engine.ShardingContext;
import kd.bos.xdb.engine.ShardingResult;
import kd.bos.xdb.engine.StatementShardingEngine;
import kd.bos.xdb.engine.UnionType;
import kd.bos.xdb.engine.spec.SelfShardingSQL;
import kd.bos.xdb.exception.UnsupportedStatementException;
import kd.bos.xdb.merge.feature.MergeFeatureVisitor;
import kd.bos.xdb.merge.feature.SelectFeature;
import kd.bos.xdb.sharding.sql.SQLInfo;
import kd.bos.xdb.sharding.sql.ShardingSQL;
import kd.bos.xdb.sharding.sql.condition.ConditionExprList;
import kd.bos.xdb.sharding.sql.dml.DMLShardingSQL;
import kd.bos.xdb.sharding.sql.dml.UnoinSelects;
import kd.bos.xdb.sharding.sql.parser.ConditionInfo;
import kd.bos.xdb.sharding.sql.parser.SQLParser;
import kd.bos.xdb.sharding.sql.parser.SQLUtil;
import kd.bos.xdb.sharding.sql.parser.StatementInfo;
import kd.bos.xdb.sharding.sql.visitor.ConditionVisitor;
import kd.bos.xdb.util.DevTag;
import kd.bos.xdb.xpm.metrics.action.sharding.spec.UnionSpan;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;

public class SelectShardingSQL
extends DMLShardingSQL
implements SelfShardingSQL,
XDBLogable {
    private final boolean selfSharding;

    public SelectShardingSQL(StatementInfo stmtInfo) {
        super(stmtInfo);
        SQLSelectStatement stmt = (SQLSelectStatement)stmtInfo.getSQLStatement();
        SQLSelectQuery select = stmt.getSelect().getQuery();
        this.selfSharding = select instanceof SQLUnionQuery;
    }

    @Override
    protected boolean isFullShardingValueRequired() {
        return false;
    }

    @Override
    public boolean isSelfSharding() {
        return this.selfSharding;
    }

    @Override
    public ShardingResult sharding(StatementShardingEngine shardingEngine, ShardingContext ctx) {
        if (log.isInfoEnabled()) {
            log.info("\u62c6\u8bed\u53e5\u6267\u884c\u5206\u7247: select...union...");
        }
        SQLSelectStatement stmt = (SQLSelectStatement)this.getStatementInfo().getSQLStatement();
        SQLUnionQuery unionQuery = (SQLUnionQuery)stmt.getSelect().getQuery();
        UnoinSelects selects = new UnoinSelects(unionQuery);
        int parameterPos = 0;
        Object[] params = this.getSQLInfo().getParams();
        ArrayList<StatementInfo> shardingStmtInfos = new ArrayList<StatementInfo>(16);
        List<UnoinSelects.SelectItem> selectItems = selects.getSelects();
        for (UnoinSelects.SelectItem si : selectItems) {
            SQLSelectStatement subStmt = new SQLSelectStatement(new SQLSelect((SQLSelectQuery)si.getQuery()));
            String sql = subStmt.toString();
            Object[] subParams = this.getParameters(sql, params, parameterPos);
            parameterPos += subParams.length;
            shardingStmtInfos.add(new StatementInfo(new SQLInfo(sql, subParams, true), (SQLStatement)subStmt));
        }
        MetricsCollector mc = MetricsCollector.getCurrent();
        if (mc.isActionMetricEnabled()) {
            mc.actionMetric().stat(new UnionSpan(shardingStmtInfos.size()));
        }
        SelectFeature unionRootSelectFeature = mc.sqlFeature().getSelectFeature();
        ShardingResult ret = null;
        UnionType lastUnionType = null;
        boolean allUnionAll = true;
        for (int i = shardingStmtInfos.size() - 1; i >= 0; --i) {
            ShardingResult cur;
            StatementInfo segStmtInfo = (StatementInfo)shardingStmtInfos.get(i);
            MergeFeatureVisitor mfvisitor = new MergeFeatureVisitor((SQLSelectStatement)segStmtInfo.getSQLStatement());
            SelectFeature sf = mfvisitor.getSelectFeature();
            ShardingSQL[] ss = shardingEngine.sharding(segStmtInfo, true);
            SQLInfo[] si = new SQLInfo[ss.length];
            for (int j = 0; j < ss.length; ++j) {
                si[j] = this.toPlainSQLInfo(ss[j].getSQLInfo());
            }
            UnionType unionType = null;
            SQLUnionOperator op = selectItems.get(i).getOP();
            if (op != null) {
                if (op == SQLUnionOperator.UNION) {
                    unionType = UnionType.unoin;
                    if (allUnionAll) {
                        allUnionAll = false;
                    }
                } else if (op == SQLUnionOperator.UNION_ALL) {
                    unionType = UnionType.unoin_all;
                } else {
                    throw new UnsupportedStatementException(BosRes.get((String)"bos-xdb", (String)"SelectShardingSQL_0", (String)"\u4e0d\u652f\u6301\u7684union\u64cd\u4f5c:{0}, SQL={1}", (Object[])new Object[]{op, this.stmtInfo}));
                }
            }
            ret = cur = ShardingResult.shardingResultWithUnion(si, segStmtInfo, lastUnionType, ret, stmt, sf);
            lastUnionType = unionType;
        }
        unionRootSelectFeature.setAllUnionAll(allUnionAll);
        Optional.ofNullable(ret).ifPresent(sr -> sr.setUnionRootSelectFeature(unionRootSelectFeature));
        return ret;
    }

    private SQLInfo toPlainSQLInfo(SQLInfo si) {
        boolean shouldPlain = false;
        for (Object p : si.getParams()) {
            if (p == null || !p.getClass().isArray() || Array.getLength(p) <= 1) continue;
            shouldPlain = true;
            break;
        }
        if (shouldPlain) {
            ConditionExprList ce = new ConditionExprList();
            StatementInfo stmtInfo = SQLParser.parse(si.isShardingSQL(), si.getSql(), si.getParams());
            SQLSelectStatement stmt = (SQLSelectStatement)stmtInfo.getSQLStatement();
            SQLSelectQuery select = stmt.getSelect().getQuery();
            this.collect(select, ce);
            DevTag.expandArrayParameters();
            int fromPos = 0;
            for (SQLExpr exp : ce.getExprList()) {
                ConditionVisitor cv = new ConditionVisitor();
                exp.accept((SQLASTVisitor)cv);
                for (ConditionInfo condition : cv.getConditionInfos()) {
                    SQLExpr conditionExp = condition.getSQLExpr();
                    SQLUtil.expandInOrLike(conditionExp, si.getParams()[fromPos + condition.getPosIndex()]);
                }
                fromPos += cv.getConditionInfos().size();
            }
            SQLInfo ret = new SQLInfo(stmt.toString(), si.getParams(), true);
            ret.setShardingHintContext(si.getShardingHintContext());
            return ret;
        }
        return si;
    }

    private Object[] getParameters(String sql, Object[] params, int fromPos) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (char ch : sql.toCharArray()) {
            if (ch != '?') continue;
            ret.add(params[fromPos++]);
        }
        return ret.toArray();
    }

    private void collect(SQLSelectQuery select, ConditionExprList ce) {
        if (select instanceof SQLSelectQueryBlock) {
            SQLExpr having;
            SQLSelectGroupByClause groupBy;
            SQLSelectQueryBlock block = (SQLSelectQueryBlock)select;
            SQLTableSource from = block.getFrom();
            if (from instanceof SQLSubqueryTableSource) {
                this.collect(((SQLSubqueryTableSource)from).getSelect().getQuery(), ce);
            } else if (from instanceof SQLJoinTableSource) {
                this.collect((SQLJoinTableSource)from, ce);
            }
            SQLExpr where = block.getWhere();
            if (where != null) {
                ce.add(where);
            }
            if ((groupBy = block.getGroupBy()) != null && (having = groupBy.getHaving()) != null) {
                ce.add(having);
            }
        } else if (select instanceof SQLUnionQuery) {
            SQLUnionQuery union = (SQLUnionQuery)select;
            this.collect(union.getLeft(), ce);
            this.collect(union.getRight(), ce);
        } else {
            throw new UnsupportedOperationException(BosRes.get((String)"bos-xdb", (String)"SelectShardingSQL_1", (String)"SELECT\u4e0d\u652f\u6301\u67e5\u8be2\u7c7b\u578b:{0}", (Object[])new Object[]{select}));
        }
    }

    private void collect(SQLJoinTableSource join, ConditionExprList ce) {
        if (join.getLeft() instanceof SQLJoinTableSource) {
            this.collect((SQLJoinTableSource)join.getLeft(), ce);
        }
        if (join.getRight() instanceof SQLJoinTableSource) {
            this.collect((SQLJoinTableSource)join.getRight(), ce);
        }
        ce.add(join.getCondition());
    }

    @Override
    protected ConditionExprList collectConditionExprs() {
        ConditionExprList ce = new ConditionExprList();
        SQLSelectStatement stmt = (SQLSelectStatement)this.getStatementInfo().getSQLStatement();
        SQLSelectQuery select = stmt.getSelect().getQuery();
        this.collect(select, ce);
        return ce;
    }
}

