/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.sql.dml.update;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.exception.XDBErrorCode;
import kd.bos.xdb.Todo;
import kd.bos.xdb.XDB;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBManageContext;
import kd.bos.xdb.cache.CacheContext;
import kd.bos.xdb.cache.executor.temp.MoveShardingDataTempCache;
import kd.bos.xdb.engine.ShardingContext;
import kd.bos.xdb.eventbus.EventBus;
import kd.bos.xdb.eventbus.UpdateClusterCacheNotify;
import kd.bos.xdb.exception.LimitedSQLException;
import kd.bos.xdb.ext.KSQL;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.config.ChildrenTableConfig;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.config.ShardingIndexRoute;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.bos.xdb.sharding.sql.dml.update.ShardingDataMoveCommittedEvent;
import kd.bos.xdb.sharding.sql.dml.update.ShardingDataMoveMeta;
import kd.bos.xdb.sharding.strategy.AbstractShardingStrategy;
import kd.bos.xdb.sharding.strategy.FilterTypeUtil;
import kd.bos.xdb.tablemanager.TableManager;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.transaction.TransactionListener;
import kd.bos.xdb.transaction.XDBTransactionHook;
import kd.bos.xdb.xpm.metrics.action.sharding.data.ShardingDataMoveSpan;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;

final class ShardingDataMover
implements TransactionListener {
    private final MainTableConfig config;
    private final String[] fields;
    private final int N;
    private final ShardingContext ctx;
    private MoveShardingDataTempCache tempCache;
    private List<ShardingDataMoveMeta> dmList = new ArrayList<ShardingDataMoveMeta>();

    ShardingDataMover(MainTableConfig config) {
        this.config = config;
        this.fields = config.getShardingFields();
        this.N = this.fields.length;
        this.ctx = ShardingContext.get();
    }

    boolean moveRow(Object pk, Object[] oldValues, Object[] newValues) throws SQLException {
        long[] newShardingIndexies;
        boolean skipHint;
        boolean sameValues = true;
        for (int i = 0; i < this.N; ++i) {
            if (String.valueOf(oldValues[i]).equals(String.valueOf(newValues[i]))) continue;
            sameValues = false;
            break;
        }
        if (sameValues) {
            return false;
        }
        FilterType[] filterTypes = FilterTypeUtil.getEqFilterTypes(this.N);
        AbstractShardingStrategy ss = (AbstractShardingStrategy)this.config.getShardingStrategy();
        long oldShardingIndex = ss.shardingIndex(filterTypes, oldValues)[0];
        ShardingHintContext shCtx = ShardingHintContext.get();
        boolean bl = skipHint = shCtx != null && !shCtx.isSkipHint();
        if (skipHint) {
            shCtx.setSkipHint(true);
            newShardingIndexies = ss.shardingIndex(filterTypes, newValues);
            shCtx.setSkipHint(false);
        } else {
            newShardingIndexies = ss.shardingIndex(filterTypes, newValues);
        }
        if (newShardingIndexies.length == 1 && oldShardingIndex == newShardingIndexies[0]) {
            return false;
        }
        if (this.tempCache == null) {
            XDBTransactionHook.addTransactionListener(this);
            this.tempCache = CacheContext.get().createTempCache();
        }
        if (newShardingIndexies.length == 0) {
            boolean gen = this.ctx.__getGenShardingIndexWhenSharding();
            this.ctx.setGenShardingIndexWhenSharding(true);
            newShardingIndexies = ss.shardingIndex(filterTypes, newValues);
            this.ctx.setGenShardingIndexWhenSharding(gen);
        }
        long newShardingIndex = newShardingIndexies[0];
        this.doMoveRow(pk, newValues, oldShardingIndex, newShardingIndex);
        ((AbstractShardingStrategy)this.config.getShardingStrategy()).getIndexPKStore().clearParentPk(this.config.getTable(), pk);
        return true;
    }

    private void doMoveRow(Object pk, Object[] newValues, long fromShardingIndex, long toShardingIndex) throws SQLException {
        ShardingDataMoveMeta dm = new ShardingDataMoveMeta(pk, newValues, toShardingIndex);
        this.dmList.add(dm);
        this.moveMainTableRow(dm, this.config, new Object[]{pk}, fromShardingIndex, toShardingIndex);
    }

    private void moveMainTableRow(ShardingDataMoveMeta dm, ShardingConfig config, Object[] pks, long fromShardingIndex, long toShardingIndex) throws SQLException {
        String toRoute;
        ShardingIndexRoute mainIndexRoute = XDBConfig.getShardingConfigProvider().getMainConfig(config.getTable()).getOptions().getIndexRoute();
        String fromRoute = mainIndexRoute.getRoute(fromShardingIndex);
        if (!fromRoute.equalsIgnoreCase(toRoute = mainIndexRoute.getRoute(toShardingIndex))) {
            StringBuilder msg = new StringBuilder(1024);
            msg.append("Can not write more than one database: ").append("move table from ").append(fromRoute).append(" to ").append(toRoute);
            throw new LimitedSQLException(XDBErrorCode.xdbMultiDBWrited, msg.toString());
        }
        TableName tn = TableName.of(config.getTable());
        String fromTable = tn.getShardingTable(fromShardingIndex);
        String toTable = tn.getShardingTable(toShardingIndex);
        String pkField = ((AbstractShardingStrategy)config.getShardingStrategy()).getPKField();
        StringBuilder inSQL = new StringBuilder(pks.length * 2 + 6).append(" in (");
        int n = pks.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                inSQL.append(',');
            }
            inSQL.append('?');
        }
        inSQL.append(')');
        TableManager tm = XDBConfig.getTableManager();
        if (!tm.existTable(toTable)) {
            tm.createShardingTable(tn.getOriginalName(), toShardingIndex);
        }
        Todo.todo("test update pk index");
        StringBuilder sql = new StringBuilder(128 + inSQL.length());
        sql.append("insert into ").append(toTable).append(" select * from ").append(fromTable).append(" where ").append(pkField).append((CharSequence)inSQL);
        this.executeSQL(toRoute, sql.toString(), pks);
        for (ShardingConfig childrenConfig : new ArrayList<ShardingConfig>(config.getChildrenConfigMap().values())) {
            this.moveChildrenRow(toRoute, dm, childrenConfig, pks, fromShardingIndex, toShardingIndex);
        }
        sql.setLength(0);
        sql.append("delete from ").append(fromTable).append(" where ").append(pkField).append((CharSequence)inSQL);
        this.executeSQL(toRoute, sql.toString(), pks);
    }

    private void moveChildrenRow(String dbRoute, ShardingDataMoveMeta dm, ShardingConfig childrenConfig, Object[] joinFieldValues, long fromShardingIndex, long toShardingIndex) throws SQLException {
        Object[] childrenPKS;
        TableName childrenTN = TableName.of(childrenConfig.getTable());
        String fromChildrenTable = childrenTN.getShardingTable(fromShardingIndex);
        String toChildrenTable = childrenTN.getShardingTable(toShardingIndex);
        String childrenPKField = ((ChildrenTableConfig)childrenConfig).getPKField();
        String childrenJoinField = ((ChildrenTableConfig)childrenConfig).getJoinField();
        TableManager tm = XDBConfig.getTableManager();
        if (!tm.existTable(fromChildrenTable)) {
            return;
        }
        if (!tm.existTable(toChildrenTable)) {
            tm.createShardingTable(childrenTN.getOriginalName(), toShardingIndex);
        }
        StringBuilder inSQL = new StringBuilder(joinFieldValues.length * 2 + 6).append(" in (");
        int n = joinFieldValues.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                inSQL.append(',');
            }
            inSQL.append('?');
        }
        inSQL.append(')');
        StringBuilder sql = new StringBuilder(128 + inSQL.length());
        sql.append("insert into ").append(toChildrenTable).append(" select * from ").append(fromChildrenTable).append(" where ").append(childrenJoinField).append((CharSequence)inSQL);
        this.executeSQL(dbRoute, sql.toString(), joinFieldValues);
        if (childrenPKField.equals(childrenJoinField)) {
            childrenPKS = joinFieldValues;
        } else {
            sql.setLength(0);
            sql.append("select ").append(childrenPKField).append(" from ").append(fromChildrenTable).append(" where ").append(childrenJoinField).append((CharSequence)inSQL);
            childrenPKS = this.queryPKS(dbRoute, sql.toString(), joinFieldValues).toArray();
        }
        if (childrenPKS.length > 0) {
            dm.getChildTablePKMap().put(childrenConfig.getTable(), childrenPKS);
            if (!childrenConfig.getChildrenConfigMap().isEmpty()) {
                for (ShardingConfig subConfig : new ArrayList<ShardingConfig>(childrenConfig.getChildrenConfigMap().values())) {
                    this.moveChildrenRow(dbRoute, dm, subConfig, childrenPKS, fromShardingIndex, toShardingIndex);
                }
            }
        }
        sql.setLength(0);
        sql.append("delete from ").append(fromChildrenTable).append(" where ").append(childrenJoinField).append((CharSequence)inSQL);
        this.executeSQL(dbRoute, sql.toString(), joinFieldValues);
    }

    private void executeSQL(String dbRoute, String sql, Object[] params) throws SQLException {
        sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(sql));
        try (XDBManageContext xm = XDB.get().withManageContext();){
            xm.setRoute(dbRoute);
            XDB.get().execute(sql, params);
        }
    }

    private List<Object> queryPKS(String dbRoute, String sql, Object[] params) throws SQLException {
        sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(sql));
        ArrayList<Object> ret = new ArrayList<Object>();
        try (XDBManageContext xm = XDB.get().withManageContext();){
            xm.setRoute(dbRoute);
            try (ResultSet rs = XDB.get().query(sql, params);){
                while (rs.next()) {
                    ret.add(rs.getObject(1));
                }
            }
        }
        return ret;
    }

    void onShardingDataMoved() {
        this.config.getShardingStrategy().onShardingDataMoved(this.dmList);
        HashSet<Long> toIndexSet = new HashSet<Long>(this.dmList.size());
        for (ShardingDataMoveMeta dm : this.dmList) {
            toIndexSet.add(dm.getToShardingIndex());
        }
        this.ctx.setUpdateShardingFieldToNewTables(toIndexSet);
    }

    @Override
    public void onBeforeEnd(boolean rollbacked) {
        try {
            this.tempCache.setRollbacked(rollbacked);
            this.tempCache.close();
            if (!rollbacked) {
                MetricsCollector mc;
                if (this.dmList.size() > 0) {
                    this.config.getShardingStrategy().onShardingDataMoveCommitted(this.dmList, false);
                    ((AbstractShardingStrategy)this.config.getShardingStrategy()).getIndexPKStore().incVersion();
                    EventBus.publish(new ShardingDataMoveCommittedEvent(this.config.getTable(), this.dmList));
                    XDBConfig.get();
                    if (!XDBConfig.isNotifyCacheNumberIgnore(this.config.getEntitynumber())) {
                        UpdateClusterCacheNotify.notify(new ShardingDataMoveCommittedEvent(this.config.getTable(), this.dmList));
                    }
                }
                if ((mc = MetricsCollector.getCurrent()).isActionMetricEnabled()) {
                    mc.actionMetric().stat(new ShardingDataMoveSpan(this.dmList));
                }
            }
        }
        finally {
            XDBTransactionHook.removeTransactionListener(this);
            this.dmList.clear();
        }
    }
}

