/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.sql.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import kd.bos.bundle.BosRes;
import kd.bos.xdb.sharding.sql.FilterType;

public class ConditionInfo {
    private SQLExpr expr;
    private int posIndex;
    private SQLObject owner;
    private String field;
    private FilterType filterType;

    public ConditionInfo(SQLExpr expr, int posIndex) {
        this.expr = expr;
        this.posIndex = posIndex;
        this.init();
    }

    private void init() {
        this.owner = this.parseOwner();
        this.field = this.parseField();
        this.filterType = this.parseFilterType();
    }

    public SQLObject getOwner() {
        return this.owner;
    }

    public SQLExpr getSQLExpr() {
        return this.expr;
    }

    public int getPosIndex() {
        return this.posIndex;
    }

    public String toString() {
        return this.expr.toString();
    }

    public String getField() {
        return this.field;
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    private SQLObject parseOwner() {
        SQLExpr fieldExpr = this.getFieldPrimaryExpr();
        if (fieldExpr instanceof SQLIdentifierExpr) {
            SQLObject owner = ((SQLIdentifierExpr)fieldExpr).getResolvedOwnerObject();
            if (owner == null) {
                throw new UnsupportedOperationException(BosRes.get((String)"bos-xdb", (String)"ConditionInfo_0", (String)"\u5b57\u6bb5{0}\u9700\u8981\u6307\u5b9a\u8868\u540d:{1}", (Object[])new Object[]{fieldExpr, this.expr}));
            }
            return owner;
        }
        if (fieldExpr instanceof SQLPropertyExpr) {
            SQLPropertyExpr propertyExpr = (SQLPropertyExpr)fieldExpr;
            return propertyExpr.getResolvedOwnerObject();
        }
        if (fieldExpr instanceof SQLAggregateExpr) {
            throw new UnsupportedOperationException(BosRes.get((String)"bos-xdb", (String)"ConditionInfo_2", (String)"\u5206\u7247\u4e0d\u652f\u6301having\u6761\u4ef6:{0} ", (Object[])new Object[]{this.expr}));
        }
        if (fieldExpr instanceof SQLVariantRefExpr) {
            return null;
        }
        if (fieldExpr instanceof SQLCaseExpr) {
            return null;
        }
        if (fieldExpr instanceof SQLBinaryOpExpr) {
            return null;
        }
        if (fieldExpr instanceof SQLMethodInvokeExpr) {
            return null;
        }
        throw new UnsupportedOperationException(BosRes.get((String)"bos-xdb", (String)"ConditionInfo_3", (String)"\u987b\u589e\u52a0parseOwner\u7684\u89e3\u6790:{0} ", (Object[])new Object[]{fieldExpr.getClass()}));
    }

    private String parseField() {
        SQLExpr fieldExpr = this.getFieldPrimaryExpr();
        if (fieldExpr instanceof SQLIdentifierExpr) {
            return ((SQLIdentifierExpr)fieldExpr).getName();
        }
        if (fieldExpr instanceof SQLPropertyExpr) {
            SQLPropertyExpr propertyExpr = (SQLPropertyExpr)fieldExpr;
            return propertyExpr.getName();
        }
        if (fieldExpr instanceof SQLVariantRefExpr) {
            return String.valueOf(fieldExpr);
        }
        if (fieldExpr instanceof SQLCaseExpr) {
            return "";
        }
        if (fieldExpr instanceof SQLBinaryOpExpr) {
            return "";
        }
        if (fieldExpr instanceof SQLMethodInvokeExpr) {
            return "";
        }
        throw new UnsupportedOperationException(BosRes.get((String)"bos-xdb", (String)"ConditionInfo_4", (String)"\u987b\u589e\u52a0parseField\u7684\u89e3\u6790:{0} ", (Object[])new Object[]{fieldExpr.getClass()}));
    }

    private SQLExpr getFieldPrimaryExpr() {
        SQLExpr fieldExpr;
        if (this.expr instanceof SQLInListExpr) {
            fieldExpr = ((SQLInListExpr)this.expr).getExpr();
        } else if (this.expr instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr op = (SQLBinaryOpExpr)this.expr;
            fieldExpr = op.getLeft();
        } else if (this.expr instanceof SQLIdentifierExpr) {
            fieldExpr = (SQLIdentifierExpr)this.expr;
        } else if (this.expr instanceof SQLBetweenExpr) {
            fieldExpr = ((SQLBetweenExpr)this.expr).testExpr;
        } else {
            if (this.expr instanceof SQLMethodInvokeExpr && ("UDT_INTTABLE(?)".equals(this.expr.toString().toUpperCase()) || "UDT_VARCHARTABLE(?)".equals(this.expr.toString().toUpperCase()) || "UDT_NVARCHARTABLE(?)".equals(this.expr.toString().toUpperCase()))) {
                SQLObject parent;
                for (parent = this.expr.getParent(); parent != null && !(parent instanceof SQLInSubQueryExpr); parent = parent.getParent()) {
                }
                if (parent == null) {
                    throw new UnsupportedOperationException("Cant not found parameter's sharding field owner: " + this.expr);
                }
                return ((SQLInSubQueryExpr)parent).getExpr();
            }
            throw new UnsupportedOperationException(BosRes.get((String)"bos-xdb", (String)"ConditionInfo_4", (String)"\u987b\u589e\u52a0parseField\u7684\u89e3\u6790:{0}", (Object[])new Object[]{this.expr.getClass()}));
        }
        return fieldExpr;
    }

    private FilterType parseFilterType() {
        if (this.expr instanceof SQLInListExpr) {
            if (((SQLInListExpr)this.expr).isNot()) {
                return FilterType.not_in_range;
            }
            return FilterType.in_range;
        }
        if (this.expr instanceof SQLBinaryOpExpr) {
            SQLBinaryOperator op = ((SQLBinaryOpExpr)this.expr).getOperator();
            if (op == SQLBinaryOperator.Equality) {
                return FilterType.eq;
            }
            if (op == SQLBinaryOperator.NotEqual || op == SQLBinaryOperator.LessThanOrGreater) {
                return FilterType.not_eq;
            }
            if (op == SQLBinaryOperator.GreaterThan) {
                return FilterType.gt;
            }
            if (op == SQLBinaryOperator.GreaterThanOrEqual) {
                return FilterType.ge;
            }
            if (op == SQLBinaryOperator.LessThan) {
                return FilterType.lt;
            }
            if (op == SQLBinaryOperator.LessThanOrEqual) {
                return FilterType.le;
            }
            if (op == SQLBinaryOperator.Like || op == SQLBinaryOperator.ILike) {
                return FilterType.like;
            }
            if (op == SQLBinaryOperator.NotLike) {
                return FilterType.not_like;
            }
            return FilterType.other;
        }
        if (this.expr instanceof SQLBetweenExpr) {
            if (((SQLBetweenExpr)this.expr).isNot()) {
                return FilterType.not_between_and;
            }
            return FilterType.between_and;
        }
        if (this.expr instanceof SQLMethodInvokeExpr && ("UDT_INTTABLE(?)".equals(this.expr.toString().toUpperCase()) || "UDT_VARCHARTABLE(?)".equals(this.expr.toString().toUpperCase()) || "UDT_NVARCHARTABLE(?)".equals(this.expr.toString().toUpperCase()))) {
            SQLObject parent;
            for (parent = this.expr.getParent(); parent != null && !(parent instanceof SQLInSubQueryExpr); parent = parent.getParent()) {
            }
            if (parent == null) {
                throw new UnsupportedOperationException("Cant not found parameter's sharding field owner: " + this.expr);
            }
            return ((SQLInSubQueryExpr)parent).isNot() ? FilterType.not_in_range : FilterType.in_range;
        }
        throw new UnsupportedOperationException(BosRes.get((String)"bos-xdb", (String)"ConditionInfo_5", (String)"\u987b\u589e\u52a0parseFilterType\u7684\u5224\u65ad:{0}", (Object[])new Object[]{this.expr.getClass()}));
    }
}

