/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.sql.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.repository.SchemaRepository;
import com.alibaba.druid.sql.repository.SchemaResolveVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.List;
import kd.bos.bundle.BosRes;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.datasource.ConnectionProvider;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.exception.UnsupportedStatementException;
import kd.bos.xdb.sharding.sql.SQLInfo;
import kd.bos.xdb.sharding.sql.parser.ExtractParameterPosition;
import kd.bos.xdb.sharding.sql.parser.SQLExtractParameterVisitor;
import kd.bos.xdb.sharding.sql.parser.SQLMergeParameterVisitor;
import kd.bos.xdb.sharding.sql.parser.StatementInfo;
import kd.bos.xdb.util.Ternary;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;

public class SQLParser {
    private static final boolean KEEP_COMMENTS = false;

    public static StatementInfo parse(boolean isShardingSQL, String sql, Object ... params) {
        StatementInfo stmtInfo = SQLParser.parse1_stmtInfo(isShardingSQL, sql, params);
        return SQLParser.parse3_resolveObject(stmtInfo.getSQLStatement(), stmtInfo.getSQLInfo());
    }

    public static StatementInfo parse(SQLInfo shardedSQLInfo) {
        StatementInfo stmtInfo = SQLParser.parse1_stmtInfo(shardedSQLInfo.getDbRoute(), shardedSQLInfo.isShardingSQL(), shardedSQLInfo.getSql(), shardedSQLInfo.getParams());
        return SQLParser.parse3_resolveObject(stmtInfo.getSQLStatement(), stmtInfo.getSQLInfo());
    }

    public static SQLStatement parse1_stmt(String sql) {
        String dbType = XDBConfig.get().isUseKSQL() ? DBType.mysql.getId() : ConnectionProvider.get().getConnectionHolder().getDBType().getId();
        List stmts = SQLUtils.parseStatements((String)sql, (DbType)DbType.valueOf((String)dbType), (boolean)false);
        MetricsCollector mc = MetricsCollector.getCurrent();
        if (mc.isActionMetricEnabled()) {
            mc.actionMetric().incParseSQLTimes();
        }
        if (stmts.size() != 1) {
            throw new UnsupportedStatementException(BosRes.get((String)"bos-xdb", (String)"SQLParser_1", (String)"\u5206\u7247\u4ec5\u652f\u6301\u6267\u884c\u5355\u6761\u8bed\u53e5:{0}", (Object[])new Object[]{sql}));
        }
        return (SQLStatement)stmts.get(0);
    }

    public static StatementInfo parse1_stmtInfo(boolean isShardingSQL, String sql, Object ... params) {
        return new StatementInfo(new SQLInfo(sql, params, isShardingSQL), SQLParser.parse1_stmt(sql));
    }

    public static StatementInfo parse1_stmtInfo(String dbRoute, boolean isShardingSQL, String sql, Object ... params) {
        return new StatementInfo(new SQLInfo(dbRoute, sql, params, isShardingSQL), SQLParser.parse1_stmt(sql));
    }

    public static Ternary<SQLStatement, SQLInfo, Boolean> parse2_extractParameter(ExtractParameterPosition ep, SQLStatement stmt, String sql, Object ... params) {
        boolean parameterChanged = false;
        SQLExtractParameterVisitor extractor = new SQLExtractParameterVisitor(params, ep);
        stmt.accept((SQLASTVisitor)((Object)extractor));
        MetricsCollector mc = MetricsCollector.getCurrent();
        boolean actionMetricEnabled = mc.isActionMetricEnabled();
        if (actionMetricEnabled) {
            mc.actionMetric().incParseSQLExtractParameterTimes();
            mc.actionMetric().incParseSQLExtractNewParameterCount(extractor.getExtractNewParameterCount());
        }
        SQLInfo sqlInfo = extractor.getSQLInfo();
        if (extractor.isExtractNewParameter()) {
            parameterChanged = true;
            stmt = (SQLStatement)SQLUtils.parseStatements((String)sqlInfo.getSql(), (DbType)stmt.getDbType(), (boolean)false).get(0);
            params = sqlInfo.getParams();
            if (actionMetricEnabled) {
                mc.actionMetric().incParseSQLTimes();
            }
        }
        SQLMergeParameterVisitor merger = new SQLMergeParameterVisitor(params);
        stmt.accept((SQLASTVisitor)((Object)merger));
        if (actionMetricEnabled) {
            mc.actionMetric().incParseSQLExtractParameterTimes();
            mc.actionMetric().incParseSQLExtractNewParameterCount(merger.getExtractNewParameterCount());
        }
        sqlInfo = merger.getSQLInfo();
        if (merger.isExtractNewParameter()) {
            parameterChanged = true;
            stmt = (SQLStatement)SQLUtils.parseStatements((String)sqlInfo.getSql(), (DbType)stmt.getDbType(), (boolean)false).get(0);
            params = sqlInfo.getParams();
            if (actionMetricEnabled) {
                mc.actionMetric().incParseSQLTimes();
            }
        }
        return new Ternary<SQLStatement, SQLInfo, Boolean>(stmt, sqlInfo, parameterChanged);
    }

    public static StatementInfo parse3_resolveObject(SQLStatement stmt, SQLInfo sqlInfo) {
        if (stmt instanceof SQLDeleteStatement) {
            SQLParser.replaceDeleteAliasAsFromTable((SQLDeleteStatement)stmt);
        }
        SchemaRepository repository = new SchemaRepository(stmt.getDbType());
        repository.resolve(stmt, new SchemaResolveVisitor.Option[0]);
        return new StatementInfo(sqlInfo, stmt);
    }

    private static void replaceDeleteAliasAsFromTable(SQLDeleteStatement stmt) {
        if (stmt.getFrom() == null) {
            return;
        }
        SQLTableSource deleteAliasTable = stmt.getTableSource();
        String deleteAlias = deleteAliasTable.toString();
        SQLTableSource realDeleteTable = stmt.getFrom().findTableSource(deleteAlias);
        if (realDeleteTable == null) {
            throw new IllegalArgumentException(BosRes.get((String)"bos-xdb", (String)"SQLParser_2", (String)"delete\u8bed\u53e5\u8bed\u6cd5\u9519\u8bef\uff0cfrom\u4e2d\u672a\u627e\u5230\u5220\u9664\u7684\u8868{0}:{1}", (Object[])new Object[]{deleteAliasTable, stmt}));
        }
        stmt.setTableSource(realDeleteTable);
    }
}

