/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.sql.parser;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLExistsExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.statement.KSQLIfExistsStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCommentStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLDDLStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLEXECStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLTruncateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;
import kd.bos.bundle.BosRes;
import kd.bos.xdb.exception.UnsupportedStatementException;
import kd.bos.xdb.sharding.sql.SQLInfo;
import kd.bos.xdb.sharding.sql.ShardingSQL;
import kd.bos.xdb.sharding.sql.StatementType;
import kd.bos.xdb.sharding.sql.ddl.AlterTableShardingSQL;
import kd.bos.xdb.sharding.sql.ddl.CommentShardingSQL;
import kd.bos.xdb.sharding.sql.ddl.CreateIndexShardingSQL;
import kd.bos.xdb.sharding.sql.ddl.CreateTableShardingSQL;
import kd.bos.xdb.sharding.sql.ddl.DropIndexShardingSQL;
import kd.bos.xdb.sharding.sql.ddl.DropTableShardingSQL;
import kd.bos.xdb.sharding.sql.dml.DeleteShardingSQL;
import kd.bos.xdb.sharding.sql.dml.ExecShardingSQL;
import kd.bos.xdb.sharding.sql.dml.IfExistsShardingSQL;
import kd.bos.xdb.sharding.sql.dml.InsertShardingSQL;
import kd.bos.xdb.sharding.sql.dml.SelectShardingSQL;
import kd.bos.xdb.sharding.sql.dml.TruncateTableShardingSQL;
import kd.bos.xdb.sharding.sql.dml.UpdateShardingSQL;
import kd.bos.xdb.sharding.sql.parser.TableInfo;
import kd.bos.xdb.sharding.sql.visitor.MySqlExistsVisitor;
import kd.bos.xdb.sharding.sql.visitor.MySqlJoinTableVisitor;
import kd.bos.xdb.sharding.sql.visitor.TableVisitor;

public class StatementInfo {
    private final SQLInfo sqlInfo;
    private final SQLStatement stmt;
    private List<TableInfo> tableInfos = new ArrayList<TableInfo>();
    private List<SQLJoinTableSource> joinTableInfos = new ArrayList<SQLJoinTableSource>();
    private List<SQLExistsExpr> existsExprs = new ArrayList<SQLExistsExpr>();
    private StatementType statementType;

    public StatementInfo(SQLInfo sqlInfo, SQLStatement stmt) {
        this.sqlInfo = sqlInfo;
        this.stmt = stmt;
        this.refreshTableInfo();
        this.init();
    }

    public void refreshTableInfo() {
        this.tableInfos.clear();
        TableVisitor tv = TableVisitor.create();
        this.stmt.accept((SQLASTVisitor)tv);
        int pos = 0;
        for (SQLExprTableSource exp : tv.getTableSources()) {
            if (exp.getExpr() instanceof SQLMethodInvokeExpr && ("UDT_INTTABLE(?)".equals(exp.getExpr().toString().toUpperCase()) || "UDT_VARCHARTABLE(?)".equals(exp.getExpr().toString().toUpperCase()) || "UDT_NVARCHARTABLE(?)".equals(exp.getExpr().toString().toUpperCase())) || exp.getTableName() == null) continue;
            this.tableInfos.add(new TableInfo(exp, pos++));
        }
        MySqlJoinTableVisitor jtv = new MySqlJoinTableVisitor();
        this.stmt.accept((SQLASTVisitor)((Object)jtv));
        this.joinTableInfos.addAll(jtv.getJoinTableSources());
        MySqlExistsVisitor ev = new MySqlExistsVisitor();
        this.stmt.accept((SQLASTVisitor)((Object)ev));
        this.existsExprs.addAll(ev.getExistList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init() {
        if (this.isDDL()) {
            if (this.stmt instanceof SQLDropTableStatement) {
                this.statementType = StatementType.drop_table;
                return;
            } else if (this.stmt instanceof SQLCreateTableStatement) {
                this.statementType = StatementType.create_table;
                return;
            } else if (this.stmt instanceof SQLAlterTableStatement) {
                this.statementType = StatementType.alter_table;
                return;
            } else if (this.stmt instanceof SQLCreateIndexStatement) {
                this.statementType = StatementType.create_index;
                return;
            } else if (this.stmt instanceof SQLDropIndexStatement) {
                this.statementType = StatementType.drop_index;
                return;
            } else {
                if (!(this.stmt instanceof SQLCommentStatement)) throw new UnsupportedStatementException(BosRes.get((String)"bos-xdb", (String)"StatementInfo_0", (String)"\u8bed\u53e5\u4e0d\u652f\u6301\u5206\u7247\u529f\u80fd:{0}", (Object[])new Object[]{this.sqlInfo}));
                this.statementType = StatementType.comment;
            }
            return;
        } else if (this.stmt instanceof SQLSelectStatement) {
            this.statementType = StatementType.select;
            return;
        } else if (this.stmt instanceof SQLUpdateStatement) {
            this.statementType = StatementType.update;
            return;
        } else if (this.stmt instanceof SQLDeleteStatement) {
            this.statementType = StatementType.delete;
            return;
        } else if (this.stmt instanceof SQLInsertStatement) {
            this.statementType = StatementType.insert;
            return;
        } else if (this.stmt instanceof KSQLIfExistsStatement) {
            this.statementType = StatementType.if_exists;
            return;
        } else if (this.stmt instanceof SQLEXECStatement) {
            this.statementType = StatementType.exec;
            return;
        } else {
            if (!(this.stmt instanceof SQLTruncateStatement)) throw new UnsupportedStatementException(BosRes.get((String)"bos-xdb", (String)"StatementInfo_0", (String)"\u8bed\u53e5\u4e0d\u652f\u6301\u5206\u7247\u529f\u80fd:{0}", (Object[])new Object[]{this.sqlInfo}));
            this.statementType = StatementType.truncate;
        }
    }

    public ShardingSQL shardingSQL() {
        switch (this.statementType) {
            case select: {
                return new SelectShardingSQL(this);
            }
            case insert: {
                return new InsertShardingSQL(this);
            }
            case update: {
                return new UpdateShardingSQL(this);
            }
            case delete: {
                return new DeleteShardingSQL(this);
            }
            case create_table: {
                return new CreateTableShardingSQL(this);
            }
            case alter_table: {
                return new AlterTableShardingSQL(this);
            }
            case drop_table: {
                return new DropTableShardingSQL(this);
            }
            case create_index: {
                return new CreateIndexShardingSQL(this);
            }
            case drop_index: {
                return new DropIndexShardingSQL(this);
            }
            case if_exists: {
                return new IfExistsShardingSQL(this);
            }
            case exec: {
                return new ExecShardingSQL(this);
            }
            case truncate: {
                return new TruncateTableShardingSQL(this);
            }
            case comment: {
                return new CommentShardingSQL(this);
            }
        }
        throw new UnsupportedStatementException(BosRes.get((String)"bos-xdb", (String)"StatementInfo_0", (String)"\u8bed\u53e5\u4e0d\u652f\u6301\u5206\u7247\u529f\u80fd:{0}", (Object[])new Object[]{this.sqlInfo}));
    }

    public SQLStatement getSQLStatement() {
        return this.stmt;
    }

    public boolean isDDL() {
        return this.stmt instanceof SQLDDLStatement || this.stmt instanceof SQLCommentStatement;
    }

    public boolean isCreate() {
        return this.stmt instanceof SQLCreateStatement;
    }

    public boolean isDelete() {
        return this.stmt instanceof SQLDeleteStatement;
    }

    public List<TableInfo> getTableInfos() {
        return this.tableInfos;
    }

    public List<SQLJoinTableSource> getJoinTableInfos() {
        return this.joinTableInfos;
    }

    public List<SQLExistsExpr> getExistsExprs() {
        return this.existsExprs;
    }

    public SQLInfo getSQLInfo() {
        return this.sqlInfo;
    }

    public StatementType getStatementType() {
        return this.statementType;
    }

    public String toString() {
        return this.sqlInfo.toString();
    }
}

