/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.strategy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.xdb.ext.SelfSetParameter;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.bos.xdb.sharding.sql.ParamsGroup;
import kd.bos.xdb.sharding.strategy.ShardingAlgorithms;
import kd.bos.xdb.sharding.strategy.ShardingKeyGather;
import kd.bos.xdb.sharding.strategy.ShardingStrategy;
import kd.bos.xdb.sharding.strategy.SupportBetweenAndSharding;

public class ShardingParamsCombiner {
    private List<ParamsGroup.ParameterKey> posKeys;
    private ParamsGroup pg;
    private String[] shardingFields;

    public ShardingParamsCombiner(List<ParamsGroup.ParameterKey> posKeys, ParamsGroup pg, String[] shardingFields) {
        this.pg = pg;
        this.shardingFields = shardingFields;
        this.posKeys = new ArrayList<ParamsGroup.ParameterKey>(posKeys);
        Collections.sort(this.posKeys, new Comparator<ParamsGroup.ParameterKey>(){

            @Override
            public int compare(ParamsGroup.ParameterKey o1, ParamsGroup.ParameterKey o2) {
                return o1.posIndex - o2.posIndex;
            }
        });
    }

    public Map<Long, List<ShardingParameter>> combineShardingParams(ShardingKeyGather g, ShardingStrategy shardingStrategy) {
        HashMap shardingParamsMap = new HashMap();
        boolean supportBetweenAnd = shardingStrategy.getConfig().getShardingFields().length == 1 && shardingStrategy instanceof SupportBetweenAndSharding;
        ArrayList<ParamsGroup.ParameterKey[]> keyGroups = new ArrayList<ParamsGroup.ParameterKey[]>();
        this.trySelect(new ParamsGroup.ParameterKey[this.shardingFields.length], 0, keyGroups);
        int groupSize = keyGroups.size();
        boolean betweenAnd = false;
        for (int i = 0; i < groupSize; ++i) {
            FilterType filterType;
            ParamsGroup.ParameterKey[] keyGroup = (ParamsGroup.ParameterKey[])keyGroups.get(i);
            Object[][] datas = new Object[keyGroup.length][];
            for (int j = 0; j < datas.length; ++j) {
                List<Object> values = this.pg.get(keyGroup[j]);
                datas[j] = values.toArray();
                int m = values.size();
                for (int k = 0; k < m; ++k) {
                    if (!(datas[j][k] instanceof SelfSetParameter)) continue;
                    datas[j][k] = ((SelfSetParameter)datas[j][k]).getValue();
                }
            }
            if (supportBetweenAnd && (FilterType.between_and == (filterType = keyGroup[0].getFilterType()) || FilterType.not_between_and == filterType)) {
                long[] indexies;
                betweenAnd = true;
                ParamsGroup.ParameterKey[] betweenKeyGroup = keyGroup;
                Object v1 = this.pg.get(betweenKeyGroup[0]).get(0);
                Object v2 = null;
                int andPos = betweenKeyGroup[0].posIndex + 1;
                for (ParamsGroup.ParameterKey parameterKey : this.pg.keys()) {
                    if (andPos != parameterKey.posIndex) continue;
                    v2 = this.pg.get(parameterKey).get(0);
                    break;
                }
                ++i;
                long[] lArray = indexies = ((SupportBetweenAndSharding)((Object)shardingStrategy)).shardingIndexBetweenAnd(v1, v2, FilterType.not_between_and == filterType);
                int n = lArray.length;
                for (int j = 0; j < n; ++j) {
                    long index = lArray[j];
                    ArrayList<ShardingParameter> paramGroup = (ArrayList<ShardingParameter>)shardingParamsMap.get(index);
                    if (paramGroup == null) {
                        paramGroup = new ArrayList<ShardingParameter>();
                        shardingParamsMap.put(index, paramGroup);
                    }
                    ArrayList<Object[]> vs = new ArrayList<Object[]>(1);
                    vs.add(new Object[]{v1, v2});
                    ShardingParameter sp = new ShardingParameter(betweenKeyGroup, vs);
                    paramGroup.add(sp);
                }
                continue;
            }
            FilterType[] fts = new FilterType[keyGroup.length];
            for (int j = 0; j < keyGroup.length; ++j) {
                fts[j] = keyGroup[j].getFilterType();
            }
            Map<Long, List<Object[]>> curShardingParamsMap = ShardingAlgorithms.descartes(shardingStrategy, g, fts, datas);
            for (Map.Entry<Long, List<Object[]>> entry : curShardingParamsMap.entrySet()) {
                Long index = entry.getKey();
                ArrayList<ShardingParameter> paramGroup = (ArrayList<ShardingParameter>)shardingParamsMap.get(index);
                if (paramGroup == null) {
                    paramGroup = new ArrayList<ShardingParameter>();
                    shardingParamsMap.put(index, paramGroup);
                }
                ShardingParameter shardingParameter = new ShardingParameter(keyGroup, entry.getValue());
                paramGroup.add(shardingParameter);
            }
        }
        HashMap<Long, List<ShardingParameter>> ret = new HashMap<Long, List<ShardingParameter>>(shardingParamsMap.size());
        Iterator iterator = shardingParamsMap.entrySet().iterator();
        HashSet<String> countSet = new HashSet<String>();
        int withShardingTableParameterSize = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            for (ShardingParameter pg : (List)entry.getValue()) {
                StringBuilder filterKey = new StringBuilder(64);
                for (ParamsGroup.ParameterKey pkey : pg.keys) {
                    filterKey.append(pkey.posIndex).append(pkey.field).append('#');
                }
                if (!countSet.add(filterKey.toString())) continue;
                ++withShardingTableParameterSize;
                if (!betweenAnd || pg.keys[0].getFilterType() != FilterType.between_and && pg.keys[0].getFilterType() != FilterType.not_between_and) continue;
                ++withShardingTableParameterSize;
            }
        }
        if (withShardingTableParameterSize == groupSize) {
            for (Map.Entry entry : shardingParamsMap.entrySet()) {
                ret.put((Long)entry.getKey(), (List<ShardingParameter>)entry.getValue());
            }
        }
        return ret;
    }

    private void trySelect(ParamsGroup.ParameterKey[] selected, int selectIndex, List<ParamsGroup.ParameterKey[]> ret) {
        String shardingField = this.shardingFields[selectIndex];
        int n = this.posKeys.size();
        for (int i = 0; i < n; ++i) {
            ParamsGroup.ParameterKey pk = this.posKeys.get(i);
            if (!shardingField.equals(pk.field)) continue;
            selected[selectIndex] = pk;
            if (selectIndex == this.shardingFields.length - 1) {
                ParamsGroup.ParameterKey[] ps = new ParamsGroup.ParameterKey[selected.length];
                System.arraycopy(selected, 0, ps, 0, ps.length);
                ret.add(ps);
                continue;
            }
            this.trySelect(selected, selectIndex + 1, ret);
        }
    }

    static class ShardingParameter {
        private ParamsGroup.ParameterKey[] keys;
        private List<Object[]> values;

        private ShardingParameter(ParamsGroup.ParameterKey[] keys, List<Object[]> values) {
            this.keys = keys;
            this.values = values;
        }

        ParamsGroup.ParameterKey[] keys() {
            return this.keys;
        }

        Object[] getValue(int pos) {
            HashSet<Object> ret = new HashSet<Object>(this.values.size());
            for (Object[] vs : this.values) {
                ret.add(vs[pos]);
            }
            return ret.toArray();
        }
    }
}

