/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.strategy.cache;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kd.bos.util.DisCardUtil;
import kd.bos.xdb.XDBLogable;
import kd.bos.xdb.eventbus.EventBus;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.sharding.strategy.cache.ClearShardingStrategyCacheAckEvent;
import kd.bos.xdb.sharding.strategy.cache.ClearShardingStrategyCacheAckEventHandler;
import kd.bos.xdb.sharding.strategy.cache.ClearShardingStrategyCacheEvent;
import kd.bos.xdb.sharding.strategy.cache.ClearShardingStrategyCacheEventHandler;
import kd.bos.xdb.util.LRUCacheMap;

public final class ShardingStrategyCacheCleaner
implements XDBLogable {
    private static final Map<Long, CountDownLatch> eventAckMap = Collections.synchronizedMap(new LRUCacheMap(100));
    private static final Map<Long, List<String>> unAckNode = Collections.synchronizedMap(new LRUCacheMap(100));
    static final String channel = "xdb-strategy-cache";

    public static void initEventBus() {
        EventBus.subscribe(channel, ClearShardingStrategyCacheEvent.class, new ClearShardingStrategyCacheEventHandler());
        EventBus.subscribe(channel, ClearShardingStrategyCacheAckEvent.class, new ClearShardingStrategyCacheAckEventHandler());
        EventBus.startService(channel);
    }

    public static boolean clearStrategyCache(String oneOfGroupTable) {
        oneOfGroupTable = oneOfGroupTable.toLowerCase();
        ClearShardingStrategyCacheEventHandler.clearCache(oneOfGroupTable);
        ClearShardingStrategyCacheEvent event = new ClearShardingStrategyCacheEvent(oneOfGroupTable);
        List<String> instances = ShardingStrategyCacheCleaner.getInstances();
        instances.remove(event.getInstanceId());
        int notifyCount = instances.size();
        CountDownLatch cd = new CountDownLatch(notifyCount);
        eventAckMap.put(event.getId(), cd);
        unAckNode.put(event.getId(), instances);
        EventBus.publish(channel, event);
        try {
            cd.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            DisCardUtil.discard();
        }
        log.info("Clear strategy cache instances(" + ((long)notifyCount - cd.getCount()) / (long)notifyCount + "): " + instances);
        return cd.getCount() == 0L;
    }

    public static void ackClearStrategyCache(long ackId, String instanceId) {
        CountDownLatch cd;
        List<String> instances = unAckNode.get(ackId);
        if (instances != null && !instances.isEmpty()) {
            instances.remove(instanceId);
        }
        if ((cd = eventAckMap.get(ackId)) != null) {
            cd.countDown();
        }
    }

    private static List<String> getInstances() {
        try {
            Method method = Class.forName("kd.bos.dlock.DLockUtil").getMethod("getInstanceList", new Class[0]);
            method.setAccessible(true);
            List instanceList = (List)method.invoke(null, new Object[0]);
            return instanceList;
        }
        catch (Exception e) {
            throw ExceptionUtil.asRuntimeException(e);
        }
    }
}

