/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.strategy.children;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.xdb.XDB;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBManageContext;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.sharding.config.ChildrenTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.config.ShardingConfigProvider;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.bos.xdb.sharding.sql.dml.update.ShardingDataMoveMeta;
import kd.bos.xdb.sharding.sql.parser.TableInfo;
import kd.bos.xdb.sharding.strategy.AbstractShardingStrategy;
import kd.bos.xdb.sharding.strategy.FilterTypeUtil;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.util.ArrayUtil;
import kd.bos.xdb.util.SQLUtil;
import kd.bos.xdb.xpm.metrics.action.ActionMetric;
import kd.bos.xdb.xpm.metrics.action.sharding.children.ChildrenSpan;
import kd.bos.xdb.xpm.metrics.action.sharding.children.QueryParentSpan;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;

public class ChildrenStrategy
extends AbstractShardingStrategy {
    private String table;
    private ChildrenTableConfig childrenConfig;
    private Map<String, String> queryParentValuesSQLMap = new ConcurrentHashMap<String, String>();
    private String selectFields;
    private ShardingConfig parentConfig;
    private boolean joinWithShardingField = false;
    private boolean firstLevelChildren;

    @Override
    protected void onInitConfig() {
        this.childrenConfig = (ChildrenTableConfig)this.config;
        this.table = this.childrenConfig.getTable();
        ShardingConfig rootConfig = this.parentConfig = this.childrenConfig.getParent();
        while (rootConfig.getShardingStrategy() instanceof ChildrenStrategy) {
            rootConfig = ((ChildrenStrategy)rootConfig.getShardingStrategy()).parentConfig;
        }
        this.firstLevelChildren = this.parentConfig == rootConfig;
        StringBuilder selectFields = new StringBuilder();
        String[] shardingFields = this.parentConfig.getShardingFields();
        for (int i = 0; i < shardingFields.length; ++i) {
            if (i > 0) {
                selectFields.append(',');
            }
            selectFields.append(shardingFields[i]);
        }
        this.selectFields = selectFields.toString();
        if (shardingFields.length == 1 && shardingFields[0].equalsIgnoreCase(this.childrenConfig.getParentField())) {
            this.joinWithShardingField = true;
        }
    }

    @Override
    protected void initConfigAssignIndexPKStore() {
        this.indexPKStore = ((AbstractShardingStrategy)((ChildrenTableConfig)this.config).getParent().getShardingStrategy()).getIndexPKStore();
        this.indexPKStore.initCacheSize(this.config.getTable());
    }

    @Override
    public String[] getAllShardingTables(boolean onlyExists) {
        if (onlyExists) {
            try {
                return XDBConfig.getTableManager().getShardingTable(this.childrenConfig.getTable());
            }
            catch (SQLException e) {
                throw ExceptionUtil.wrap(e);
            }
        }
        String[] parentTables = this.childrenConfig.getParent().getShardingStrategy().getAllShardingTables(onlyExists);
        String[] ret = new String[parentTables.length];
        TableName tn = TableName.of(this.table);
        String aliasTableName = tn.getAliasName();
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = aliasTableName + parentTables[i].substring(parentTables[i].lastIndexOf("$"));
        }
        return ret;
    }

    @Override
    public boolean isSupportBatchShardingIndex() {
        if (this.joinWithShardingField) {
            return ((AbstractShardingStrategy)this.parentConfig.getShardingStrategy()).isSupportBatchShardingIndex();
        }
        return true;
    }

    @Override
    public long[] shardingIndex(FilterType[] filterTypes, Object[] values) {
        ChildrenSpan span = null;
        MetricsCollector mc = MetricsCollector.getCurrent();
        if (mc.isActionMetricEnabled()) {
            span = new ChildrenSpan(this.childrenConfig.getTable(), this.childrenConfig.getJoinField(), values);
            mc.actionMetric().stat(span);
        }
        long[] ret = this.doShardingIndex(filterTypes, values, span);
        if (span != null) {
            span.setIndexies(ret);
        }
        return ret;
    }

    private long[] doShardingIndex(FilterType[] filterTypes, Object[] values, ChildrenSpan span) {
        boolean batch;
        if (this.joinWithShardingField) {
            if (span != null) {
                span.setMessage("turn to sharding parent " + this.parentConfig.getTable());
            }
            return ((AbstractShardingStrategy)this.parentConfig.getShardingStrategy()).shardingIndex(filterTypes, values);
        }
        for (FilterType ft : filterTypes) {
            if (ft == FilterType.eq || ft == FilterType.in_range) continue;
            throw new IllegalArgumentException("Children sharding table filter only support '=' and 'in': " + this.table + '.' + this.childrenConfig.getJoinField() + Arrays.toString((Object[])filterTypes) + Arrays.toString(values));
        }
        boolean bl = batch = filterTypes.length == 1 && values.length > 1;
        if (batch) {
            HashSet<Long> ret = new HashSet<Long>();
            ArrayList<Object> others = new ArrayList<Object>();
            ActionMetric am = MetricsCollector.getCurrent().actionMetric();
            for (Object value : values) {
                Long index = this.indexPKStore.getCache(am, this.table, value);
                if (index != null) {
                    ret.add(index);
                    continue;
                }
                others.add(value);
            }
            if (others.isEmpty()) {
                if (span != null) {
                    span.setMessage("batch hit cache");
                }
                return ArrayUtil.toArray(ret);
            }
            if (span != null) {
                span.setMessage("batch query parent");
            }
            StringBuilder queryParentValuesSQL = new StringBuilder(512);
            queryParentValuesSQL.append("SELECT ").append(this.selectFields).append(" FROM ").append(this.parentConfig.getTable()).append(" WHERE ").append(SQLUtil.inSQL(this.childrenConfig.getParentField(), others.size()));
            long[] indexies = this.queryParentShardingIndexies(queryParentValuesSQL.toString(), others.toArray());
            if (indexies.length == 1) {
                long index = indexies[0];
                for (Object e : others) {
                    this.indexPKStore.setCache(this.table, index, e);
                }
            }
            if (ret.isEmpty()) {
                return indexies;
            }
            for (long l : indexies) {
                ret.add(l);
            }
            return ArrayUtil.toArray(ret);
        }
        return this.doShardingIndex(filterTypes, values);
    }

    private long[] doShardingIndex(FilterType[] filterTypes, Object[] values) {
        FilterType ft = filterTypes[0];
        Object value = values[0];
        ActionMetric am = MetricsCollector.getCurrent().actionMetric();
        Long ret = this.indexPKStore.getCache(am, this.table, value);
        if (ret != null) {
            return new long[]{ret};
        }
        if (this.firstLevelChildren) {
            ret = this.indexPKStore.getCache(am, this.parentConfig.getTable(), value);
            if (ret != null) {
                return new long[]{ret};
            }
            long[] indexies = this.indexPKStore.getOrQueryPKShardingIndex(am, this.parentConfig.getTable(), values);
            if (indexies.length == 1) {
                this.indexPKStore.setCache(this.parentConfig.getTable(), indexies[0], value);
            }
            return indexies;
        }
        ret = this.indexPKStore.getCache(am, this.parentConfig.getTable(), value);
        if (ret != null) {
            return new long[]{ret};
        }
        String queryParentValuesSQL = this.queryParentValuesSQLMap.computeIfAbsent(Arrays.asList(filterTypes).toString(), k -> new StringBuilder(512).append("SELECT ").append(this.selectFields).append(" FROM ").append(this.parentConfig.getTable()).append(" WHERE ").append(this.childrenConfig.getParentField()).append(' ').append(ft.getCP()).append(" ?").toString());
        long[] indexies = this.queryParentShardingIndexies(queryParentValuesSQL, values);
        if (indexies.length == 1) {
            this.indexPKStore.setCache(this.table, indexies[0], value);
        }
        return indexies;
    }

    @Override
    public long[] shardingIndexBetweenAnd(Object v1, Object v2, boolean not) {
        String keys = FilterType.between_and.toString();
        String queryParentValuesSQL = this.queryParentValuesSQLMap.computeIfAbsent(keys, k -> {
            StringBuilder sb = new StringBuilder(512);
            sb.append("SELECT ").append(this.selectFields).append(" FROM ").append(this.parentConfig.getTable()).append(" WHERE ");
            sb.append(this.childrenConfig.getParentField()).append(" BETWEEN ? AND ?");
            return sb.toString();
        });
        return this.queryParentShardingIndexies(queryParentValuesSQL, new Object[]{v1, v2});
    }

    private long[] queryParentShardingIndexies(String sql, Object[] params) {
        MetricsCollector mc = MetricsCollector.getCurrent();
        if (mc.isActionMetricEnabled()) {
            mc.actionMetric().stat(new QueryParentSpan(sql, params));
        }
        int cols = this.parentConfig.getShardingFields().length;
        ArrayList<Object> mlist = new ArrayList<Object>();
        try (XDBManageContext xm = XDB.get().withManageContext();
             ResultSet rs = XDB.get().query(sql, params);){
            while (rs.next()) {
                for (int i = 0; i < cols; ++i) {
                    mlist.add(rs.getObject(i + 1));
                }
            }
        }
        catch (SQLException e) {
            throw ExceptionUtil.wrap(e);
        }
        int size = mlist.size();
        if (size == 0) {
            return ArrayUtil.EMPTY_INDEXIES;
        }
        AbstractShardingStrategy ps = (AbstractShardingStrategy)this.parentConfig.getShardingStrategy();
        FilterType[] fts = FilterTypeUtil.getEqFilterTypes(cols);
        HashSet<Long> ret = new HashSet<Long>();
        int n = size / cols;
        for (int i = 0; i < n; ++i) {
            Object[] vs = new Object[cols];
            int m = i * cols;
            for (int j = 0; j < cols; ++j) {
                vs[j] = mlist.get(m + j);
            }
            for (long index : ps.shardingIndex(fts, vs)) {
                ret.add(index);
            }
        }
        return ArrayUtil.toArray(ret);
    }

    @Override
    public boolean isExplicitFilter(FilterType filterType) {
        return FilterTypeUtil.isExplicit(filterType) || filterType == FilterType.between_and;
    }

    public static void sortTable(List<TableInfo> tis, final ShardingConfigProvider scp) {
        Collections.sort(tis, new Comparator<TableInfo>(){

            @Override
            public int compare(TableInfo t1, TableInfo t2) {
                int ret;
                ShardingConfig config2;
                int level1 = -1;
                int level2 = -1;
                ShardingConfig config1 = scp.getConfig(t1.getName());
                if (config1 != null) {
                    ++level1;
                    while (config1 instanceof ChildrenTableConfig) {
                        config1 = ((ChildrenTableConfig)config1).getParent();
                        ++level1;
                    }
                }
                if ((config2 = scp.getConfig(t2.getName())) != null) {
                    ++level2;
                    while (config2 instanceof ChildrenTableConfig) {
                        config2 = ((ChildrenTableConfig)config2).getParent();
                        ++level2;
                    }
                }
                if ((ret = level1 - level2) == 0) {
                    ret = t1.getPosIndex() - t2.getPosIndex();
                }
                return ret;
            }
        });
    }

    public String toString() {
        return this.table;
    }

    @Override
    public void onShardingDataMoveCommitted(List<ShardingDataMoveMeta> dmList, boolean receivedEventCall) {
        ShardingDataMoveMeta dm;
        Iterator<ShardingDataMoveMeta> iter = dmList.iterator();
        if (this.firstLevelChildren) {
            while (iter.hasNext()) {
                dm = iter.next();
                this.shardingIndexEqCache.set(new Object[]{dm.getPKValue()}, dm.getToShardingIndex());
            }
        } else {
            String parentTable = this.parentConfig.getTable();
            while (iter.hasNext()) {
                dm = iter.next();
                long toShardingIndex = dm.getToShardingIndex();
                Object[] fks = dm.getChildTablePKMap().get(parentTable);
                if (fks == null) continue;
                for (Object fk : fks) {
                    this.shardingIndexEqCache.set(new Object[]{fk}, toShardingIndex);
                }
            }
        }
        for (ShardingConfig sc : this.config.getChildrenConfigMap().values()) {
            sc.getShardingStrategy().onShardingDataMoveCommitted(dmList, receivedEventCall);
        }
    }
}

