/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.strategy.hash;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.bundle.BosRes;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.bos.xdb.sharding.strategy.AbstractShardingStrategy;
import kd.bos.xdb.sharding.strategy.FilterTypeUtil;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.util.HashCodeUtil;

public class ConsistentHashStrategy
extends AbstractShardingStrategy {
    private String[] shardingTables;
    private ConsistentHashStrategyBuilder cs;

    private ConsistentHashStrategy(ConsistentHashStrategyBuilder cs) {
        this.cs = cs;
    }

    @Override
    protected void onInitConfig() {
        this.cs.init();
        String originalTable = this.config.getTable();
        this.shardingTables = new String[this.cs.indexes.length];
        TableName tn = TableName.of(originalTable);
        for (int i = 0; i < this.shardingTables.length; ++i) {
            this.shardingTables[i] = tn.getShardingTable(this.cs.indexes[i]);
        }
    }

    @Override
    public String[] getAllShardingTables(boolean onlyExists) {
        if (onlyExists) {
            try {
                return XDBConfig.getTableManager().getShardingTable(this.config.getTable());
            }
            catch (SQLException e) {
                throw ExceptionUtil.wrap(e);
            }
        }
        return this.shardingTables;
    }

    @Override
    public long[] shardingIndex(FilterType[] filterTypes, Object[] values) {
        int hashCode = HashCodeUtil.getHashCode(values);
        return new long[]{this.cs.shardingIndex(hashCode)};
    }

    @Override
    public boolean isExplicitFilter(FilterType filterType) {
        return FilterTypeUtil.isExplicit(filterType);
    }

    public static class ConsistentHashStrategyBuilder {
        private Map<Integer, Long> shardingIndexMap = new TreeMap<Integer, Long>();
        private int[] segs;
        private long[] indexes;
        private long lastIndex;

        public static ConsistentHashStrategyBuilder create() {
            return new ConsistentHashStrategyBuilder();
        }

        private ConsistentHashStrategyBuilder() {
        }

        public ConsistentHashStrategyBuilder seg(int hashCode, long shardingIndex) {
            this.shardingIndexMap.put(hashCode, shardingIndex);
            return this;
        }

        public ConsistentHashStrategyBuilder batchSplitMaxSeg(int segCount, long fromShardingIndex) {
            int interval = Integer.MAX_VALUE / segCount;
            for (int i = 0; i < segCount; ++i) {
                this.shardingIndexMap.put(interval * (i + 1), fromShardingIndex + (long)i);
            }
            return this;
        }

        public ConsistentHashStrategy build() {
            return new ConsistentHashStrategy(this);
        }

        private void init() {
            Set<Integer> keySet = this.shardingIndexMap.keySet();
            if (keySet.size() < 2) {
                throw ExceptionUtil.wrap(BosRes.get((String)"bos-xdb", (String)"ConsistentHashStrategy_0", (String)"\u4e00\u81f4\u6027\u54c8\u5e0c\u6bb5\u987b\u8bbe\u7f6e2\u6216\u4ee5\u4e0a\u3002", (Object[])new Object[0]));
            }
            this.segs = new int[keySet.size()];
            this.indexes = new long[keySet.size()];
            int i = 0;
            Iterator<Integer> iter = keySet.iterator();
            while (iter.hasNext()) {
                this.segs[i] = iter.next();
                this.indexes[i] = this.shardingIndexMap.get(this.segs[i]);
                ++i;
            }
            this.lastIndex = this.indexes[this.indexes.length - 1];
        }

        private long shardingIndex(int hashCode) {
            for (int i = 0; i < this.segs.length; ++i) {
                if (hashCode >= this.segs[i]) continue;
                return this.indexes[i];
            }
            return this.lastIndex;
        }
    }
}

