/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.strategy.hash;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.bos.xdb.sharding.strategy.AbstractShardingStrategy;
import kd.bos.xdb.sharding.strategy.FilterTypeUtil;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.util.DateUtil;

public class DateModStrategy
extends AbstractShardingStrategy {
    private final int mod;
    private final String dateFormatPattern;
    private String[] shardingTables;

    public DateModStrategy(String dateFormatPattern, int mod) {
        if (mod <= 1) {
            throw new IllegalArgumentException("mod value incorrect(<=1): " + mod);
        }
        this.mod = mod;
        this.dateFormatPattern = dateFormatPattern;
    }

    @Override
    protected void onInitConfig() {
        String originalTable = this.config.getTable();
        this.shardingTables = new String[this.mod];
        TableName tn = TableName.of(originalTable);
        for (int i = 0; i < this.mod; ++i) {
            this.shardingTables[i] = tn.getShardingTable(i);
        }
    }

    @Override
    public String[] getAllShardingTables(boolean onlyExists) {
        if (onlyExists) {
            try {
                return XDBConfig.getTableManager().getShardingTable(this.config.getTable());
            }
            catch (SQLException e) {
                throw ExceptionUtil.wrap(e);
            }
        }
        return this.shardingTables;
    }

    @Override
    public long[] shardingIndex(FilterType[] filterTypes, Object[] values) {
        long valueForMod = 0L;
        SimpleDateFormat sdf = DateUtil.getDateFormat(this.dateFormatPattern);
        for (int i = 0; i < values.length; ++i) {
            try {
                valueForMod += this.date2Long((Date)values[i], sdf);
                continue;
            }
            catch (Exception e) {
                ++valueForMod;
            }
        }
        return new long[]{Math.abs(valueForMod) % (long)this.mod};
    }

    protected long date2Long(Date date, SimpleDateFormat sdf) throws Exception {
        return sdf.parse(sdf.format(date)).getTime();
    }

    @Override
    public boolean isExplicitFilter(FilterType filterType) {
        return FilterTypeUtil.isExplicit(filterType);
    }
}

