/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.strategy.hash;

import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bundle.BosRes;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.bos.xdb.sharding.strategy.AbstractShardingStrategy;
import kd.bos.xdb.sharding.strategy.FilterTypeUtil;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.util.DateUtil;
import kd.bos.xdb.util.HashCodeUtil;

public class HashModStrategy
extends AbstractShardingStrategy {
    private static final String default_extract_delims = "|:;";
    private static final String parameter_extra_delims = "mod.extra.delims";
    private static final String parameter_extra = "mod.extra";
    private final int mod;
    private final boolean hasExtra;
    private final Map<String, Integer> extraMap = new HashMap<String, Integer>(0);
    private final String dateFormatPattern;
    private String[] shardingTables;

    public HashModStrategy(int mod) {
        this(mod, null);
    }

    public HashModStrategy(int mod, String dateFormatPattern) {
        if (mod <= 1) {
            throw new IllegalArgumentException(BosRes.get((String)"bos-xdb", (String)"ModHashStrategy_0", (String)"Hash mod\u5fc5\u987b>1.", (Object[])new Object[0]));
        }
        this.mod = mod;
        this.dateFormatPattern = dateFormatPattern;
        this.hasExtra = false;
    }

    public HashModStrategy(Map<String, String> paramMap) {
        String extra;
        this.dateFormatPattern = paramMap.getOrDefault("pattern", "5");
        String delims = paramMap.get(parameter_extra_delims);
        if (delims != null) {
            if ((delims = delims.trim()).length() != 3) {
                throw new IllegalArgumentException("HashModStrategy mod.extra.delims should be 3 special char.");
            }
        } else {
            delims = default_extract_delims;
        }
        if ((extra = paramMap.get(parameter_extra)) != null) {
            for (String seg : extra.split("\\" + delims.charAt(2))) {
                int p = seg.lastIndexOf(delims.charAt(1));
                if (p == -1) {
                    throw new IllegalArgumentException("HashModStrategy mod.extra format error: " + extra);
                }
                String vs = seg.substring(0, p);
                String index = seg.substring(p + 1).trim();
                if (!index.matches("\\d+")) {
                    throw new IllegalArgumentException("HashModStrategy mod.extra format error: " + extra);
                }
                int i = Integer.parseInt(index);
                for (String v : vs.split("\\" + delims.charAt(0))) {
                    this.extraMap.put(v.trim(), i);
                }
            }
        }
        this.hasExtra = !this.extraMap.isEmpty();
        this.mod = Integer.parseInt(paramMap.getOrDefault("mod", "5"));
        if (this.mod <= 0 || this.mod == 1 && !this.hasExtra) {
            throw new IllegalArgumentException(BosRes.get((String)"bos-xdb", (String)"ModHashStrategy_0", (String)"Hash mod\u5fc5\u987b>1.", (Object[])new Object[0]));
        }
    }

    @Override
    protected void onInitConfig() {
        String originalTable = this.config.getTable();
        this.shardingTables = new String[this.mod];
        TableName tn = TableName.of(originalTable);
        for (int i = 0; i < this.mod; ++i) {
            this.shardingTables[i] = tn.getShardingTable(i);
        }
    }

    @Override
    public String[] getAllShardingTables(boolean onlyExists) {
        if (onlyExists) {
            try {
                return XDBConfig.getTableManager().getShardingTable(this.config.getTable());
            }
            catch (SQLException e) {
                throw ExceptionUtil.wrap(e);
            }
        }
        return this.shardingTables;
    }

    @Override
    public long[] shardingIndex(FilterType[] filterTypes, Object[] values) {
        Integer i;
        if (values.length == 1 && this.hasExtra && (i = this.extraMap.get(String.valueOf(values[0]))) != null) {
            return new long[]{i.intValue()};
        }
        if (this.dateFormatPattern != null) {
            int i2;
            Object[] newValues = new Object[values.length];
            SimpleDateFormat sdf = DateUtil.getDateFormat(this.dateFormatPattern);
            try {
                for (i2 = 0; i2 < values.length; ++i2) {
                    if (values[i2] instanceof Date) {
                        String s = sdf.format((Date)values[i2]);
                        newValues[i2] = sdf.parse(s).getTime();
                        continue;
                    }
                    newValues[i2] = values[i2];
                }
            }
            catch (ParseException e) {
                throw ExceptionUtil.wrap("Date format error: " + values[i2], e);
            }
            return new long[]{HashCodeUtil.getHashCode(newValues) % this.mod};
        }
        return new long[]{HashCodeUtil.getHashCode(values) % this.mod};
    }

    @Override
    public boolean isExplicitFilter(FilterType filterType) {
        return FilterTypeUtil.isExplicit(filterType);
    }
}

