/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.strategy.map.mapper;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.xdb.sharding.config.FieldType;
import kd.bos.xdb.sharding.strategy.map.mapper.AbstractValueMapper;
import kd.bos.xdb.util.HashCodeUtil;

public final class HashModMapper
extends AbstractValueMapper {
    private static final String default_extract_delims = "|:;";
    private static final String parameter_extra_delims = "mod.extra.delims";
    private static final String parameter_extra = "mod.extra";
    private final int mod;
    private final boolean hasExtra;
    private final Map<String, Integer> extraMap = new HashMap<String, Integer>(0);

    public HashModMapper(Map<String, String> paramMap) {
        super(paramMap);
        String extra;
        String delims = paramMap.get(parameter_extra_delims);
        if (delims != null) {
            if ((delims = delims.trim()).length() != 3) {
                throw new IllegalArgumentException("HashModMapper mod.extra.delims should be 3 special char.");
            }
        } else {
            delims = default_extract_delims;
        }
        if ((extra = paramMap.get(parameter_extra)) != null) {
            for (String seg : extra.split("\\" + delims.charAt(2))) {
                int p = seg.lastIndexOf(delims.charAt(1));
                if (p == -1) {
                    throw new IllegalArgumentException("HashModMapper mod.extra format error: " + extra);
                }
                String vs = seg.substring(0, p);
                String index = seg.substring(p + 1).trim();
                if (!index.matches("\\d+")) {
                    throw new IllegalArgumentException("HashModMapper mod.extra format error: " + extra);
                }
                int i = Integer.parseInt(index);
                for (String v : vs.split("\\" + delims.charAt(0))) {
                    this.extraMap.put(v.trim(), i);
                }
            }
        }
        this.hasExtra = !this.extraMap.isEmpty();
        this.mod = Integer.parseInt(paramMap.getOrDefault("mod", "5"));
        if (this.mod <= 0 || this.mod == 1 && !this.hasExtra) {
            throw new IllegalArgumentException("HashModMapper mod should be 1 or more.");
        }
    }

    @Override
    public Object mapValue(int fieldIndex, String field, FieldType fieldType, Object value) {
        Integer i;
        if (this.hasExtra && (i = this.extraMap.get(String.valueOf(value))) != null) {
            return i;
        }
        return HashCodeUtil.getHashCodeSingle(value) % this.mod;
    }

    public int getMod() {
        return this.mod;
    }

    public Map<String, Integer> getExtraMap() {
        return Collections.unmodifiableMap(this.extraMap);
    }

    public boolean hasExtra() {
        return this.hasExtra;
    }
}

