/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.strategy.spare;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Set;
import kd.bos.xdb.XDB;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBManageContext;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.ext.KSQL;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.indexpk.QueryIndexPKAction;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.bos.xdb.sharding.strategy.AbstractShardingStrategy;
import kd.bos.xdb.sharding.strategy.SupportBatchLikeSharding;
import kd.bos.xdb.sharding.strategy.spare.SpareStrategy;
import kd.bos.xdb.util.ArrayUtil;
import kd.bos.xdb.xpm.metrics.action.sharding.index.QueryByIndexSpan;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;

public class IndexSpareStrategy
extends SpareStrategy
implements SupportBatchLikeSharding {
    private final String indexField;

    public IndexSpareStrategy(String indexField, AbstractShardingStrategy mainStrategy) {
        super(new String[]{indexField}, mainStrategy);
        this.indexField = indexField;
    }

    @Override
    public long[] shardingIndex(FilterType[] filterTypes, Object[] values) {
        FilterType ft = filterTypes[0];
        if (ft == FilterType.eq || ft == FilterType.in_range) {
            return QueryIndexPKAction._queryShardingIndexWithoutCache(this.tableName.getPKTable(), this.indexField, values);
        }
        StringBuilder sql = new StringBuilder(256).append("SELECT DISTINCT(findex) FINDEX FROM ").append(this.tableName.getPKTable()).append(" WHERE ").append(this.indexField).append(' ');
        if (values.length == 1) {
            if (ft == FilterType.in_range) {
                ft = FilterType.eq;
            } else if (ft == FilterType.not_in_range) {
                ft = FilterType.not_eq;
            }
            sql.append(ft.getCP()).append(' ').append('?');
        } else {
            int i;
            if (ft == FilterType.eq) {
                ft = FilterType.in_range;
            } else if (ft == FilterType.not_eq) {
                ft = FilterType.not_in_range;
            }
            if (ft != FilterType.in_range && ft != FilterType.not_in_range && ft != FilterType.like) {
                throw new IllegalArgumentException("Filter type can't use to multi-values: " + (Object)((Object)filterTypes[0]));
            }
            if (ft == FilterType.like) {
                for (i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        sql.append(" OR ").append(this.indexField).append(' ');
                    }
                    sql.append("LIKE ?");
                }
            } else {
                sql.append(ft.getCP()).append('(');
                for (i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        sql.append(',');
                    }
                    sql.append('?');
                }
                sql.append(')');
            }
        }
        MainTableConfig mainTableConfig = XDBConfig.getShardingConfigProvider().getMainConfig(this.tableName.getOriginalName());
        Set<String> dbRoutes = mainTableConfig.getOptions().getIndexRoute().getDbRoutes();
        ArrayList<Long> ret = new ArrayList<Long>(8);
        for (String dbRoute : dbRoutes) {
            try {
                XDBManageContext xm = XDB.get().withManageContext();
                Throwable throwable = null;
                try {
                    xm.setRoute(dbRoute);
                    ResultSet rs = XDB.get().query(KSQL.dialect(NoShardingHint.genNoShardingSQL(sql.toString())), values);
                    Throwable throwable2 = null;
                    try {
                        while (rs.next()) {
                            ret.add(rs.getLong(1));
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable2 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (xm == null) continue;
                    if (throwable != null) {
                        try {
                            xm.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    xm.close();
                }
            }
            catch (SQLException e) {
                throw ExceptionUtil.wrap(e);
            }
        }
        long[] indexies = ArrayUtil.toArray(ret);
        MetricsCollector mc = MetricsCollector.getCurrent();
        if (mc.isActionMetricEnabled()) {
            mc.actionMetric().stat(new QueryByIndexSpan(this.tableName.getPKTable(), this.indexField, values, indexies));
        }
        return indexies;
    }

    @Override
    public boolean isExplicitFilter(FilterType filterType) {
        return filterType == FilterType.eq || filterType == FilterType.gt || filterType == FilterType.ge || filterType == FilterType.lt || filterType == FilterType.le || filterType == FilterType.between_and || filterType == FilterType.in_range || filterType == FilterType.like;
    }

    @Override
    public boolean isSupportBatchShardingIndex() {
        return true;
    }
}

