/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.sharding.strategy.spare;

import java.util.Collections;
import java.util.List;
import kd.bos.xdb.sharding.config.ChildrenTableConfig;
import kd.bos.xdb.sharding.config.FieldDefine;
import kd.bos.xdb.sharding.config.FieldType;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.sql.dml.update.ShardingDataMoveMeta;
import kd.bos.xdb.sharding.strategy.AbstractShardingStrategy;

public abstract class SpareStrategy
extends AbstractShardingStrategy {
    protected final AbstractShardingStrategy mainStrategy;
    private final String[] shardingFields;

    public SpareStrategy(String[] shardingFields, AbstractShardingStrategy mainStrategy) {
        this.shardingFields = shardingFields;
        this.mainStrategy = mainStrategy;
        this.setIndexPK(mainStrategy.isIndexPK());
        this.initConfig(this.copyMainConfig());
    }

    @Override
    protected void initConfigAssignIndexPKStore() {
        this.indexPKStore = this.mainStrategy.getIndexPKStore();
        this.indexPKStore.initCacheSize(this.config.getTable());
    }

    private ShardingConfig copyMainConfig() {
        ShardingConfig config;
        ShardingConfig oldConfig = this.mainStrategy.getConfig();
        if (oldConfig instanceof MainTableConfig) {
            FieldDefine[] shardingFieldDefines = new FieldDefine[this.shardingFields.length];
            int i = 0;
            for (String shardingField : this.shardingFields) {
                FieldDefine def = oldConfig.getOptions().getShardingFieldDefines(shardingField);
                if (def == null) {
                    def = new FieldDefine(oldConfig.getTable(), shardingField, FieldType.LONG);
                }
                shardingFieldDefines[i++] = def;
            }
            config = ShardingConfig.table(oldConfig.getEntitynumber(), oldConfig.getName(), oldConfig.getTable(), shardingFieldDefines, this, oldConfig.getOptions().getDataRowsRange(), oldConfig.getOptions().getIndexDefines());
        } else {
            ChildrenTableConfig oldChildrenConfig = (ChildrenTableConfig)oldConfig;
            config = ShardingConfig.childrenTable(oldConfig.getName(), oldConfig.getTable(), oldChildrenConfig.getJoinField(), oldChildrenConfig.getParentField(), oldChildrenConfig.getParent());
        }
        config.setIndexPK(this.mainStrategy.isIndexPK());
        return config;
    }

    @Override
    public String[] getAllShardingTables(boolean onlyExists) {
        return this.mainStrategy.getAllShardingTables(onlyExists);
    }

    @Override
    protected void onInitConfig() {
    }

    @Override
    protected List<SpareStrategy> createSpareStrategies() {
        return Collections.emptyList();
    }

    @Override
    protected boolean isUseEqCache() {
        return false;
    }

    @Override
    public void clearCache() {
    }

    @Override
    public void onShardingDataMoved(List<ShardingDataMoveMeta> dmList) {
    }

    @Override
    public void onShardingDataMoveCommitted(List<ShardingDataMoveMeta> dmList, boolean receivedEventCall) {
    }
}

