/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.tablemanager;

import java.io.IOException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.bundle.BosRes;
import kd.bos.util.CollectionUtils;
import kd.bos.util.JSONUtils;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBExternal;
import kd.bos.xdb.XDBLogable;
import kd.bos.xdb.datasource.ConnectionProvider;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.ext.ExtContext;
import kd.bos.xdb.ext.KSQL;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.id.IDUtil;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.strategy.ShardingStrategy;
import kd.bos.xdb.sharding.strategy.date.DateDayStrategy;
import kd.bos.xdb.sharding.strategy.date.DateMonthSrategy;
import kd.bos.xdb.sharding.strategy.id.IDSequenceStrategy;
import kd.bos.xdb.sharding.strategy.map.MapStrategy;
import kd.bos.xdb.tablemanager.AliasManager;
import kd.bos.xdb.tablemanager.ChangeTableCacheNotifier;
import kd.bos.xdb.tablemanager.LockCreateTableCall;
import kd.bos.xdb.tablemanager.TableManager;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.tablemanager.meta.Column;
import kd.bos.xdb.tablemanager.meta.CreateIndexSqlInfo;
import kd.bos.xdb.tablemanager.meta.Imeta;
import kd.bos.xdb.tablemanager.meta.IndexColumnString;
import kd.bos.xdb.tablemanager.meta.IndexInfo;
import kd.bos.xdb.tablemanager.meta.MetaFactory;
import kd.bos.xdb.tablemanager.meta.PkInfo;
import kd.bos.xdb.tablemanager.tableversion.TableVersionUpdator;
import kd.bos.xdb.xpm.metrics.action.sharding.table.CreateTableSpan;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;

public abstract class AbstractTableManager
implements TableManager,
XDBLogable {
    private ChangeTableCacheNotifier changeTableCacheNotifier;
    protected TableVersionUpdator tableVersionUpdator;

    protected void fireTableCreated(String tableName, long currentVersion) {
        if (this.changeTableCacheNotifier != null) {
            this.changeTableCacheNotifier.notifyCreated(tableName, currentVersion);
        }
    }

    public ChangeTableCacheNotifier getChangeTableCacheNotifier() {
        return this.changeTableCacheNotifier;
    }

    @Override
    public void setChangeTableCacheNotifier(ChangeTableCacheNotifier changeTableCacheNotifier) {
        this.changeTableCacheNotifier = changeTableCacheNotifier;
    }

    @Override
    public void setTableVersionUpdator(TableVersionUpdator tableVersionUpdator) {
        this.tableVersionUpdator = tableVersionUpdator;
    }

    @Override
    public TableVersionUpdator getTableVersionUpdator() {
        return this.tableVersionUpdator;
    }

    @Override
    public void clearCahce(String tableName) {
    }

    @Override
    public void add2Cahce(String specificTableName) {
    }

    @Override
    public void removeCahce(String specificTableName) {
    }

    @Override
    public String createShardingTable(String tableName, long shardingIndex) throws SQLException {
        TableName tn = TableName.of(tableName);
        String prototypeTable = tn.getPrototypeTable();
        String shardingTable = tn.getShardingTable(shardingIndex);
        this.createTableLike(shardingTable, prototypeTable);
        return shardingTable;
    }

    @Override
    public String createShardingTable(String dbRoute, String tableName, long shardingIndex) throws SQLException {
        TableName tn = TableName.of(tableName);
        String prototypeTable = tn.getPrototypeTable();
        String shardingTable = tn.getShardingTable(shardingIndex);
        this.createTableLike(dbRoute, shardingTable, prototypeTable);
        return shardingTable;
    }

    @Override
    public String createPrototypeTable(String tableName) throws SQLException {
        TableName tn = TableName.of(tableName);
        this.createTableLike(tn.getOriginalsnapTable(), tn.getOriginalName());
        this.createTableLike(tn.getPrototypeTable(), tn.getOriginalName());
        return tn.getPrototypeTable();
    }

    @Override
    public String createOriginalTable(String tableName, boolean isOriSnap) throws SQLException {
        TableName tn = TableName.of(tableName);
        if (isOriSnap) {
            this.createTableLike(tn.getOriginalName(), tn.getOriginalsnapTable());
        } else {
            this.createTableLike(tn.getOriginalName(), tn.getPrototypeTable());
        }
        return tn.getOriginalName();
    }

    private void createTableLike(String dbRoute, String table, String likeTable) throws SQLException {
        boolean withIfNotExists;
        DBType dbType = ConnectionProvider.get().getConnectionHolder().getDBType();
        Callable<Object> call = () -> {
            switch (dbType) {
                case dm: 
                case oracle: 
                case yasdb: 
                case oceanbase_oracle: 
                case hana: {
                    this.__doCreateTableLike_oracle(dbRoute, table, likeTable);
                    break;
                }
                case derby: 
                case mysql: 
                case tdsql: 
                case tidb: {
                    this.__doCreateTableLike(dbRoute, table, likeTable);
                    break;
                }
                case postgresql: 
                case gs: 
                case gs100: 
                case gaussdb: 
                case gauss200: 
                case gbase: 
                case kingbase: 
                case vastbase: 
                case sqlserver: {
                    this.__doCreateTableLike_pg(dbRoute, table, likeTable);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(BosRes.get((String)"bos-xdb", (String)"AbstractTableManager_0", (String)"\u5c1a\u672a\u5b9e\u73b0\u590d\u5236\u8868\u7ed3\u6784\u548c\u7d22\u5f15: dbType={0}", (Object[])new Object[]{dbType}));
                }
            }
            return null;
        };
        boolean bl = withIfNotExists = dbType == DBType.mysql;
        if (withIfNotExists) {
            try {
                call.call();
            }
            catch (Exception e) {
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw ExceptionUtil.wrap(e);
            }
        } else {
            LockCreateTableCall.lockAndCall(table, () -> {
                if (!this.existTable(dbRoute, table)) {
                    try {
                        call.call();
                    }
                    catch (Exception e) {
                        if (e instanceof SQLException) {
                            throw (SQLException)e;
                        }
                        throw ExceptionUtil.wrap(e);
                    }
                }
            });
        }
    }

    private void createTableLike(String table, String likeTable) throws SQLException {
        MetricsCollector mc = MetricsCollector.getCurrent();
        if (mc.isActionMetricEnabled()) {
            mc.actionMetric().stat(new CreateTableSpan(table, likeTable));
        }
        this.createTableLike(ExtContext.get().getDBRoute(), table, likeTable);
    }

    private void __doCreateTableLike(String dbRoute, String table, String likeTable) throws SQLException {
        String sql = NoShardingHint.genNoShardingSQL("create table if not exists " + table + " like " + likeTable);
        sql = KSQL.dialect(sql);
        try (XDBExternal xdbe = XDBExternal.requiresNew("xdb.__doCreateTableLike");){
            xdbe.execute(dbRoute, sql);
            if (ExtContext.get().getDBRoute().equalsIgnoreCase(dbRoute)) {
                this.handleIndexFieldCombinations(xdbe, table, likeTable);
            }
        }
    }

    private void __doCreateTableLike_pg(String dbRoute, String table, String likeTable) throws SQLException {
        likeTable = likeTable.toLowerCase();
        this.__doCreateTableLikeByAssembleSql(dbRoute, table, likeTable);
    }

    private void __doCreateTableLike_oracle(String dbRoute, String table, String likeTable) throws SQLException {
        likeTable = likeTable.toUpperCase();
        this.__doCreateTableLikeByAssembleSql(dbRoute, table, likeTable);
    }

    private void __doCreateTableLikeByAssembleSql(String dbRoute, String table, String likeTable) throws SQLException {
        if (!this.existTable(dbRoute, table)) {
            try (XDBExternal xdbe = XDBExternal.notSupported("xdb.__doCreateTableLikeByAssembleSql");){
                Imeta meta = MetaFactory.getMeta();
                List<Column> columnList = meta.queryColumns(dbRoute, likeTable);
                String createTableSQL = meta.createTableSql(table, columnList);
                createTableSQL = KSQL.dialect(NoShardingHint.genNoShardingSQL(createTableSQL));
                xdbe.execute(dbRoute, createTableSQL);
                PkInfo pkInfo = meta.queryPkInfo(dbRoute, likeTable);
                if (null != pkInfo.getIndexName()) {
                    String createTablePK = meta.createPkIndexSql(table, pkInfo);
                    createTablePK = KSQL.dialect(NoShardingHint.genNoShardingSQL(createTablePK));
                    xdbe.execute(dbRoute, createTablePK);
                }
                List<CreateIndexSqlInfo> createIndexSqlInfoList = meta.createIndexSql(dbRoute, table, likeTable, pkInfo);
                for (CreateIndexSqlInfo indexInfo : createIndexSqlInfoList) {
                    String createIndexSql = indexInfo.getCreateIndexSql();
                    createIndexSql = KSQL.dialect(NoShardingHint.genNoShardingSQL(createIndexSql));
                    xdbe.execute(dbRoute, createIndexSql);
                }
                List commentColumnList = columnList.stream().filter(item -> item.getColumnComment() != null).collect(Collectors.toList());
                for (Column column : commentColumnList) {
                    String alterCommentSql = meta.alterCommentSql(table, column);
                    alterCommentSql = KSQL.dialect(NoShardingHint.genNoShardingSQL(alterCommentSql));
                    xdbe.execute(dbRoute, alterCommentSql);
                }
                if (ExtContext.get().getDBRoute().equalsIgnoreCase(dbRoute)) {
                    this.handleIndexFieldCombinations(xdbe, table, likeTable);
                }
            }
        }
    }

    private void handleIndexFieldCombinations(XDBExternal xdbe, String table, String likeTable) {
        TableName likeTableName = TableName.of(likeTable);
        TableName tableName = TableName.of(table);
        ShardingConfig config = XDBConfig.getShardingConfigProvider().getConfig(tableName.getOriginalName());
        if (config instanceof MainTableConfig) {
            if (tableName.isPrototypeTable() && likeTableName.isOriginalTable()) {
                this.createIndexShardFieldCombinations(xdbe, likeTable, table);
            }
            if (tableName.isOriginalTable() && likeTableName.isPrototypeTable()) {
                this.dropIndexShardFieldCombinations(table);
            }
        }
    }

    private void createIndexShardFieldCombinations(XDBExternal xdbe, String likeTable, String table) {
        ShardingStrategy shardingStrategy;
        Object[] shardingFields;
        MainTableConfig mainTableConfig = (MainTableConfig)XDBConfig.getShardingConfigProvider().getConfig(likeTable);
        Object[] retainFields = shardingFields = mainTableConfig.getShardingFields();
        Imeta imeta = MetaFactory.getMeta();
        List<IndexInfo> indexInfoList = this.getIndexInfoListExcludePk(likeTable);
        if (log.isInfoEnabled()) {
            log.info("AbstractTableManager getTableIndex likeTable:{},table,{},indexInfoList:{}", new Object[]{likeTable, table, this.toJsonString(indexInfoList)});
        }
        if ((shardingStrategy = XDBConfig.getShardingConfigProvider().getConfig(likeTable).getShardingStrategy()) instanceof MapStrategy || shardingStrategy instanceof DateDayStrategy || shardingStrategy instanceof DateMonthSrategy || shardingStrategy instanceof IDSequenceStrategy) {
            retainFields = this.getRetainFields(shardingStrategy);
            ArrayList<String> delFieldsList = new ArrayList<String>(Arrays.asList(shardingFields));
            ArrayList<String> retainFieldsList = new ArrayList<String>(Arrays.asList(retainFields));
            delFieldsList.removeAll(retainFieldsList);
            if (CollectionUtils.isEmpty(delFieldsList)) {
                return;
            }
            HashSet delIndex = new HashSet();
            List<IndexInfo> retainIndexInfoList = new ArrayList<IndexInfo>(10);
            for (IndexInfo indexInfo2 : indexInfoList) {
                boolean isChanged;
                List<IndexColumnString> columnList = indexInfo2.getColumnNameList();
                List<IndexColumnString> newColumnList = columnList.stream().filter(c -> !delFieldsList.contains(c.getColumn())).collect(Collectors.toList());
                boolean bl = isChanged = columnList.size() != newColumnList.size();
                if (isChanged) {
                    indexInfo2.setColumnNameList(newColumnList);
                    delIndex.add(indexInfo2.getIndexName());
                }
                if (!CollectionUtils.isNotEmpty(indexInfo2.getColumnNameList())) continue;
                retainIndexInfoList.add(indexInfo2);
            }
            if (log.isInfoEnabled()) {
                log.info("AbstractTableManager delIndex:{},retainFields:{}", (Object)delIndex, (Object)Arrays.toString(retainFields));
            }
            if (CollectionUtils.isNotEmpty((Collection)delIndex) && CollectionUtils.isNotEmpty(retainIndexInfoList)) {
                if (log.isInfoEnabled()) {
                    log.info("AbstractTableManager duplicate removal before retainIndexInfoList:{}", (Object)this.toJsonString(retainIndexInfoList));
                }
                Set<String> duplicateKeySet = this.getDuplicateKeySet(retainIndexInfoList);
                delIndex.addAll(duplicateKeySet);
                retainIndexInfoList = retainIndexInfoList.stream().filter(indexInfo -> !duplicateKeySet.contains(indexInfo.getIndexName())).collect(Collectors.toList());
                log.info("AbstractTableManager delIndex:{}", (Object)delIndex);
                this.dropIndex(table, delIndex);
                if (log.isInfoEnabled()) {
                    log.info("AbstractTableManager duplicate removal after retainIndexInfoList:{}", (Object)this.toJsonString(retainIndexInfoList));
                }
                for (IndexInfo indexInfo3 : retainIndexInfoList) {
                    if (!delIndex.contains(indexInfo3.getIndexName())) continue;
                    CreateIndexSqlInfo createIndexSqlInfo = imeta.createIndexSql(table, indexInfo3);
                    String sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(createIndexSqlInfo.getCreateIndexSql()));
                    xdbe.execute(sql);
                }
            } else if (CollectionUtils.isNotEmpty((Collection)delIndex)) {
                this.dropIndex(table, delIndex);
            }
            indexInfoList = retainIndexInfoList;
        }
        String pkField = mainTableConfig.getPKField();
        HashSet<String> retainFieldsSet = new HashSet<String>();
        if (pkField != null) {
            for (String string : retainFields) {
                if (string.equalsIgnoreCase(pkField)) continue;
                retainFieldsSet.add(string);
            }
            retainFields = retainFieldsSet.toArray(new String[0]);
        }
        List<String[]> notExistsIndexs = this.getNotExistsIndexFieldCombinations((String[])retainFields, indexInfoList);
        for (String[] fields : notExistsIndexs) {
            String string = "XDB_IDX_" + IDUtil.stringId();
            this.createTableIndex(xdbe, table, string, fields);
        }
    }

    private Set<String> getDuplicateKeySet(List<IndexInfo> retainIndexInfoList) {
        HashSet<String> duplicateKeySet = new HashSet<String>();
        for (int i = 0; i < retainIndexInfoList.size() - 1; ++i) {
            for (int j = i + 1; j < retainIndexInfoList.size(); ++j) {
                IndexInfo innerIndexInfo;
                IndexInfo indexInfo = retainIndexInfoList.get(i);
                boolean isDel = this.isDuplicate(indexInfo, innerIndexInfo = retainIndexInfoList.get(j));
                if (!isDel) continue;
                if (indexInfo.getColumnNameList().size() > innerIndexInfo.getColumnNameList().size()) {
                    duplicateKeySet.add(innerIndexInfo.getIndexName());
                    continue;
                }
                duplicateKeySet.add(indexInfo.getIndexName());
            }
        }
        return duplicateKeySet;
    }

    private List<IndexInfo> getIndexInfoListExcludePk(String table) {
        Imeta imeta = MetaFactory.getMeta();
        List<IndexInfo> indexInfoList = imeta.queryIndexInfos(table);
        PkInfo pkInfo = imeta.queryPkInfo(table);
        return indexInfoList.stream().filter(indexInfo -> !indexInfo.getIndexName().equalsIgnoreCase(pkInfo.getIndexName())).collect(Collectors.toList());
    }

    private boolean isDuplicate(IndexInfo index1, IndexInfo index2) {
        List<IndexColumnString> columnNameList = index1.getColumnNameList();
        List<IndexColumnString> innerColumnNameList = index2.getColumnNameList();
        int n = Math.min(columnNameList.size(), innerColumnNameList.size());
        boolean isDuplicate = true;
        for (int i = 0; i < n; ++i) {
            if (columnNameList.get(i).getColumn().equals(innerColumnNameList.get(i).getColumn())) continue;
            isDuplicate = false;
            break;
        }
        return isDuplicate;
    }

    private String[] getRetainFields(ShardingStrategy shardingStrategy) {
        String[] retainFields = new String[]{};
        if (shardingStrategy instanceof MapStrategy) {
            retainFields = ((MapStrategy)shardingStrategy).getRetainIndexFields();
        }
        return retainFields;
    }

    private String toJsonString(Object obj) {
        try {
            return JSONUtils.toString((Object)obj);
        }
        catch (IOException e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    private void createTableIndex(XDBExternal xdbe, String table, String indexName, String[] fields) {
        log.info(MessageFormat.format("AbstractTableManager createTableIndex table:{0}, indexName:{1}, fields:{2}", table, indexName, Arrays.toString(fields)));
        String shardingIndexName = AliasManager.get().getIndexAliasName(table, indexName);
        StringBuilder createTableIndex = new StringBuilder(256);
        createTableIndex.append("CREATE INDEX ").append(shardingIndexName).append(" ON ").append(table).append('(');
        int i = 0;
        for (String field : fields) {
            if (i > 0) {
                createTableIndex.append(',');
            }
            createTableIndex.append(field);
            ++i;
        }
        createTableIndex.append(')');
        String sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(createTableIndex.toString()));
        xdbe.execute(sql);
    }

    private void dropIndexShardFieldCombinations(String table) {
        Imeta meta = MetaFactory.getMeta();
        List<IndexInfo> indexInfoList = meta.queryIndexInfos(table);
        for (IndexInfo indexInfo : indexInfoList) {
            if (!indexInfo.getIndexName().toUpperCase().startsWith("XDB_IDX_")) continue;
            meta.dropIndex(table, indexInfo.getIndexName());
        }
    }

    private void dropIndex(String table, Set<String> indexs) {
        DBType dbType = ConnectionProvider.get().getConnectionHolder().getDBType();
        if (dbType == DBType.oracle) {
            table = table.toUpperCase();
        }
        for (String index : indexs) {
            String indexName = AliasManager.get().getIndexAliasName(table, index);
            MetaFactory.getMeta().dropIndex(table, indexName);
        }
    }

    private List<String[]> getNotExistsIndexFieldCombinations(String[] shardingFields, List<IndexInfo> retainIndexInfoList) {
        ArrayList<String[]> indexCombinas = new ArrayList<String[]>(shardingFields.length);
        int n = shardingFields.length;
        for (int i = 0; i < n; ++i) {
            boolean isContain = false;
            for (IndexInfo indexInfo : retainIndexInfoList) {
                List<IndexColumnString> columnStringList = indexInfo.getColumnNameList();
                int l = columnStringList.size();
                for (int j = 0; j < l && columnStringList.get(j).getColumn().equalsIgnoreCase(shardingFields[i + j]); ++j) {
                    if (i + j != n - 1) continue;
                    isContain = true;
                    break;
                }
                if (!isContain) continue;
                break;
            }
            if (!isContain) {
                String[] index = new String[shardingFields.length - i];
                System.arraycopy(shardingFields, i, index, 0, shardingFields.length - i);
                indexCombinas.add(index);
            }
            if (n > 3) break;
        }
        return indexCombinas;
    }

    @Override
    public boolean existTable(String dbRoute, String tableName) throws SQLException {
        String sql = NoShardingHint.genNoShardingSQL("SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME='" + tableName + "'");
        AtomicBoolean exist = new AtomicBoolean(false);
        try (XDBExternal xdbe = XDBExternal.requiresNew("existTable");){
            xdbe.query(dbRoute, sql, null, rs -> {
                try {
                    if (rs.next()) {
                        exist.set(true);
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    throw ExceptionUtil.wrap(e);
                }
            });
        }
        return exist.get();
    }

    @Override
    public void createCrossTable(String originalRoute, String originalTable, String targetRoute, String targetTable) throws SQLException {
        Callable<Object> call = () -> {
            this.__docreateCrossTableLike(originalRoute, originalTable, targetRoute, targetTable);
            return null;
        };
        LockCreateTableCall.lockAndCall(targetTable, () -> {
            if (!this.existTable(targetRoute, targetTable)) {
                try {
                    call.call();
                }
                catch (Exception e) {
                    if (e instanceof SQLException) {
                        throw (SQLException)e;
                    }
                    throw ExceptionUtil.wrap(e);
                }
            }
        });
    }

    private void __docreateCrossTableLike(String originalRoute, String originalTable, String targetRoute, String targetTable) throws SQLException {
        if (!this.existTable(targetRoute, targetTable)) {
            try (XDBExternal xdbe = XDBExternal.notSupported("xdb.__docreateCrossTableLike");){
                Imeta meta = MetaFactory.getMeta();
                List<Column> columnList = meta.queryColumns(originalRoute, originalTable);
                String createTableSQL = meta.createTableSql(targetTable, columnList);
                createTableSQL = KSQL.dialect(NoShardingHint.genNoShardingSQL(createTableSQL));
                xdbe.execute(targetRoute, createTableSQL);
                PkInfo pkInfo = meta.queryPkInfo(originalRoute, originalTable);
                if (null != pkInfo.getIndexName()) {
                    String createTablePK = meta.createPkIndexSql(targetTable, pkInfo);
                    createTablePK = KSQL.dialect(NoShardingHint.genNoShardingSQL(createTablePK));
                    xdbe.execute(targetRoute, createTablePK);
                }
                List<CreateIndexSqlInfo> createIndexSqlInfoList = meta.createIndexSql(originalRoute, targetTable, originalTable, pkInfo);
                for (CreateIndexSqlInfo indexInfo : createIndexSqlInfoList) {
                    String createIndexSql = indexInfo.getCreateIndexSql();
                    createIndexSql = KSQL.dialect(NoShardingHint.genNoShardingSQL(createIndexSql));
                    xdbe.execute(targetRoute, createIndexSql);
                }
                List commentColumnList = columnList.stream().filter(item -> item.getColumnComment() != null).collect(Collectors.toList());
                for (Column column : commentColumnList) {
                    String alterCommentSql = meta.alterCommentSql(targetTable, column);
                    alterCommentSql = KSQL.dialect(NoShardingHint.genNoShardingSQL(alterCommentSql));
                    xdbe.execute(targetRoute, alterCommentSql);
                }
            }
        }
    }
}

