/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.tablemanager;

import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.xdb.dlock.DLock;
import kd.bos.xdb.exception.ExceptionUtil;

public interface LockCreateAliasCall {
    public String call() throws SQLException;

    public static String lockAndCall(String originalName, LockCreateAliasCall call) {
        String key = "/xdb/createAlias/" + originalName;
        try {
            AtomicReference aliasNameRef = new AtomicReference();
            while (true) {
                DLock.lock(key, () -> {
                    String aliasName = call.call();
                    aliasNameRef.set(aliasName);
                    return aliasName;
                });
                if (null != aliasNameRef.get()) {
                    return (String)aliasNameRef.get();
                }
                Thread.sleep(100L);
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }
}

