/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.tablemanager;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.bundle.BosRes;
import kd.bos.xdb.engine.ShardingEngineFactory;
import kd.bos.xdb.sharding.sql.parser.SQLUtil;
import kd.bos.xdb.tablemanager.AliasManager;

public final class TableName {
    public static final String table_sharding_delim = "$";
    private static final String table_prototype_suffix = "$_";
    private static final String table_originalsnap_suffix = "$ori";
    private static final String table_map_suffix = "$map";
    private static final String table_pk_suffix = "$pk";
    private static final String table_pk_temp_suffix = "$pktp";
    private static final String table_rt_suffix = "$rt";
    private static final String table_moving_delim = "m";
    public static final String table_moving_suffix = "$m";
    private static final Map<String, TableName> cache = new ConcurrentHashMap<String, TableName>();
    private final String name;
    private final String contextKey = TableName.getContextKey();
    private String originalName;
    private String aliasName;
    private String suffix;

    public static TableName of(String tableName) {
        tableName = SQLUtil.unWrapSQLTableName(tableName).toLowerCase();
        String key = TableName.getContextKey() + '#' + tableName;
        return cache.computeIfAbsent(key, name -> new TableName((String)name));
    }

    public static void clear(String tableName) {
        tableName = SQLUtil.unWrapSQLTableName(tableName).toLowerCase();
        String key1 = TableName.getContextKey() + '#' + tableName;
        String key2 = key1 + table_sharding_delim;
        for (String t : new ArrayList<String>(cache.keySet())) {
            if (!t.equals(key1) && !t.startsWith(key2)) continue;
            cache.remove(t);
        }
    }

    private static String getContextKey() {
        return ShardingEngineFactory.get().getShardingConfigProvider().getContextKey();
    }

    private TableName(String name) {
        this.name = name.substring(this.contextKey.length() + 1);
        this.init();
    }

    private void init() {
        int p = this.name.lastIndexOf(table_sharding_delim);
        if (p != -1) {
            this.originalName = this.aliasName = this.name.substring(0, p);
            this.suffix = this.name.substring(p + 1);
            this.originalName = AliasManager.get().getTableOriginalName(this.aliasName);
        } else {
            this.originalName = this.name;
            this.aliasName = AliasManager.get().getTableAliasName(this.originalName);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public String getSuffix() {
        this.ensureIsShardingTable();
        return this.suffix;
    }

    public boolean isSuffixEmpty() {
        return this.suffix == null || this.suffix.length() == 0;
    }

    public String toString() {
        return this.name;
    }

    public String getPrototypeTable() {
        String proTable = this.originalName + table_prototype_suffix;
        return proTable;
    }

    public String getOriginalsnapTable() {
        String oriTable = this.originalName + table_originalsnap_suffix;
        return oriTable;
    }

    public String getMapTable() {
        String mapTable = this.originalName + table_map_suffix;
        return mapTable;
    }

    public String getPKTable() {
        String pkTable = this.originalName + table_pk_suffix;
        return pkTable;
    }

    public String getPKTempTable() {
        String pkTable = this.originalName + table_pk_temp_suffix;
        return pkTable;
    }

    public String getRTTable() {
        String rtTable = this.originalName + table_rt_suffix;
        return rtTable;
    }

    public String getMovingTable() {
        String mvTable = this.originalName + table_moving_suffix;
        return mvTable;
    }

    public String getMovingTable(long shardingIndex) {
        if (shardingIndex == -1L) {
            return this.getMovingTable();
        }
        return this.getMovingTable(String.valueOf(shardingIndex));
    }

    public String getMovingTable(String shardingSuffix) {
        String mvTable = this.aliasName + table_moving_suffix + shardingSuffix;
        return mvTable;
    }

    public String getShardingTable(long shardingIndex) {
        if (shardingIndex == -1L) {
            return this.getPrototypeTable();
        }
        return this.getShardingTable(String.valueOf(shardingIndex));
    }

    public String getShardingTable(String shardingSuffix) {
        String srdTable = this.aliasName + table_sharding_delim + shardingSuffix;
        return srdTable;
    }

    public long getShardingIndex() {
        this.ensureIsShardingTable();
        return Long.parseLong(this.suffix);
    }

    public long getMovingIndex() {
        this.ensureIsShardingTable();
        int p = this.suffix.lastIndexOf(table_moving_delim);
        if (p != -1) {
            return Long.parseLong(this.suffix.substring(p + 1));
        }
        return -1L;
    }

    private void ensureIsShardingTable() {
        if (this.suffix == null || this.suffix.length() == 0) {
            throw new IllegalArgumentException(BosRes.get((String)"bos-xdb", (String)"TableName_0", (String)"{0}\u4e0d\u662f\u5206\u8868\u540d\u3002", (Object[])new Object[]{this.name}));
        }
    }

    public boolean isOriginalTable() {
        return this.name.equals(this.originalName);
    }

    public boolean isPrototypeTable() {
        return this.name.endsWith(table_prototype_suffix);
    }

    public boolean isOriginalSnapTable() {
        return this.name.endsWith(table_originalsnap_suffix);
    }

    public boolean isDataTable() {
        if (this.suffix == null || this.suffix.length() == 0) {
            return false;
        }
        return this.suffix.matches("\\d+");
    }

    public boolean isMovingTable() {
        if (this.suffix == null || this.suffix.length() == 0) {
            return false;
        }
        return this.suffix.matches("^m\\d+");
    }

    public boolean isMapTable() {
        return this.name.endsWith(table_map_suffix);
    }

    public boolean isPKTable() {
        return this.name.endsWith(table_pk_suffix);
    }

    public boolean isPKTempTable() {
        return this.name.endsWith(table_pk_temp_suffix);
    }

    public boolean isShardingTable(boolean shouldDataTable) {
        if (shouldDataTable) {
            return this.isDataTable();
        }
        return this.isPrototypeTable() || this.isMapTable() || this.isPKTable();
    }
}

