/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.tablemanager.meta;

import kd.bos.bundle.BosRes;
import kd.bos.xdb.datasource.ConnectionProvider;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.tablemanager.meta.DMMetaImpl;
import kd.bos.xdb.tablemanager.meta.Imeta;
import kd.bos.xdb.tablemanager.meta.MetaAbs;
import kd.bos.xdb.tablemanager.meta.MsSqlMetaImpl;
import kd.bos.xdb.tablemanager.meta.MysqlMetaImpl;
import kd.bos.xdb.tablemanager.meta.OracleMetaImpl;
import kd.bos.xdb.tablemanager.meta.PgMetaImpl;
import kd.bos.xdb.tablemanager.meta.YasdbMetaImpl;

public class MetaFactory {
    public static Imeta getMeta() {
        DBType dbType = ConnectionProvider.get().getConnectionHolder().getDBType();
        MetaAbs imeta = null;
        switch (dbType) {
            case dm: {
                imeta = DMMetaImpl.instance;
                break;
            }
            case oracle: 
            case oceanbase_oracle: 
            case hana: {
                imeta = OracleMetaImpl.instance;
                break;
            }
            case yasdb: {
                imeta = YasdbMetaImpl.instance;
                break;
            }
            case mysql: 
            case derby: 
            case tdsql: 
            case tidb: {
                imeta = MysqlMetaImpl.instance;
                break;
            }
            case postgresql: 
            case gs: 
            case gs100: 
            case gaussdb: 
            case gauss200: 
            case gbase: 
            case kingbase: 
            case vastbase: {
                imeta = PgMetaImpl.instance;
                break;
            }
            case sqlserver: {
                imeta = MsSqlMetaImpl.instance;
                break;
            }
            default: {
                throw new UnsupportedOperationException(BosRes.get((String)"bos-xdb", (String)"AbstractTableManager_0", (String)"\u5c1a\u672a\u5b9e\u73b0\u590d\u5236\u8868\u7ed3\u6784\u548c\u7d22\u5f15: dbType={0}", (Object[])new Object[]{dbType}));
            }
        }
        return imeta;
    }
}

