/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.tablemanager.meta;

import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.xdb.XDBExternal;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.ext.KSQL;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.tablemanager.AliasManager;
import kd.bos.xdb.tablemanager.meta.Column;
import kd.bos.xdb.tablemanager.meta.CreateIndexSqlInfo;
import kd.bos.xdb.tablemanager.meta.IndexInfo;
import kd.bos.xdb.tablemanager.meta.MetaAbs;
import kd.bos.xdb.tablemanager.meta.PkInfo;

public final class MsSqlMetaImpl
extends MetaAbs {
    public static final MsSqlMetaImpl instance = new MsSqlMetaImpl();

    @Override
    public List<Column> queryColumns(String dbRoute, String table) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT A.NAME column_name,B.NAME data_type,A.MAX_LENGTH data_length, COLUMNPROPERTY(A.object_id,A.NAME,'PRECISION') data_precision, ");
        sql.append(" ISNULL(COLUMNPROPERTY(A.object_id,A.NAME,'SCALE'),0) data_scale, A.is_nullable nullable,ISNULL(E.TEXT,'') data_default, ");
        sql.append(" ISNULL(G.[VALUE],'') column_comment,A.column_id column_id ");
        sql.append(" FROM sys.columns A LEFT JOIN sys.types B ON A.user_type_id = B.user_type_id ");
        sql.append(" INNER JOIN sys.objects D ON A.object_id = D.object_id AND D.TYPE = 'U' ");
        sql.append(" LEFT JOIN syscomments E ON A.default_object_id =E.id ");
        sql.append(" LEFT JOIN sys.extended_properties G ON A.object_id = G.major_id AND A.column_id = G.minor_id ");
        sql.append(" WHERE D.NAME = ? ");
        sql.append(" ORDER BY A.object_id ,A.column_id ");
        String querySql = KSQL.dialect(NoShardingHint.genNoShardingSQL(sql.toString()));
        ArrayList<Column> columnList = new ArrayList<Column>(50);
        try (XDBExternal xdbe = XDBExternal.requiresNew("queryColumns");){
            xdbe.query(dbRoute, querySql, new Object[]{table}, rs -> {
                try {
                    while (rs.next()) {
                        Column column = new Column();
                        String column_name = rs.getString("column_name");
                        String dataType = rs.getString("data_type");
                        int data_precision = this.parseIntNullAsZero(rs.getString("data_precision"));
                        int data_scale = this.parseIntNullAsZero(rs.getString("data_scale"));
                        boolean nullable = "1".equals(rs.getString("nullable"));
                        int column_id = rs.getInt("column_id");
                        String column_comment = rs.getString("column_comment");
                        String column_default = rs.getString("data_default");
                        column_default = this.decorateDataDefault(column_default);
                        column.setColumnId(column_id);
                        column.setColumnName(column_name);
                        column.setDataType(dataType);
                        column.setDataDefault(column_default);
                        column.setDataLength(data_precision);
                        column.setDataPrecision(data_precision);
                        column.setDataScale(data_scale);
                        column.setNullable(nullable);
                        column.setColumnComment(column_comment);
                        columnList.add(column);
                    }
                }
                catch (SQLException e) {
                    throw ExceptionUtil.wrap(e);
                }
            });
        }
        return columnList;
    }

    private String decorateDataDefault(Object dataDefaultStr) {
        String dataDefault;
        if (dataDefaultStr != null && (dataDefault = String.valueOf(dataDefaultStr)).length() > 0) {
            int end = dataDefault.indexOf("))");
            if (end < 0) {
                end = dataDefault.indexOf("')");
            }
            if (end > 2) {
                dataDefault = dataDefault.substring(2, end);
                return dataDefault;
            }
        }
        return null;
    }

    @Override
    public void addColumn(String dbRoute, String table, Column column) {
        try (XDBExternal xdbe = XDBExternal.requiresNew("addColumn");){
            StringBuilder addColumnSql = new StringBuilder(1024);
            addColumnSql.append("alter table ").append(table).append(" add ").append(this.getColumnDesc(column, true));
            String sql = addColumnSql.toString();
            sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(sql));
            xdbe.execute(dbRoute, sql);
        }
    }

    @Override
    public String createTableSql(String table, List<Column> columnList) {
        StringBuilder createTableSQL = new StringBuilder(1024);
        createTableSQL.append("CREATE TABLE ").append(table).append("(");
        int n = columnList.size();
        for (int i = 0; i < n; ++i) {
            Column column = columnList.get(i);
            if (i > 0) {
                createTableSQL.append(",");
            }
            createTableSQL.append(this.getColumnDesc(column, false));
        }
        createTableSQL.append(")");
        return createTableSQL.toString();
    }

    @Override
    public String alterCommentSql(String table, Column column) {
        StringBuilder sql = new StringBuilder();
        sql.append("EXEC sys.sp_addextendedproperty ");
        sql.append("@name = 'MS_Description', ");
        sql.append("@value = N'").append(column.getColumnComment()).append("', ");
        sql.append("@level0type = N'schema', ");
        sql.append("@level0name = N'dbo', ");
        sql.append("@level1type = N'table', ");
        sql.append("@level1name = N'").append(table).append("', ");
        sql.append("@level2type = N'column', ");
        sql.append("@level2name = N'").append(column.getColumnName()).append("'; ");
        return sql.toString();
    }

    private String getColumnDesc(Column column, boolean isAddColumn) {
        StringBuilder columnDesc = new StringBuilder(1024);
        columnDesc.append(column.getColumnName()).append(" ");
        String dataType = column.getDataType();
        long dataLength = column.getDataLength();
        int dataScale = column.getDataScale();
        int dataPrecision = column.getDataPrecision();
        columnDesc.append(dataType);
        switch (dataType) {
            case "numeric": 
            case "decimal": {
                if (dataScale != 0) {
                    columnDesc.append('(').append(dataPrecision).append(',').append(dataScale).append(')');
                    break;
                }
                if (dataPrecision == 0) break;
                columnDesc.append('(').append(dataPrecision).append(")");
                break;
            }
            case "varbinary": 
            case "varchar": 
            case "nvarchar": 
            case "nchar": 
            case "char": 
            case "binary": {
                if (dataLength == 0L) break;
                columnDesc.append('(').append(dataLength).append(')');
            }
        }
        columnDesc.append(column.isNullable() ? " NULL" : " NOT NULL");
        if (column.getDataDefault() != null && column.getDataDefault().toString().length() > 0) {
            columnDesc.append(" DEFAULT ");
            String dataDefault = String.valueOf(column.getDataDefault());
            columnDesc.append(dataDefault.trim().length() == 0 ? "' '" : dataDefault);
        }
        return columnDesc.toString();
    }

    @Override
    public PkInfo queryPkInfo(String dbRoute, String table) {
        StringBuilder queryIndexSql = new StringBuilder();
        queryIndexSql.append("SELECT i.name AS index_name, c.name AS column_name,i.is_unique,i.is_primary_key ");
        queryIndexSql.append("FROM sys.indexes i ");
        queryIndexSql.append("INNER JOIN sys.index_columns ic ON i.object_id = ic.object_id AND i.index_id = ic.index_id ");
        queryIndexSql.append("INNER JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id ");
        queryIndexSql.append("INNER JOIN sys.tables t ON i.object_id = t.object_id ");
        queryIndexSql.append("WHERE t.name = ? AND i.is_primary_key = 1 order by i.index_id, ic.index_column_id ");
        String queryIndexStr = KSQL.dialect(NoShardingHint.genNoShardingSQL(queryIndexSql.toString()));
        PkInfo pkInfo = new PkInfo();
        try (XDBExternal xdbe = XDBExternal.requiresNew("queryPkInfo");){
            xdbe.query(dbRoute, queryIndexStr, new Object[]{table}, rs -> {
                try {
                    if (rs.next()) {
                        String indexName = rs.getString(1);
                        String columnName = rs.getString(2);
                        pkInfo.setIndexName(indexName);
                        pkInfo.addColumn(columnName, true);
                    }
                }
                catch (SQLException e) {
                    throw ExceptionUtil.wrap(e);
                }
            });
        }
        return pkInfo;
    }

    @Override
    public String createPkIndexSql(String table, PkInfo pkInfo) {
        StringBuilder createTablePK = new StringBuilder(256);
        createTablePK.append("ALTER TABLE ").append(table).append(" ADD CONSTRAINT ");
        String indexName = pkInfo.getIndexName();
        String shardingIndexName = AliasManager.get().getIndexAliasName(table, indexName);
        createTablePK.append(shardingIndexName).append(" PRIMARY KEY(");
        int n = pkInfo.getColumnNameList().size();
        for (int i = 0; i < n; ++i) {
            String column = pkInfo.getColumnNameList().get(i).getColumn();
            if (i > 0) {
                createTablePK.append(",");
            }
            createTablePK.append(column);
        }
        createTablePK.append(")");
        return createTablePK.toString();
    }

    @Override
    public List<CreateIndexSqlInfo> createIndexSql(String dbRoute, String table, String likeTable, PkInfo pkInfo) {
        List<IndexInfo> indexInfoList = this.queryIndexInfos(dbRoute, likeTable);
        ArrayList<CreateIndexSqlInfo> createIndexSqlInfos = new ArrayList<CreateIndexSqlInfo>(indexInfoList.size());
        for (IndexInfo indexInfo : indexInfoList) {
            if (indexInfo.isPrimary()) continue;
            CreateIndexSqlInfo createIndex = this.assembleCreateIndexSql(indexInfo, table);
            createIndexSqlInfos.add(createIndex);
        }
        return createIndexSqlInfos;
    }

    @Override
    public CreateIndexSqlInfo createIndexSql(String table, IndexInfo indexInfo) {
        return this.assembleCreateIndexSql(indexInfo, table);
    }

    private CreateIndexSqlInfo assembleCreateIndexSql(IndexInfo indexInfo, String table) {
        StringBuilder createIndexSql = new StringBuilder(256);
        String indexName = indexInfo.getIndexName();
        createIndexSql.append("CREATE  ");
        if (indexInfo.isUnique()) {
            createIndexSql.append("UNIQUE ");
        }
        createIndexSql.append("INDEX ").append(indexName).append(" ON ").append(table).append(" (");
        int n = indexInfo.getColumnNameList().size();
        for (int i = 0; i < n; ++i) {
            String column = indexInfo.getColumnNameList().get(i).getColumn();
            if (i > 0) {
                createIndexSql.append(",");
            }
            createIndexSql.append(column);
        }
        createIndexSql.append(")");
        CreateIndexSqlInfo createIndex = new CreateIndexSqlInfo();
        createIndex.setIndexName(indexName);
        createIndex.setCreateIndexSql(createIndexSql.toString());
        return createIndex;
    }

    @Override
    public List<IndexInfo> queryIndexInfos(String dbRoute, String likeTable) {
        StringBuilder queryIndexSql = new StringBuilder();
        queryIndexSql.append("SELECT i.name AS index_name, c.name AS column_name,i.is_unique,i.is_primary_key ");
        queryIndexSql.append("FROM sys.indexes i ");
        queryIndexSql.append("INNER JOIN sys.index_columns ic ON i.object_id = ic.object_id AND i.index_id = ic.index_id ");
        queryIndexSql.append("INNER JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id ");
        queryIndexSql.append("INNER JOIN sys.tables t ON i.object_id = t.object_id ");
        queryIndexSql.append("WHERE t.name = ? order by i.index_id, ic.index_column_id ");
        String queryIndexStr = KSQL.dialect(NoShardingHint.genNoShardingSQL(queryIndexSql.toString()));
        log.info(MessageFormat.format("AbstractTableManager MysqlMetaImpl queryIndexInfos queryIndexSql:{0},likeTable{1}", queryIndexStr, likeTable));
        ArrayList<IndexInfo> indexInfoList = new ArrayList<IndexInfo>(50);
        HashMap temp = new HashMap();
        try (XDBExternal xdbe = XDBExternal.requiresNew("queryIndexInfos");){
            xdbe.query(dbRoute, queryIndexStr, new Object[]{likeTable}, rs -> {
                try {
                    while (rs.next()) {
                        String indexName = rs.getString(1);
                        String columnName = rs.getString(2);
                        if (temp.get(indexName) == null) {
                            IndexInfo indexInfo = new IndexInfo();
                            indexInfoList.add(indexInfo);
                            indexInfo.setIndexName(indexName);
                            int is_unique = rs.getInt(3);
                            int is_primary_key = rs.getInt(4);
                            if (1 == is_unique) {
                                indexInfo.setUnique(true);
                            } else {
                                indexInfo.setUnique(false);
                            }
                            if (1 == is_primary_key) {
                                indexInfo.setPrimary(true);
                            } else {
                                indexInfo.setPrimary(false);
                            }
                            temp.put(indexName, indexInfo);
                        }
                        ((IndexInfo)temp.get(indexName)).addColumn(columnName, true);
                    }
                }
                catch (SQLException e) {
                    throw ExceptionUtil.wrap(e);
                }
            });
            ArrayList<IndexInfo> arrayList = indexInfoList;
            return arrayList;
        }
    }

    @Override
    public void dropIndex(String dbRoute, String table, String index) {
        try (XDBExternal xdbe = XDBExternal.requiresNew("dropIndex");){
            String sql = "drop index " + index + " on  " + table;
            sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(sql));
            xdbe.execute(dbRoute, sql);
        }
    }

    @Override
    public void dropPkIndex(String dbRoute, String table, String index) {
        try (XDBExternal xdbe = XDBExternal.requiresNew("dropPkIndex");){
            String sql = "alter table " + table + " drop constraint " + index;
            sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(sql));
            xdbe.execute(dbRoute, sql);
        }
    }

    @Override
    public void addIndex(String dbRoute, String table, IndexInfo index) {
        String createIndexSql = this.assembleCreateIndexSql(index, table).getCreateIndexSql();
        try (XDBExternal xdbe = XDBExternal.requiresNew("addIndex");){
            String sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(createIndexSql));
            xdbe.execute(dbRoute, sql);
        }
    }

    @Override
    public void renameTable(String dbRoute, String fromTable, String toTable) {
        try (XDBExternal xdbe = XDBExternal.requiresNew("renameTable");){
            StringBuilder renameSql = new StringBuilder();
            renameSql.append("EXEC sp_rename '").append(fromTable).append("' , '").append(toTable).append("';");
            String sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(renameSql.toString()));
            xdbe.execute(dbRoute, sql);
        }
    }
}

