/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.tablemanager.meta;

import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.util.StringUtils;
import kd.bos.xdb.XDBExternal;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.ext.KSQL;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.tablemanager.meta.Column;
import kd.bos.xdb.tablemanager.meta.CreateIndexSqlInfo;
import kd.bos.xdb.tablemanager.meta.IndexInfo;
import kd.bos.xdb.tablemanager.meta.MetaAbs;
import kd.bos.xdb.tablemanager.meta.PkInfo;

public final class MysqlMetaImpl
extends MetaAbs {
    public static final MysqlMetaImpl instance = new MysqlMetaImpl();

    @Override
    public List<Column> queryColumns(String dbRoute, String table) {
        String sql = "select column_name,data_type,character_maximum_length,numeric_precision,numeric_scale,is_nullable,column_default,ordinal_position,column_comment from information_schema.columns where table_schema = schema() and (table_name=?) order by ordinal_position";
        sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(sql));
        ArrayList<Column> columnList = new ArrayList<Column>(50);
        try (XDBExternal xdbe = XDBExternal.requiresNew("queryColumns");){
            xdbe.query(dbRoute, sql, new Object[]{table}, rs -> {
                try {
                    while (rs.next()) {
                        Column column = new Column();
                        String column_name = rs.getString("column_name");
                        String data_type = rs.getString("data_type");
                        long data_length = this.parseLongNullAsZero(rs.getString("character_maximum_length"));
                        int data_precision = this.parseIntNullAsZero(rs.getString("numeric_precision"));
                        int data_scale = this.parseIntNullAsZero(rs.getString("numeric_scale"));
                        boolean nullable = "YES".equals(rs.getString("is_nullable"));
                        int column_id = rs.getInt("ordinal_position");
                        String column_comment = rs.getString("column_comment");
                        column.setColumnId(column_id);
                        column.setColumnName(column_name);
                        column.setDataType(data_type);
                        column.setDataLength(data_length);
                        column.setDataPrecision(data_precision);
                        column.setDataScale(data_scale);
                        column.setNullable(nullable);
                        if ("bigint".equals(data_type) || "smallint".equals(data_type) || "int".equals(data_type) || "decimal".equals(data_type)) {
                            column.setDataDefault(0);
                        } else if ("varchar".equals(data_type)) {
                            column.setDataDefault(Character.valueOf(' '));
                        } else if ("char".equals(data_type)) {
                            String data_default;
                            String string = data_default = rs.getString("column_default") == null ? rs.getString("column_default") : rs.getString("column_default").trim();
                            column.setDataDefault(StringUtils.isEmpty((String)data_default) ? Character.valueOf(' ') : ("'0'".equals(data_default) ? Character.valueOf('0') : data_default));
                        }
                        column.setColumnComment(column_comment);
                        columnList.add(column);
                    }
                }
                catch (SQLException e) {
                    throw ExceptionUtil.wrap(e);
                }
            });
        }
        return columnList;
    }

    @Override
    public void addColumn(String dbRoute, String table, Column column) {
        try (XDBExternal xdbe = XDBExternal.requiresNew("addColumn");){
            StringBuilder addColumnSql = new StringBuilder(1024);
            addColumnSql.append("alter table ").append(table).append(" add column ").append(this.getColumnDesc(column));
            String sql = addColumnSql.toString();
            sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(sql));
            xdbe.execute(dbRoute, sql);
        }
    }

    @Override
    public String createTableSql(String table, List<Column> columnList) {
        StringBuilder createTableSQL = new StringBuilder(1024);
        createTableSQL.append("CREATE TABLE ").append(table).append("(");
        int n = columnList.size();
        for (int i = 0; i < n; ++i) {
            Column column = columnList.get(i);
            if (i > 0) {
                createTableSQL.append(",");
            }
            createTableSQL.append(this.getColumnDesc(column));
        }
        createTableSQL.append(")");
        return createTableSQL.toString();
    }

    @Override
    public String alterCommentSql(String tableName, Column column) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ");
        sql.append(tableName).append(" MODIFY COLUMN ");
        sql.append(this.getColumnDesc(column)).append(" ");
        return sql.toString();
    }

    private String getColumnDesc(Column column) {
        StringBuilder columnDesc = new StringBuilder(1024);
        columnDesc.append(column.getColumnName()).append(" ");
        String dataType = column.getDataType();
        long dataLength = column.getDataLength();
        switch (dataType) {
            case "date": {
                columnDesc.append("date");
                break;
            }
            case "datetime": {
                columnDesc.append("datetime");
                break;
            }
            default: {
                columnDesc.append(dataType);
                int dataScale = column.getDataScale();
                int dataPrecision = column.getDataPrecision();
                if (dataScale != 0) {
                    columnDesc.append("(").append(dataPrecision).append(",").append(dataScale).append(")");
                    break;
                }
                if (dataPrecision != 0) {
                    columnDesc.append("(").append(dataPrecision).append(")");
                    break;
                }
                if (dataLength == 0L) break;
                columnDesc.append("(").append(dataLength).append(")");
            }
        }
        if (!column.isNullable()) {
            columnDesc.append(" NOT NULL");
        }
        if ("bigint".equals(dataType) || "smallint".equals(dataType) || "int".equals(dataType) || "decimal".equals(dataType)) {
            columnDesc.append(" DEFAULT 0");
        } else if ("varchar".equals(dataType)) {
            columnDesc.append(" DEFAULT ' '");
        } else if ("char".equals(dataType) && dataLength == 1L) {
            columnDesc.append(" DEFAULT ").append(column.getDataDefault());
        }
        if (column.getColumnComment() != null) {
            columnDesc.append(" COMMENT ").append("'").append(column.getColumnComment()).append("'");
        }
        return columnDesc.toString();
    }

    @Override
    public PkInfo queryPkInfo(String dbRoute, String table) {
        String sql = "select column_name from information_schema.key_column_usage where table_schema = schema() and constraint_name='PRIMARY' and table_name=?";
        sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(sql));
        PkInfo pkInfo = new PkInfo();
        try (XDBExternal xdbe = XDBExternal.requiresNew("queryPkInfo");){
            xdbe.query(dbRoute, sql, new Object[]{table}, rs -> {
                try {
                    if (rs.next()) {
                        pkInfo.setIndexName("PRIMARY");
                        String column_name = rs.getString("column_name");
                        pkInfo.addColumn(column_name, true);
                    }
                }
                catch (SQLException e) {
                    throw ExceptionUtil.wrap(e);
                }
            });
        }
        return pkInfo;
    }

    @Override
    public String createPkIndexSql(String table, PkInfo pkInfo) {
        StringBuilder createTablePK = new StringBuilder(256);
        createTablePK.append("ALTER TABLE ").append(table).append(" ADD  ");
        createTablePK.append(" PRIMARY KEY(");
        int n = pkInfo.getColumnNameList().size();
        for (int i = 0; i < n; ++i) {
            String column = pkInfo.getColumnNameList().get(i).getColumn();
            if (i > 0) {
                createTablePK.append(",");
            }
            createTablePK.append(column);
        }
        createTablePK.append(")");
        return createTablePK.toString();
    }

    @Override
    public List<CreateIndexSqlInfo> createIndexSql(String dbRoute, String table, String likeTable, PkInfo pkInfo) {
        List<IndexInfo> indexInfoList = this.queryIndexInfos(dbRoute, likeTable);
        ArrayList<CreateIndexSqlInfo> createIndexSqlInfos = new ArrayList<CreateIndexSqlInfo>(indexInfoList.size());
        for (IndexInfo indexInfo : indexInfoList) {
            String indexName = indexInfo.getIndexName();
            if ("PRIMARY".equalsIgnoreCase(indexName)) continue;
            CreateIndexSqlInfo createIndex = this.assembleCreateIndexSql(indexInfo, table);
            createIndexSqlInfos.add(createIndex);
        }
        return createIndexSqlInfos;
    }

    @Override
    public CreateIndexSqlInfo createIndexSql(String table, IndexInfo indexInfo) {
        return this.assembleCreateIndexSql(indexInfo, table);
    }

    private CreateIndexSqlInfo assembleCreateIndexSql(IndexInfo indexInfo, String table) {
        StringBuilder createIndexSql = new StringBuilder(256);
        String indexName = indexInfo.getIndexName();
        createIndexSql.append("CREATE  ");
        if ("FULLTEXT".equalsIgnoreCase(indexInfo.getIndexType())) {
            createIndexSql.append("FULLTEXT ");
        } else if (indexInfo.isUnique()) {
            createIndexSql.append("UNIQUE ");
        }
        createIndexSql.append("INDEX ").append(indexName).append(" ON ").append(table).append(" (");
        int n = indexInfo.getColumnNameList().size();
        for (int i = 0; i < n; ++i) {
            String column = indexInfo.getColumnNameList().get(i).getColumn();
            if (i > 0) {
                createIndexSql.append(",");
            }
            createIndexSql.append(column);
        }
        createIndexSql.append(")");
        CreateIndexSqlInfo createIndex = new CreateIndexSqlInfo();
        createIndex.setIndexName(indexName);
        createIndex.setCreateIndexSql(createIndexSql.toString());
        return createIndex;
    }

    @Override
    public List<IndexInfo> queryIndexInfos(String dbRoute, String likeTable) {
        String queryIndexSql = "select index_name,column_name,non_unique,index_type  from information_schema.statistics where table_schema = schema() and table_name = ? order by index_name,seq_in_index";
        queryIndexSql = KSQL.dialect(NoShardingHint.genNoShardingSQL(queryIndexSql));
        log.info(MessageFormat.format("AbstractTableManager MysqlMetaImpl queryIndexInfos queryIndexSql:{0},likeTable{1}", queryIndexSql, likeTable));
        ArrayList<IndexInfo> indexInfoList = new ArrayList<IndexInfo>(50);
        HashMap temp = new HashMap();
        try (XDBExternal xdbe = XDBExternal.requiresNew("queryIndexInfos");){
            xdbe.query(dbRoute, queryIndexSql, new Object[]{likeTable}, rs -> {
                try {
                    while (rs.next()) {
                        String indexName = rs.getString(1);
                        String columnName = rs.getString(2);
                        if (temp.get(indexName) == null) {
                            IndexInfo indexInfo = new IndexInfo();
                            indexInfoList.add(indexInfo);
                            indexInfo.setIndexName(indexName);
                            int nonUnique = rs.getInt(3);
                            String indexType = rs.getString(4);
                            indexInfo.setIndexType(indexType);
                            if (0 == nonUnique) {
                                indexInfo.setUnique(true);
                            } else {
                                indexInfo.setUnique(false);
                            }
                            temp.put(indexName, indexInfo);
                        }
                        ((IndexInfo)temp.get(indexName)).addColumn(columnName, true);
                    }
                }
                catch (SQLException e) {
                    throw ExceptionUtil.wrap(e);
                }
            });
            ArrayList<IndexInfo> arrayList = indexInfoList;
            return arrayList;
        }
    }

    @Override
    public void dropIndex(String dbRoute, String table, String index) {
        try (XDBExternal xdbe = XDBExternal.requiresNew("dropIndex");){
            String sql = "drop index " + index + " on  " + table;
            sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(sql));
            xdbe.execute(dbRoute, sql);
        }
    }

    @Override
    public void dropPkIndex(String dbRoute, String table, String index) {
        try (XDBExternal xdbe = XDBExternal.requiresNew("dropPkIndex");){
            String sql = "alter table " + table + " drop primary key ";
            sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(sql));
            xdbe.execute(dbRoute, sql);
        }
    }

    @Override
    public void addIndex(String dbRoute, String table, IndexInfo index) {
        CreateIndexSqlInfo createIndex = this.assembleCreateIndexSql(index, table);
        try (XDBExternal xdbe = XDBExternal.requiresNew("addIndex");){
            String sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(createIndex.getCreateIndexSql()));
            xdbe.execute(dbRoute, sql);
        }
    }

    @Override
    public void renameTable(String dbRoute, String fromTable, String toTable) {
        try (XDBExternal xdbe = XDBExternal.requiresNew("renameTable");){
            StringBuilder renameSql = new StringBuilder();
            renameSql.append("rename table ").append(fromTable).append(" to ").append(toTable);
            String sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(renameSql.toString()));
            xdbe.execute(dbRoute, sql);
        }
    }
}

