/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.tablemanager.meta;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBExternal;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.ext.KSQL;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.sharding.sql.parser.SQLUtil;
import kd.bos.xdb.tablemanager.AliasManager;
import kd.bos.xdb.tablemanager.meta.Column;
import kd.bos.xdb.tablemanager.meta.CreateIndexSqlInfo;
import kd.bos.xdb.tablemanager.meta.IndexColumnString;
import kd.bos.xdb.tablemanager.meta.IndexInfo;
import kd.bos.xdb.tablemanager.meta.MetaAbs;
import kd.bos.xdb.tablemanager.meta.PkInfo;

public class OracleMetaImpl
extends MetaAbs {
    public static final OracleMetaImpl instance = new OracleMetaImpl();

    @Override
    public List<Column> queryColumns(String dbRoute, String table) {
        table = table.toUpperCase(Locale.ENGLISH);
        StringBuilder sql = new StringBuilder();
        sql.append(" select c.column_name,c.data_type,c.char_length,c.data_precision,c.data_scale,c.nullable,c.data_default,c.column_id,co.comments ");
        sql.append(" from user_tab_columns  c left join user_col_comments co on c.table_name=co.table_name and c.column_name = co.column_name ");
        sql.append(" where c.table_name= ? order by c.column_id ");
        ArrayList<Column> columnList = new ArrayList<Column>(50);
        try (XDBExternal xdbe = XDBExternal.requiresNew("queryColumns");){
            xdbe.query(dbRoute, KSQL.dialect(NoShardingHint.genNoShardingSQL(sql.toString())), new Object[]{table}, rs -> {
                try {
                    while (rs.next()) {
                        Column column = new Column();
                        String column_name = rs.getString("column_name");
                        String data_type = rs.getString("data_type");
                        String data_default = rs.getString("data_default");
                        data_default = data_default != null ? data_default.trim() : data_default;
                        long data_length = this.parseLongNullAsZero(rs.getString("char_length"));
                        int data_precision = this.parseIntNullAsZero(rs.getString("data_precision"));
                        int data_scale = this.parseIntNullAsZero(rs.getString("data_scale"));
                        boolean nullable = "Y".equals(rs.getString("nullable"));
                        int column_id = rs.getInt("column_id");
                        String comments = rs.getString("comments");
                        column.setColumnId(column_id);
                        column.setColumnName(column_name);
                        column.setDataType(data_type);
                        column.setDataLength(data_length);
                        column.setDataPrecision(data_precision);
                        column.setDataScale(data_scale);
                        column.setNullable(nullable);
                        column.setDataDefault(data_default);
                        column.setColumnComment(comments);
                        columnList.add(column);
                    }
                }
                catch (SQLException e) {
                    throw ExceptionUtil.wrap(e);
                }
            });
        }
        return columnList;
    }

    @Override
    public void addColumn(String dbRoute, String table, Column column) {
        table = table.toUpperCase(Locale.ENGLISH);
        try (XDBExternal xdbe = XDBExternal.requiresNew("addColumn");){
            StringBuilder addColumnSql = new StringBuilder(1024);
            addColumnSql.append("alter table ").append(table).append(" add ").append(this.getColumnDesc(column, true));
            String sql = addColumnSql.toString();
            sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(sql));
            xdbe.execute(dbRoute, sql);
        }
    }

    @Override
    public String createTableSql(String table, List<Column> columnList) {
        table = table.toUpperCase(Locale.ENGLISH);
        StringBuilder createTableSQL = new StringBuilder(1024);
        createTableSQL.append("CREATE TABLE ").append(table).append("(");
        int n = columnList.size();
        for (int i = 0; i < n; ++i) {
            Column column = columnList.get(i);
            if (i > 0) {
                createTableSQL.append(",");
            }
            createTableSQL.append(this.getColumnDesc(column, false));
        }
        createTableSQL.append(")");
        return createTableSQL.toString();
    }

    @Override
    public String alterCommentSql(String table, Column column) {
        table = table.toUpperCase(Locale.ENGLISH);
        StringBuilder sql = new StringBuilder();
        sql.append("COMMENT ON COLUMN ");
        sql.append(table).append(".").append(column.getColumnName());
        sql.append("  IS '");
        sql.append(column.getColumnComment()).append("'");
        return sql.toString();
    }

    private String getColumnDesc(Column column, boolean isAddColumn) {
        StringBuilder columnDesc = new StringBuilder(1024);
        columnDesc.append(column.getColumnName()).append(" ");
        String dataType = column.getDataType();
        long dataLength = column.getDataLength();
        int dataScale = column.getDataScale();
        int dataPrecision = column.getDataPrecision();
        columnDesc.append(dataType);
        switch (dataType) {
            case "NUMBER": 
            case "DECIMAL": {
                if (dataScale != 0) {
                    columnDesc.append('(').append(dataPrecision).append(',').append(dataScale).append(')');
                    break;
                }
                if (dataPrecision == 0) break;
                columnDesc.append('(').append(dataPrecision).append(")");
                break;
            }
            case "CHAR": 
            case "NCHAR": 
            case "VARCHAR": 
            case "NVARCHAR": 
            case "VARCHAR2": 
            case "NVARCHAR2": {
                if (dataLength == 0L) break;
                columnDesc.append('(').append(dataLength).append(')');
            }
        }
        Object dataDefault = column.getDataDefault();
        if (dataDefault != null && dataDefault.toString().length() > 0) {
            columnDesc.append(" DEFAULT ");
            if ("CHAR".equals(dataType) || "NCHAR".equals(dataType) || "VARCHAR2".equals(dataType) || "NVARCHAR2".equals(dataType)) {
                columnDesc.append(dataDefault.toString().trim().length() == 0 ? "' '" : dataDefault);
            } else {
                columnDesc.append(dataDefault);
            }
        } else if ("NUMBER".equals(dataType) || "DECIMAL".equals(dataType)) {
            columnDesc.append(" DEFAULT 0");
        } else if ("VARCHAR2".equals(dataType) || "NVARCHAR2".equals(dataType)) {
            columnDesc.append(" DEFAULT ' '");
        } else if ("CHAR".equals(dataType) && dataLength == 1L || "NCHAR".equals(dataType) && dataLength == 1L) {
            columnDesc.append(" DEFAULT '0'");
        }
        if (!column.isNullable()) {
            columnDesc.append(" NOT NULL ");
            if (!isAddColumn) {
                columnDesc.append(" ENABLE ");
            }
        }
        return columnDesc.toString();
    }

    @Override
    public PkInfo queryPkInfo(String dbRoute, String table) {
        table = table.toUpperCase(Locale.ENGLISH);
        String sql = "select cu.constraint_name,cu.column_name from user_cons_columns cu,user_constraints au where cu.constraint_name = au.constraint_name and au.constraint_type = 'P' and au.table_name = ?";
        sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(sql));
        PkInfo pkInfo = new PkInfo();
        try (XDBExternal xdbe = XDBExternal.requiresNew("queryPkInfo");){
            xdbe.query(dbRoute, sql, new Object[]{table}, rs -> {
                try {
                    if (rs.next()) {
                        String constraint_name = rs.getString("constraint_name");
                        String column_name = rs.getString("column_name");
                        pkInfo.setIndexName(constraint_name);
                        pkInfo.addColumn(column_name, true);
                    }
                }
                catch (SQLException e) {
                    throw ExceptionUtil.wrap(e);
                }
            });
        }
        return pkInfo;
    }

    @Override
    public String createPkIndexSql(String table, PkInfo pkInfo) {
        table = table.toUpperCase(Locale.ENGLISH);
        StringBuilder createTablePK = new StringBuilder(256);
        createTablePK.append("ALTER TABLE ").append(table).append(" ADD CONSTRAINT ");
        String indexName = pkInfo.getIndexName();
        String shardingIndexName = AliasManager.get().getIndexAliasName(table, indexName);
        createTablePK.append(shardingIndexName).append(" PRIMARY KEY(");
        int n = pkInfo.getColumnNameList().size();
        for (int i = 0; i < n; ++i) {
            String column = pkInfo.getColumnNameList().get(i).getColumn();
            if (i > 0) {
                createTablePK.append(",");
            }
            createTablePK.append(column);
        }
        createTablePK.append(")");
        return createTablePK.toString();
    }

    @Override
    public List<CreateIndexSqlInfo> createIndexSql(String dbRoute, String oriTable, String likeTable, PkInfo pkInfo) {
        String table = oriTable.toUpperCase(Locale.ENGLISH);
        String queryIndexSql = "SELECT DBMS_METADATA.GET_DDL('INDEX',u.index_name) FROM USER_INDEXES u WHERE u.table_name=?";
        queryIndexSql = KSQL.dialect(NoShardingHint.genNoShardingSQL(queryIndexSql));
        ArrayList<CreateIndexSqlInfo> createIndexSqlInfoList = new ArrayList<CreateIndexSqlInfo>(50);
        try (XDBExternal xdbe = XDBExternal.requiresNew("createIndexSql");){
            xdbe.query(dbRoute, queryIndexSql, new Object[]{likeTable}, rs -> {
                try {
                    while (rs.next()) {
                        String indexNameStr;
                        String[] indexNameArr;
                        String oriIndexName;
                        CreateIndexSqlInfo createIndexSqlInfo = new CreateIndexSqlInfo();
                        String createIndexSQL = rs.getString(1);
                        if (createIndexSQL.indexOf("$$\" ON \"") != -1) continue;
                        String buf = createIndexSQL.substring(0, createIndexSQL.indexOf(")") + 1);
                        StringBuilder sb = new StringBuilder(buf.length());
                        int p1 = buf.indexOf("INDEX");
                        if (p1 <= 0) continue;
                        int p2 = buf.indexOf(" ON ");
                        if (p2 <= 0) {
                            p2 = buf.indexOf(" on ");
                        }
                        if ((oriIndexName = SQLUtil.unWrapSQLTableName((indexNameArr = (indexNameStr = buf.substring(p1 + 6, p2)).split("\\."))[indexNameArr.length - 1])).equalsIgnoreCase(pkInfo.getIndexName()) || XDBConfig.isIndexStandardLimit() && !oriIndexName.toUpperCase(Locale.ENGLISH).startsWith("IDX") && !oriIndexName.toUpperCase(Locale.ENGLISH).startsWith("XDB_IDX_")) continue;
                        sb.append(buf, 0, p1 + 6);
                        String shardingIndexName = AliasManager.get().getIndexAliasName(table, oriIndexName);
                        sb.append(shardingIndexName).append(" ON ").append(table).append(' ');
                        sb.append(buf.substring(buf.indexOf(40)));
                        createIndexSqlInfo.setIndexName(oriIndexName);
                        createIndexSqlInfo.setCreateIndexSql(sb.toString());
                        createIndexSqlInfoList.add(createIndexSqlInfo);
                    }
                }
                catch (SQLException e) {
                    throw ExceptionUtil.wrap(e);
                }
            });
        }
        return createIndexSqlInfoList;
    }

    @Override
    public CreateIndexSqlInfo createIndexSql(String table, IndexInfo indexInfo) {
        table = table.toUpperCase(Locale.ENGLISH);
        String oriCreateSql = indexInfo.getCreateIndexSql();
        String buf = oriCreateSql.substring(0, oriCreateSql.indexOf(")") + 1);
        StringBuilder sb = new StringBuilder(buf.length());
        int p1 = buf.indexOf("INDEX");
        int p2 = buf.indexOf(" ON ");
        String indexNameStr = buf.substring(p1 + 6, p2);
        String[] indexNameArr = indexNameStr.split("\\.");
        String oriIndexName = SQLUtil.unWrapSQLTableName(indexNameArr[indexNameArr.length - 1]);
        sb.append(buf, 0, p1 + 6);
        String shardingIndexName = AliasManager.get().getIndexAliasName(table, oriIndexName);
        sb.append(shardingIndexName).append(" ON ").append(table).append(' ');
        sb.append('(');
        List<IndexColumnString> columnStringList = indexInfo.getColumnNameList();
        int i = 0;
        for (IndexColumnString columnString : columnStringList) {
            sb.append("\"").append(columnString.getColumn()).append("\"");
            if (!columnString.isAsc()) {
                sb.append(" DESC");
            }
            if (i < columnStringList.size() - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append(")");
        CreateIndexSqlInfo createIndexSqlInfo = new CreateIndexSqlInfo();
        createIndexSqlInfo.setIndexName(shardingIndexName);
        createIndexSqlInfo.setCreateIndexSql(sb.toString());
        return createIndexSqlInfo;
    }

    @Override
    public List<IndexInfo> queryIndexInfos(String dbRoute, String likeTable) {
        likeTable = likeTable.toUpperCase(Locale.ENGLISH);
        String queryIndexSql = "SELECT DBMS_METADATA.GET_DDL('INDEX',u.index_name) FROM USER_INDEXES u WHERE u.table_name=?";
        queryIndexSql = KSQL.dialect(NoShardingHint.genNoShardingSQL(queryIndexSql));
        ArrayList<IndexInfo> indexInfoList = new ArrayList<IndexInfo>(50);
        try (XDBExternal xdbe = XDBExternal.requiresNew("queryIndexInfos");){
            xdbe.query(dbRoute, queryIndexSql, new Object[]{likeTable}, rs -> {
                try {
                    while (rs.next()) {
                        String[] columnArray;
                        int p3;
                        IndexInfo indexInfo = new IndexInfo();
                        String returnCreateSQL = rs.getString(1);
                        if (returnCreateSQL.indexOf("$$\" ON \"") != -1) continue;
                        int p1 = returnCreateSQL.indexOf(")");
                        String createIndexSQL = returnCreateSQL.substring(0, p1 + 1);
                        indexInfo.setCreateIndexSql(createIndexSQL);
                        int p2 = createIndexSQL.indexOf("INDEX");
                        if (p2 <= 0) continue;
                        String uniqueStr = createIndexSQL.substring(6, p2).trim();
                        if (uniqueStr.equals("UNIQUE")) {
                            indexInfo.setUnique(true);
                        }
                        if ((p3 = createIndexSQL.indexOf(" ON ")) <= 0) {
                            p3 = createIndexSQL.indexOf(" on ");
                        }
                        String indexNameStr = createIndexSQL.substring(p2 + 6, p3);
                        String[] indexNameArr = indexNameStr.split("\\.");
                        String oriIndexName = SQLUtil.unWrapSQLTableName(indexNameArr[indexNameArr.length - 1]);
                        if (XDBConfig.isIndexStandardLimit() && !oriIndexName.toUpperCase(Locale.ENGLISH).startsWith("IDX") && !oriIndexName.toUpperCase(Locale.ENGLISH).startsWith("XDB_IDX_")) continue;
                        indexInfo.setIndexName(oriIndexName);
                        int p4 = createIndexSQL.indexOf(40);
                        String columnList = createIndexSQL.substring(p4 + 1, p1);
                        for (String columnDesc : columnArray = columnList.replace("\"", "").split(",")) {
                            String[] column = columnDesc.trim().trim().split(" ");
                            IndexColumnString columnString = column.length > 1 ? new IndexColumnString(column[0], false) : new IndexColumnString(column[0], true);
                            indexInfo.addIndexColumn(columnString);
                        }
                        indexInfoList.add(indexInfo);
                    }
                }
                catch (SQLException e) {
                    throw ExceptionUtil.wrap(e);
                }
            });
        }
        return indexInfoList;
    }

    @Override
    public void dropIndex(String dbRoute, String table, String index) {
        table = table.toUpperCase(Locale.ENGLISH);
        try (XDBExternal xdbe = XDBExternal.requiresNew("dropIndex");){
            String sql = "drop index " + index;
            sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(sql));
            xdbe.execute(dbRoute, sql);
        }
    }

    @Override
    public void dropPkIndex(String dbRoute, String table, String index) {
        table = table.toUpperCase(Locale.ENGLISH);
        try (XDBExternal xdbe = XDBExternal.requiresNew("dropPkIndex");){
            String sql = "alter table " + table + " drop constraint " + index;
            sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(sql));
            xdbe.execute(dbRoute, sql);
        }
    }

    @Override
    public void addIndex(String dbRoute, String table, IndexInfo index) {
        table = table.toUpperCase(Locale.ENGLISH);
        String createIndexSql = index.getCreateIndexSql();
        StringBuilder sb = new StringBuilder(createIndexSql.length());
        int p1 = createIndexSql.indexOf("INDEX");
        sb.append(createIndexSql, 0, p1 + 6);
        sb.append(index.getIndexName()).append(" ON ").append(table).append(' ');
        sb.append(createIndexSql.substring(createIndexSql.indexOf(40)));
        try (XDBExternal xdbe = XDBExternal.requiresNew("addIndex");){
            String sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(sb.toString()));
            xdbe.execute(dbRoute, sql);
        }
    }

    @Override
    public void renameTable(String dbRoute, String fromTable, String toTable) {
        fromTable = fromTable.toUpperCase(Locale.ENGLISH);
        toTable = toTable.toUpperCase(Locale.ENGLISH);
        try (XDBExternal xdbe = XDBExternal.requiresNew("renameTable");){
            StringBuilder renameSql = new StringBuilder();
            renameSql.append("ALTER TABLE ").append(fromTable.toUpperCase()).append(" RENAME TO ").append(toTable.toUpperCase());
            String sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(renameSql.toString()));
            xdbe.execute(dbRoute, sql);
        }
    }
}

