/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.tablemanager.meta;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import kd.bos.xdb.XDBExternal;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.ext.KSQL;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.sharding.sql.parser.SQLUtil;
import kd.bos.xdb.tablemanager.AliasManager;
import kd.bos.xdb.tablemanager.meta.Column;
import kd.bos.xdb.tablemanager.meta.CreateIndexSqlInfo;
import kd.bos.xdb.tablemanager.meta.IndexColumnString;
import kd.bos.xdb.tablemanager.meta.IndexInfo;
import kd.bos.xdb.tablemanager.meta.MetaAbs;
import kd.bos.xdb.tablemanager.meta.PkInfo;

public final class PgMetaImpl
extends MetaAbs {
    public static final PgMetaImpl instance = new PgMetaImpl();

    @Override
    public List<Column> queryColumns(String dbRoute, String table) {
        table = table.toLowerCase(Locale.ENGLISH);
        StringBuilder sql = new StringBuilder();
        sql.append(" select s.column_name,t.typname as data_type ,s.character_maximum_length,s.numeric_precision,s.numeric_scale,s.is_nullable,s.column_default,s.ordinal_position ");
        sql.append(" ,col_description((table_schema||'.'||table_name)::regclass::oid, ordinal_position) as column_comment ");
        sql.append(" from information_schema.columns s,pg_attribute a, pg_class c, pg_type t ");
        sql.append(" where  table_schema = current_schema () and s.table_name = c.relname and s.ordinal_position = a.attnum ");
        sql.append(" and a.attrelid = c.oid and a.atttypid = t.oid and s.table_name=? order by s.ordinal_position ");
        String querySql = KSQL.dialect(NoShardingHint.genNoShardingSQL(sql.toString()));
        ArrayList<Column> columnList = new ArrayList<Column>(50);
        try (XDBExternal xdbe = XDBExternal.requiresNew("queryColumns");){
            xdbe.query(dbRoute, querySql, new Object[]{table}, rs -> {
                try {
                    while (rs.next()) {
                        Column column = new Column();
                        String column_name = rs.getString("column_name");
                        String dataType = rs.getString("data_type");
                        long data_length = this.parseLongNullAsZero(rs.getString("character_maximum_length"));
                        int data_precision = this.parseIntNullAsZero(rs.getString("numeric_precision"));
                        int data_scale = this.parseIntNullAsZero(rs.getString("numeric_scale"));
                        boolean nullable = "YES".equals(rs.getString("is_nullable"));
                        int column_id = rs.getInt("ordinal_position");
                        String column_comment = rs.getString("column_comment");
                        String column_default = rs.getString("column_default");
                        column.setColumnId(column_id);
                        column.setColumnName(column_name);
                        column.setDataType(dataType);
                        column.setDataDefault(column_default);
                        column.setDataLength(data_length);
                        column.setDataPrecision(data_precision);
                        column.setDataScale(data_scale);
                        column.setNullable(nullable);
                        column.setColumnComment(column_comment);
                        columnList.add(column);
                    }
                }
                catch (SQLException e) {
                    throw ExceptionUtil.wrap(e);
                }
            });
        }
        return columnList;
    }

    @Override
    public void addColumn(String dbRoute, String table, Column column) {
        table = table.toLowerCase(Locale.ENGLISH);
        try (XDBExternal xdbe = XDBExternal.requiresNew("addColumn");){
            StringBuilder addColumnSql = new StringBuilder(1024);
            addColumnSql.append("alter table ").append(table).append(" add ").append(this.getColumnDesc(column, true));
            String sql = addColumnSql.toString();
            sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(sql));
            xdbe.execute(dbRoute, sql);
        }
    }

    @Override
    public String createTableSql(String table, List<Column> columnList) {
        table = table.toLowerCase(Locale.ENGLISH);
        StringBuilder createTableSQL = new StringBuilder(1024);
        createTableSQL.append("CREATE TABLE ").append(table).append("(");
        int n = columnList.size();
        for (int i = 0; i < n; ++i) {
            Column column = columnList.get(i);
            if (i > 0) {
                createTableSQL.append(",");
            }
            createTableSQL.append(this.getColumnDesc(column, false));
        }
        createTableSQL.append(")");
        return createTableSQL.toString();
    }

    @Override
    public String alterCommentSql(String table, Column column) {
        table = table.toLowerCase(Locale.ENGLISH);
        StringBuilder sql = new StringBuilder();
        sql.append("COMMENT ON COLUMN ");
        sql.append(table).append(".").append(column.getColumnName());
        sql.append("  IS '");
        sql.append(column.getColumnComment()).append("'");
        return sql.toString();
    }

    private String getColumnDesc(Column column, boolean isAddColumn) {
        StringBuilder columnDesc = new StringBuilder(1024);
        columnDesc.append(column.getColumnName()).append(" ");
        String dataType = column.getDataType();
        long dataLength = column.getDataLength();
        int dataScale = column.getDataScale();
        int dataPrecision = column.getDataPrecision();
        columnDesc.append(dataType);
        switch (dataType) {
            case "numeric": {
                if (dataScale != 0) {
                    columnDesc.append('(').append(dataPrecision).append(',').append(dataScale).append(')');
                    break;
                }
                if (dataPrecision == 0) break;
                columnDesc.append('(').append(dataPrecision).append(")");
                break;
            }
            default: {
                if (dataLength == 0L) break;
                columnDesc.append('(').append(dataLength).append(')');
            }
        }
        columnDesc.append(column.isNullable() ? " NULL" : " NOT NULL");
        if (column.getDataDefault() != null && column.getDataDefault().toString().length() > 0) {
            columnDesc.append(" DEFAULT ");
            String dataDefault = String.valueOf(column.getDataDefault());
            if (isAddColumn) {
                int seq = dataDefault.indexOf("::");
                columnDesc.append(dataDefault, 0, seq > 0 ? seq : dataDefault.length());
            } else {
                columnDesc.append(dataDefault.trim().length() == 0 ? "' '" : dataDefault);
            }
        }
        return columnDesc.toString();
    }

    @Override
    public PkInfo queryPkInfo(String dbRoute, String table) {
        table = table.toLowerCase(Locale.ENGLISH);
        String pkName = this.queryPkName(dbRoute, table);
        PkInfo pkInfo = new PkInfo();
        if (pkName != null) {
            String sql = "select constraint_name,column_name from information_schema.key_column_usage  where table_schema = current_schema () and constraint_name = ? ";
            sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(sql));
            try (XDBExternal xdbe = XDBExternal.requiresNew("queryPkInfo");){
                xdbe.query(sql, new Object[]{pkName}, rs -> {
                    try {
                        if (rs.next()) {
                            String constraint_name = rs.getString("constraint_name");
                            String column_name = rs.getString("column_name");
                            pkInfo.setIndexName(constraint_name);
                            pkInfo.addColumn(column_name, true);
                        }
                    }
                    catch (SQLException e) {
                        throw ExceptionUtil.wrap(e);
                    }
                });
            }
        }
        return pkInfo;
    }

    private String queryPkName(String dbRoute, String table) {
        table = table.toLowerCase(Locale.ENGLISH);
        String queryPkNameSql = "select b.conname from pg_class a,pg_constraint b where a.oid=b.conrelid and a.relname =? and b.contype = 'p' ";
        queryPkNameSql = KSQL.dialect(NoShardingHint.genNoShardingSQL(queryPkNameSql));
        AtomicReference pkName = new AtomicReference();
        try (XDBExternal xdbe = XDBExternal.requiresNew("queryPkName");){
            xdbe.query(dbRoute, queryPkNameSql, new Object[]{table}, rs -> {
                try {
                    if (rs.next()) {
                        pkName.set(rs.getString(1));
                    }
                }
                catch (SQLException e) {
                    throw ExceptionUtil.wrap(e);
                }
            });
        }
        return (String)pkName.get();
    }

    @Override
    public String createPkIndexSql(String table, PkInfo pkInfo) {
        table = table.toLowerCase(Locale.ENGLISH);
        StringBuilder createTablePK = new StringBuilder(256);
        createTablePK.append("ALTER TABLE ").append(table).append(" ADD CONSTRAINT ");
        String indexName = pkInfo.getIndexName();
        String shardingIndexName = AliasManager.get().getIndexAliasName(table, indexName);
        createTablePK.append(shardingIndexName).append(" PRIMARY KEY(");
        int n = pkInfo.getColumnNameList().size();
        for (int i = 0; i < n; ++i) {
            String column = pkInfo.getColumnNameList().get(i).getColumn();
            if (i > 0) {
                createTablePK.append(",");
            }
            createTablePK.append(column);
        }
        createTablePK.append(")");
        return createTablePK.toString();
    }

    @Override
    public List<CreateIndexSqlInfo> createIndexSql(String dbRoute, String oriTable, String likeTable, PkInfo pkInfo) {
        String table = oriTable.toLowerCase(Locale.ENGLISH);
        likeTable = likeTable.toLowerCase(Locale.ENGLISH);
        List<String> indexNameList = this.queryIndexNameList(dbRoute, likeTable);
        String queryCreateIndexSql = "select pg_get_indexdef('#indexname#'::regclass)";
        ArrayList<CreateIndexSqlInfo> createIndexSqlInfoList = new ArrayList<CreateIndexSqlInfo>(50);
        try (XDBExternal xdbe = XDBExternal.requiresNew("createIndexSql");){
            for (String indexName : indexNameList) {
                if (indexName.equalsIgnoreCase(pkInfo.getIndexName())) continue;
                CreateIndexSqlInfo createIndexSqlInfo = new CreateIndexSqlInfo();
                createIndexSqlInfo.setIndexName(indexName);
                String queryCreateSql = queryCreateIndexSql.replaceFirst("#indexname#", Matcher.quoteReplacement(indexName));
                queryCreateSql = KSQL.dialect(NoShardingHint.genNoShardingSQL(queryCreateSql));
                xdbe.query(queryCreateSql, null, rs -> {
                    try {
                        while (rs.next()) {
                            String returnCreateSql = rs.getString(1);
                            createIndexSqlInfo.setCreateIndexSql(this.assembleCreateIndexSql(returnCreateSql, table));
                        }
                    }
                    catch (SQLException e) {
                        throw ExceptionUtil.wrap(e);
                    }
                });
                createIndexSqlInfoList.add(createIndexSqlInfo);
            }
        }
        return createIndexSqlInfoList;
    }

    @Override
    public CreateIndexSqlInfo createIndexSql(String table, IndexInfo indexInfo) {
        table = table.toLowerCase(Locale.ENGLISH);
        String oriCreateSql = indexInfo.getCreateIndexSql();
        StringBuilder sb = new StringBuilder(oriCreateSql.length());
        int p0 = oriCreateSql.indexOf("INDEX");
        int p1 = oriCreateSql.indexOf("ON");
        int p2 = oriCreateSql.indexOf("USING");
        int p3 = oriCreateSql.indexOf("(");
        String oriIndexName = oriCreateSql.substring(p0 + 6, p1).trim();
        String shardingIndexName = AliasManager.get().getIndexAliasName(table, oriIndexName);
        sb.append(oriCreateSql, 0, p0).append(" INDEX ").append(shardingIndexName);
        sb.append(" ON ").append(table).append(' ');
        sb.append(oriCreateSql, p2, p3 + 1);
        List<IndexColumnString> columnStringList = indexInfo.getColumnNameList();
        int i = 0;
        for (IndexColumnString columnString : columnStringList) {
            sb.append(columnString.getColumn());
            if (!columnString.isAsc()) {
                sb.append(" DESC");
            }
            if (i < columnStringList.size() - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append(")");
        CreateIndexSqlInfo createIndexSqlInfo = new CreateIndexSqlInfo();
        createIndexSqlInfo.setIndexName(shardingIndexName);
        createIndexSqlInfo.setCreateIndexSql(sb.toString());
        return createIndexSqlInfo;
    }

    private String assembleCreateIndexSql(String returnCreateSql, String table) {
        table = table.toLowerCase(Locale.ENGLISH);
        StringBuilder sb = new StringBuilder(returnCreateSql.length());
        int p0 = returnCreateSql.indexOf("INDEX");
        int p1 = returnCreateSql.indexOf("ON");
        int p2 = returnCreateSql.indexOf("USING");
        String oriIndexName = SQLUtil.unWrapSQLTableName(returnCreateSql.substring(p0 + 6, p1).trim());
        String shardingIndexName = AliasManager.get().getIndexAliasName(table, oriIndexName);
        sb.append(returnCreateSql, 0, p0).append(" INDEX ").append(shardingIndexName);
        sb.append(" ON ").append(table).append(' ');
        sb.append(returnCreateSql.substring(p2));
        return sb.toString();
    }

    @Override
    public List<IndexInfo> queryIndexInfos(String dbRoute, String likeTable) {
        likeTable = likeTable.toLowerCase(Locale.ENGLISH);
        List<String> indexNameList = this.queryIndexNameList(dbRoute, likeTable);
        String queryCreateIndexSql = "select pg_get_indexdef('#indexname#'::regclass)";
        ArrayList<IndexInfo> indexInfoList = new ArrayList<IndexInfo>(50);
        try (XDBExternal xdbe = XDBExternal.requiresNew("queryIndexInfos");){
            for (String indexName : indexNameList) {
                IndexInfo indexInfo = new IndexInfo();
                indexInfoList.add(indexInfo);
                indexInfo.setIndexName(indexName);
                String queryCreateSql = queryCreateIndexSql.replaceFirst("#indexname#", Matcher.quoteReplacement(indexName));
                queryCreateSql = KSQL.dialect(NoShardingHint.genNoShardingSQL(queryCreateSql));
                xdbe.query(dbRoute, queryCreateSql, null, rs -> {
                    try {
                        while (rs.next()) {
                            String[] columnArray;
                            String returnCreateSql = rs.getString(1);
                            indexInfo.setCreateIndexSql(returnCreateSql);
                            int p1 = returnCreateSql.indexOf("INDEX");
                            String uniqueStr = returnCreateSql.substring(6, p1).trim();
                            if (uniqueStr.equals("UNIQUE")) {
                                indexInfo.setUnique(true);
                            }
                            int p2 = returnCreateSql.indexOf(40);
                            int p3 = returnCreateSql.indexOf(41);
                            String columnList = returnCreateSql.substring(p2 + 1, p3);
                            for (String columnDesc : columnArray = columnList.split(",")) {
                                String[] column = columnDesc.trim().split(" ");
                                IndexColumnString columnString = column.length > 1 ? new IndexColumnString(column[0], false) : new IndexColumnString(column[0], true);
                                indexInfo.addIndexColumn(columnString);
                            }
                        }
                    }
                    catch (SQLException e) {
                        throw ExceptionUtil.wrap(e);
                    }
                });
            }
        }
        return indexInfoList;
    }

    private List<String> queryIndexNameList(String dbRoute, String likeTable) {
        likeTable = likeTable.toLowerCase(Locale.ENGLISH);
        String queryIndexNameSql = "select i.relname,ix.indisunique,ix.indisprimary,ix.indkey from pg_class i, pg_index ix,pg_class t where i.relkind = 'i' and i.oid = ix.indexrelid  and t.oid = ix.indrelid and t.relname = ? ";
        queryIndexNameSql = KSQL.dialect(NoShardingHint.genNoShardingSQL(queryIndexNameSql));
        ArrayList<String> indexNames = new ArrayList<String>(50);
        try (XDBExternal xdbe = XDBExternal.requiresNew("queryIndexNameList");){
            xdbe.query(dbRoute, queryIndexNameSql, new Object[]{likeTable}, rs -> {
                try {
                    while (rs.next()) {
                        String indexName = rs.getString(1);
                        indexNames.add(indexName);
                    }
                }
                catch (SQLException e) {
                    throw ExceptionUtil.wrap(e);
                }
            });
        }
        return indexNames;
    }

    @Override
    public void dropIndex(String dbRoute, String table, String index) {
        table = table.toLowerCase(Locale.ENGLISH);
        try (XDBExternal xdbe = XDBExternal.requiresNew("dropIndex");){
            String sql = "drop index " + index;
            sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(sql));
            xdbe.execute(dbRoute, sql);
        }
    }

    @Override
    public void dropPkIndex(String dbRoute, String table, String index) {
        table = table.toLowerCase(Locale.ENGLISH);
        try (XDBExternal xdbe = XDBExternal.requiresNew("dropPkIndex");){
            String sql = "alter table " + table + " drop constraint " + index;
            sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(sql));
            xdbe.execute(dbRoute, sql);
        }
    }

    @Override
    public void addIndex(String dbRoute, String table, IndexInfo index) {
        table = table.toLowerCase(Locale.ENGLISH);
        String createIndexSql = this.assembleCreateIndexSql(index.getCreateIndexSql(), table);
        try (XDBExternal xdbe = XDBExternal.requiresNew("addIndex");){
            String sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(createIndexSql));
            xdbe.execute(dbRoute, sql);
        }
    }

    @Override
    public void renameTable(String dbRoute, String fromTable, String toTable) {
        fromTable = fromTable.toLowerCase(Locale.ENGLISH);
        toTable = toTable.toLowerCase(Locale.ENGLISH);
        try (XDBExternal xdbe = XDBExternal.requiresNew("renameTable");){
            StringBuilder renameSql = new StringBuilder();
            renameSql.append("alter table ").append(fromTable.toLowerCase()).append(" rename to ").append(toTable.toLowerCase());
            String sql = KSQL.dialect(NoShardingHint.genNoShardingSQL(renameSql.toString()));
            xdbe.execute(dbRoute, sql);
        }
    }
}

