/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.tablemanager.mysql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.xdb.XDB;
import kd.bos.xdb.XDBExternal;
import kd.bos.xdb.XDBManageContext;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.ext.KSQL;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.sharding.config.DataRowsRange;
import kd.bos.xdb.sharding.config.IndexDefine;
import kd.bos.xdb.tablemanager.AbstractTableManager;
import kd.bos.xdb.tablemanager.LockCreateTableCall;
import kd.bos.xdb.tablemanager.PkTypeEnum;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.xpm.metrics.action.sharding.table.ExistsTableSpan;
import kd.bos.xdb.xpm.metrics.action.sharding.table.LoadShardingTableSpan;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;

public class MySQLTableManager
extends AbstractTableManager {
    @Override
    public boolean existTable(String tableName) throws SQLException {
        ExistsTableSpan span = null;
        MetricsCollector mc = MetricsCollector.getCurrent();
        if (mc.isActionMetricEnabled()) {
            span = new ExistsTableSpan(tableName);
            mc.actionMetric().stat(span);
        }
        String sql = NoShardingHint.genNoShardingSQL("SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = SCHEMA () AND TABLE_TYPE = 'BASE TABLE' AND (TABLE_NAME = ?)");
        sql = KSQL.dialect(sql);
        try (XDBManageContext xm = XDB.get().withManageContext();){
            ResultSet rs = XDB.get().query(sql, tableName);
            if (rs.next()) {
                rs.close();
                if (span != null) {
                    span.setExists(true);
                }
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Override
    public boolean existTable(String dbRoute, String tableName) throws SQLException {
        String sql = NoShardingHint.genNoShardingSQL("SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = SCHEMA () AND TABLE_TYPE = 'BASE TABLE' AND (TABLE_NAME = ?)");
        sql = KSQL.dialect(sql);
        AtomicBoolean exist = new AtomicBoolean(false);
        try (XDBExternal xdbe = XDBExternal.requiresNew("existTable");){
            xdbe.query(dbRoute, sql, new Object[]{tableName}, rs -> {
                try {
                    if (rs.next()) {
                        exist.set(true);
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    throw ExceptionUtil.wrap(e);
                }
            });
        }
        return exist.get();
    }

    @Override
    public String[] getShardingTable(String tableName) throws SQLException {
        LoadShardingTableSpan span = null;
        MetricsCollector mc = MetricsCollector.getCurrent();
        if (mc.isActionMetricEnabled()) {
            span = new LoadShardingTableSpan(tableName);
            mc.actionMetric().stat(span);
        }
        String sql = NoShardingHint.genNoShardingSQL("SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = SCHEMA () AND TABLE_TYPE = 'BASE TABLE' AND (TABLE_NAME LIKE ?)");
        sql = KSQL.dialect(sql);
        TableName tn = TableName.of(tableName);
        String p = tn.getAliasName() + "$" + "%";
        ArrayList<String> ret = new ArrayList<String>();
        try (XDBManageContext xm = XDB.get().withManageContext();){
            ResultSet rs = XDB.get().query(sql, p);
            while (rs.next()) {
                String t = rs.getString(1);
                if (!TableName.of(t).isDataTable()) continue;
                ret.add(t);
            }
            rs.close();
        }
        if (span != null) {
            span.setShardingTables(ret);
        }
        return ret.toArray(new String[ret.size()]);
    }

    @Override
    public String[] getShardingTable(String dbRoute, String tableName) throws SQLException {
        LoadShardingTableSpan span = null;
        MetricsCollector mc = MetricsCollector.getCurrent();
        if (mc.isActionMetricEnabled()) {
            span = new LoadShardingTableSpan(tableName);
            mc.actionMetric().stat(span);
        }
        String sql = NoShardingHint.genNoShardingSQL("SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = SCHEMA () AND TABLE_TYPE = 'BASE TABLE' AND (TABLE_NAME LIKE ?)");
        sql = KSQL.dialect(sql);
        TableName tn = TableName.of(tableName);
        String p = tn.getAliasName() + "$" + "%";
        ArrayList<String> ret = new ArrayList<String>();
        try (XDBManageContext xm = XDB.get().withManageContext();
             XDBExternal xdbe = XDBExternal.requiresNew("getShardingTable");){
            xdbe.query(dbRoute, sql, new Object[]{p}, rs -> {
                try {
                    while (rs.next()) {
                        String t = rs.getString(1);
                        if (!TableName.of(t).isDataTable()) continue;
                        ret.add(t);
                    }
                    rs.close();
                }
                catch (SQLException e) {
                    throw ExceptionUtil.wrap(e);
                }
            });
        }
        if (span != null) {
            span.setShardingTables(ret);
        }
        return ret.toArray(new String[ret.size()]);
    }

    @Override
    public String[] getMovingTable(String tableName) throws SQLException {
        String sql = NoShardingHint.genNoShardingSQL("SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = SCHEMA () AND TABLE_TYPE = 'BASE TABLE' AND (TABLE_NAME LIKE ?)");
        sql = KSQL.dialect(sql);
        TableName tn = TableName.of(tableName);
        String p = tn.getAliasName() + "$M" + "%";
        ArrayList<String> ret = new ArrayList<String>();
        try (XDBManageContext xm = XDB.get().withManageContext();){
            ResultSet rs = XDB.get().query(sql, p);
            while (rs.next()) {
                String t = rs.getString(1);
                if (!TableName.of(t).isMovingTable()) continue;
                ret.add(t);
            }
            rs.close();
        }
        return ret.toArray(new String[ret.size()]);
    }

    @Override
    public String createRTTable(String tableName) throws SQLException {
        String rtTable = TableName.of(tableName).getRTTable();
        LockCreateTableCall.lockAndCall(rtTable, () -> {
            if (!this.existTable(rtTable)) {
                String sql = NoShardingHint.genNoShardingSQL("create table if not exists " + rtTable + "(findex bigint primary key, froute varchar(50))");
                sql = KSQL.dialect(sql);
                try (XDBExternal xdbe = XDBExternal.requiresNew("xdb.createRTTable");){
                    xdbe.execute(sql);
                }
            }
        });
        return rtTable;
    }

    @Override
    public String createMapTable(String tableName) throws SQLException {
        String mapTable = TableName.of(tableName).getMapTable();
        LockCreateTableCall.lockAndCall(mapTable, () -> {
            if (!this.existTable(mapTable)) {
                String sql = NoShardingHint.genNoShardingSQL("create table if not exists " + mapTable + "(fkey varchar(255) primary key, findex bigint, fdesc varchar(255))");
                sql = KSQL.dialect(sql);
                try (XDBExternal xdbe = XDBExternal.requiresNew("xdb.createMapTable");){
                    xdbe.execute(sql);
                    sql = NoShardingHint.genNoShardingSQL("create index ix_" + mapTable + " on " + mapTable + "(fkey, findex)");
                    sql = KSQL.dialect(sql);
                    xdbe.execute(sql);
                }
            }
        });
        return mapTable;
    }

    @Override
    public String createPKTable(String dbRoute, String tableName, PkTypeEnum type, DataRowsRange drr, IndexDefine[] indexDefines) throws SQLException {
        String pkTable = TableName.of(tableName).getPKTable();
        this.createTable(dbRoute, pkTable, type, drr, indexDefines);
        return pkTable;
    }

    @Override
    public String createPKTempTable(String dbRoute, String tableName, PkTypeEnum type, DataRowsRange drr, IndexDefine[] indexDefines) throws SQLException {
        String pkTempTable = TableName.of(tableName).getPKTempTable();
        this.createTable(dbRoute, pkTempTable, type, drr, indexDefines);
        return pkTempTable;
    }

    private void createTable(String dbRoute, String pkTable, PkTypeEnum type, DataRowsRange drr, IndexDefine[] indexDefines) {
        LockCreateTableCall.lockAndCall(pkTable, () -> {
            if (!this.existTable(dbRoute, pkTable)) {
                StringBuilder sql = new StringBuilder(256).append(KSQL.dialect(NoShardingHint.genNoShardingSQL("create table if not exists " + pkTable + "(fpk " + type.getValue() + ", findex bigint")));
                StringBuilder indexSQL = new StringBuilder(256);
                indexSQL.append(", key ix_pkindex(fpk, findex)");
                if (indexDefines != null && indexDefines.length > 0) {
                    for (IndexDefine def : indexDefines) {
                        sql.append(", ").append(def.getField()).append(' ');
                        indexSQL.append(", key ix_").append(def.getField()).append('(').append(def.getField());
                        switch (def.getType()) {
                            case DATE: {
                                sql.append("datetime");
                                break;
                            }
                            case INTEGER: {
                                sql.append("int default 0");
                                break;
                            }
                            case LONG: {
                                sql.append("bigint default 0");
                                break;
                            }
                            case STRING: {
                                sql.append("varchar(255) default ' '");
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException("XDB unsupported index field type: " + (Object)((Object)def.getType()));
                            }
                        }
                        indexSQL.append(')');
                    }
                }
                sql.append((CharSequence)indexSQL);
                sql.append(')');
                int p = drr.getPartitions();
                if (p > 0 && type == PkTypeEnum.pk_long) {
                    sql.append(" partition by hash(fpk) partitions ").append(p);
                }
                try (XDBExternal xdbe = XDBExternal.requiresNew("xdb.createPKTable");){
                    xdbe.execute(dbRoute, sql.toString());
                }
            }
        });
    }

    @Override
    public String createMovingTable(String tableName, long shardingIndex, PkTypeEnum type) throws SQLException {
        String movingTable = TableName.of(tableName).getMovingTable(shardingIndex);
        LockCreateTableCall.lockAndCall(movingTable, () -> {
            if (!this.existTable(movingTable)) {
                String sql = NoShardingHint.genNoShardingSQL("create table if not exists " + movingTable + "(fid " + type.getValue() + ")");
                sql = KSQL.dialect(sql);
                try (XDBExternal xdbe = XDBExternal.requiresNew("xdb.createMovingTable");){
                    xdbe.execute(sql);
                    sql = NoShardingHint.genNoShardingSQL("create index ix_" + movingTable + " on " + movingTable + "(fid)");
                    sql = KSQL.dialect(sql);
                    xdbe.execute(sql);
                }
            }
        });
        return movingTable;
    }
}

