/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.tablemanager.tableversion;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.util.ConfigurationUtil;
import kd.bos.xdb.tablemanager.tableversion.TableVersionUpdator;
import kd.bos.xdb.util.ConcurrentHashSet;

public final class DistributeTableVersionUpdator
implements TableVersionUpdator {
    private static int timeout = 1440;
    private final String keyPrefix;
    private DistributeCacheHAPolicy distributeCacheHAPolicy = new DistributeCacheHAPolicy(true, false);
    private DistributeSessionlessCache globalCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("XDB", this.distributeCacheHAPolicy);
    private Set<String> maskSet = new ConcurrentHashSet<String>();

    public DistributeTableVersionUpdator(String tentantAccountKey) {
        this.keyPrefix = "XDB#TableVersion#" + tentantAccountKey + '#';
    }

    @Override
    public long getLastVersion(String tableName) {
        String s = (String)this.globalCache.get(this.accountTableNameKey(tableName));
        if (s != null) {
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        long cur = System.currentTimeMillis();
        this.globalCache.put(this.accountTableNameKey(tableName), (Object)String.valueOf(cur), timeout, TimeUnit.MINUTES);
        return cur;
    }

    @Override
    public long incVersion(String tableName) {
        return this.globalCache.inc(this.accountTableNameKey(tableName), timeout, TimeUnit.MINUTES);
    }

    @Override
    public void maskIncVersion(String tableName) {
        this.maskSet.add(this.accountTableNameKey(tableName));
    }

    @Override
    public void unmaskIncVersion(String tableName) {
        this.maskSet.remove(this.accountTableNameKey(tableName));
    }

    @Override
    public boolean isMaskIncVersion(String tableName) {
        return this.maskSet.contains(this.accountTableNameKey(tableName));
    }

    private final String accountTableNameKey(String tableName) {
        return this.keyPrefix + tableName;
    }

    static {
        ConfigurationUtil.observeInteger((String)"xdb.tableversion.timeout", (int)timeout, v -> {
            timeout = v;
        });
    }
}

