/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.temptable.facade;

import java.util.ArrayList;
import java.util.List;
import kd.bos.xdb.temptable.facade.TemptableFacade;
import kd.bos.xdb.temptable.facade.TemptableFacadeContexts;

public class TemptableFacadeContext
implements AutoCloseable {
    private final TemptableFacadeContext parent;
    private final List<TemptableFacade> tableList = new ArrayList<TemptableFacade>();
    private final String tag;

    TemptableFacadeContext(String tag) {
        this.parent = TemptableFacadeContexts.get();
        TemptableFacadeContexts._set(this);
        this.tag = tag;
    }

    public void addAll(List<TemptableFacade> list) {
        if (list == null) {
            return;
        }
        this.tableList.addAll(list);
    }

    public void add(TemptableFacade table) {
        this.tableList.add(table);
    }

    public List<TemptableFacade> getTableList() {
        return new ArrayList<TemptableFacade>(this.tableList);
    }

    public boolean isTableListEmpty() {
        for (TemptableFacadeContext ctx = this; ctx != null; ctx = ctx.getParent()) {
            if (ctx.tableList.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public TemptableFacade getTemptableFacadeByName(String name) {
        for (TemptableFacadeContext ctx = this; ctx != null; ctx = ctx.getParent()) {
            List<TemptableFacade> tables = ctx.tableList;
            for (TemptableFacade table : tables) {
                if (!table.getName().equals(name)) continue;
                return table;
            }
        }
        return null;
    }

    public TemptableFacadeContext getParent() {
        return this.parent;
    }

    @Override
    public void close() {
        TemptableFacadeContexts._set(this.parent);
        this.tableList.clear();
    }
}

